/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.function.server.action.pub;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.bean.PasswordManager;
import bitel.billing.server.util.MailMsg;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebContractSearchModule;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.function.server.action.pub.BaseAction;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class ActionAccessRestore
extends BaseAction {
    private Logger logger = LogManager.getLogger();

    public void doHintSearch() {
        JSONObject jsonObject = new JSONObject();
        JSONArray array = new JSONArray();
        JSONObject addressJson = new JSONObject();
        addressJson.put("contractId", 1);
        addressJson.put("houseId", 1);
        addressJson.put("address", (Object)"443099. \u0433. \u0421\u0430\u043c\u0430\u0440\u0430, \u0443\u043b. \u0410\u043b\u0435\u043a\u0441\u0435\u044f \u0422\u043e\u043b\u0441\u0442\u043e\u0433\u043e, \u0434. 87, \u043a\u043e\u043c. 31");
        array.put((Object)addressJson);
        addressJson = new JSONObject();
        addressJson.put("contractId", 1);
        addressJson.put("houseId", 1);
        addressJson.put("address", (Object)"443099. \u0433. \u0421\u0430\u043c\u0430\u0440\u0430, \u0443\u043b. \u0410\u043b\u0435\u043a\u0441\u0435\u044f \u0422\u043e\u043b\u0441\u0442\u043e\u0433\u043e, \u0434. 87, \u043a\u043e\u043c. 32");
        array.put((Object)addressJson);
        jsonObject.put("result", (Object)array);
        this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.json.toString());
        this.context.getRequest().setAttribute("json", (Object)jsonObject);
    }

    @Override
    public void execute() throws BGException {
        String paramEmail = this.req.get("email");
        String paramContract = this.req.get("contract");
        String paramButton = this.req.get("button", "restore");
        this.context.getRequest().setAttribute("pageTitle", (Object)"\u0412\u043ec\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0432 \u041b\u041a");
        this.context.getRequest().setAttribute("jspPage", (Object)"contract/password_restore.jsp");
        this.context.getRequest().setAttribute("userName", (Object)paramContract);
        this.context.getRequest().setAttribute("buttonSelectKey", (Object)paramButton);
        this.context.getRequest().setAttribute("contentType", (Object)ActionResultContentType.jsp.toString());
        if (this.context.getRequest().getSession().getAttribute("searchModules") == null) {
            ArrayList<KeyValue> searchModules = new ArrayList<KeyValue>();
            DynamicCodeDao dynamicCodeDao = new DynamicCodeDao(this.con);
            List<String> classesName = dynamicCodeDao.getActualClassesByInterface(WebContractSearchModule.class.getName());
            for (String className : classesName) {
                WebContractSearchModule webContractSearchModule = DynamicClassManager.getInstance().newInstance(WebContractSearchModule.class, className);
                webContractSearchModule.init(this.con);
                if (!webContractSearchModule.useForAccessRestore()) continue;
                searchModules.add(new KeyValue(className, webContractSearchModule.getTitle()));
            }
            this.context.getRequest().getSession().setAttribute("searchModules", searchModules);
        }
        if (!"restore".equals(paramButton)) {
            this.doSearchContract(paramButton);
        }
        if (paramContract != null) {
            Contract contract = null;
            try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
                contract = contractDao.getByTitle(paramContract);
            }
            if (contract == null) {
                this.setError("contractNotFound");
                return;
            }
            int paramId = this.setup.getInt("contract.password.forgot.email.param.id", -1);
            ContractParameterManager contractParameterManager = new ContractParameterManager(this.con);
            String contractEmail = contractParameterManager.getEmailFromParam(contract.getId(), paramId);
            if (contractEmail == null) {
                this.setError("emailNotFound");
                return;
            }
            if (paramEmail != null) {
                if (!this.checkEmail(paramEmail, contractEmail)) {
                    this.setError("emailNotValid");
                    this.context.getRequest().setAttribute("errorEmail", (Object)paramEmail);
                } else {
                    Integer authMode;
                    PasswordManager passwordManager = new PasswordManager(this.con);
                    long passwordExpireHour = this.setup.getLong("contract.password.forgot.expire.hour", 24L);
                    Object emailLink = this.setup.get("contract.password.forgot.link", "http://localhost:8080/bgbilling/webexecuter?action=ChangePassword&mid=contract&passwordOnce=${password}");
                    String emailSubject = this.setup.get("contract.password.forgot.email.subject", "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u043e\u043b\u044f");
                    String emailText = this.setup.get("contract.password.forgot.email.body", "\u0414\u043b\u044f \u0432\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u043e\u043b\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 {contract} - \u043f\u0435\u0440\u0435\u0439\u0434\u0438\u0442\u0435 \u043f\u043e \u0441\u0441\u044b\u043b\u043a\u0435 \u043d\u0438\u0436\u0435 (\u0432 \u0442\u0435\u0447\u0435\u043d\u0438\u0438 {hour} \u0447\u0430\u0441\u043e\u0432) \u0438 \u0441\u043c\u0435\u043d\u0438\u0442\u0435 \u043f\u0430\u0440\u043e\u043b\u044c.");
                    String charArray = this.setup.get("contract.password.forgot.char.array", "1234567890QWERTYUIOPLKJHGFDSAZXCVBNMqwertyuioplkjhgfdsazxcvbnm");
                    String password = passwordManager.getOncePassword(charArray);
                    HashMap<Integer, Integer> authModes = new HashMap<Integer, Integer>();
                    String modes = this.setup.get("web.auth.modes", null);
                    if (modes != null) {
                        for (String parts : modes.split(";")) {
                            String[] mid_mode = parts.split(":");
                            if (mid_mode.length != 2) continue;
                            authModes.put(Utils.parseInt(mid_mode[0].trim(), 0), Utils.parseInt(mid_mode[1].trim(), 0));
                        }
                    }
                    if ((authMode = (Integer)authModes.get(0)) != null && authMode > 0 && authMode < 3) {
                        if (authMode == 1) {
                            passwordManager.deleteByContract(contract.getTitle());
                            passwordManager.addPassword(contract.getTitle(), passwordExpireHour, password);
                        } else if (authMode == 2) {
                            paramId = this.setup.getInt("web.auth.contract.text.parameter", 0);
                            if (paramId > 0) {
                                String value = new ContractParameterManager(this.con).getTextlikeParam(contract.getId(), paramId);
                                passwordManager.deleteByContract(value);
                                passwordManager.addPassword(value, passwordExpireHour, password);
                            } else {
                                this.logger.error("Not set parameter 'web.auth.contract.text.parameter' in config!");
                            }
                        }
                        emailText = emailText.replaceAll("\\{contract\\}", contract.getTitle());
                        emailText = emailText.replaceAll("\\{hour\\}", String.valueOf(passwordExpireHour));
                        try {
                            password = URLEncoder.encode(password, "utf-8");
                        }
                        catch (UnsupportedEncodingException ex) {
                            this.logger.error("password URLEncoder -> " + ex.getLocalizedMessage());
                        }
                        emailLink = ((String)emailLink).contains("${password}") ? ((String)emailLink).replaceAll("\\$\\{password\\}", password) : (String)emailLink + "&passwordOnce=" + password;
                        new MailMsg((Preferences)this.setup).sendMessage(contractEmail, emailSubject, emailText + "\n" + (String)emailLink);
                        this.context.getRequest().setAttribute("status", (Object)"ok");
                    } else {
                        this.setError("authModeNotSetByContract");
                        this.context.getRequest().setAttribute("errorEmail", (Object)paramEmail);
                    }
                }
            } else {
                this.getMaskEmails(contractEmail);
            }
        }
    }

    private boolean checkEmail(String email, String emailList) {
        boolean result;
        block1: {
            String token;
            result = false;
            if (email == null || emailList == null) break block1;
            StringTokenizer st = new StringTokenizer(emailList, "\n");
            email = email.toLowerCase();
            while (st.hasMoreTokens() && !(result = (token = st.nextToken().toLowerCase()).equals(email) || token.indexOf("<" + email + ">") > -1)) {
            }
        }
        return result;
    }

    private void getMaskEmails(String emails) {
        String[] emailsArray;
        ArrayList<String> maskEmail = new ArrayList<String>();
        Pattern patternEmail = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 2);
        for (String email : emailsArray = emails.split("\n")) {
            String emailString = "";
            if (email.indexOf("<") == -1) {
                Matcher matcherEmail = patternEmail.matcher(email);
                if (matcherEmail.find()) {
                    emailString = matcherEmail.group();
                    if (matcherEmail.find()) {
                        emailString = email;
                    }
                }
            } else {
                int index = email.indexOf("<");
                Matcher matcherEmail = patternEmail.matcher(email.substring(index, email.length()));
                if (matcherEmail.find()) {
                    emailString = matcherEmail.group();
                }
            }
            maskEmail.add(Utils.maskEmail(emailString));
        }
        this.context.getRequest().setAttribute("maskEmail", maskEmail);
    }
}

