/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree;

import bitel.billing.server.tariff.TimeLimits;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class TimeFilterTariffTreeNode
extends TariffTreeNode<AbstractTariffRequest<?>, TariffContext, TreeContext, ThreadContext> {
    private final List<TimeLimits> _timeLimits = new ArrayList<TimeLimits>();
    private final int timeRange;

    public TimeFilterTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        for (Map.Entry<String, String> values : parameterMap.entrySet()) {
            if (Utils.parseInt(values.getKey(), -1) < 0) continue;
            String limitStr = values.getValue();
            this._timeLimits.add(new TimeLimits(limitStr));
        }
        this.timeRange = parameterMap.getInt("time_range", -1);
    }

    private boolean checkTime(Calendar time) {
        boolean result = false;
        int size = this._timeLimits.size();
        if (size == 0) {
            result = true;
        } else {
            TimeLimits tl;
            for (int i = 0; i < size && !(result = (tl = this._timeLimits.get(i)).checkDate(time)); ++i) {
            }
        }
        return result;
    }

    @Override
    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, AbstractTariffRequest<?> req, TariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        Calendar time = req.getTime();
        Set<Long> acceptedSet = req.getAcceptedSet(TimeFilterTariffTreeNode.class);
        if (time != null && !acceptedSet.contains(parentTreeNodeId) && this.checkTime(time)) {
            if (this.timeRange > 0) {
                req.setTimeRangeId(this.timeRange);
            }
            acceptedSet.add(parentTreeNodeId);
            return 1;
        }
        return 0;
    }
}

