/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.list;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class BGUCheckList<I extends Id>
extends JPanel {
    private DefaultListModel<ListItem> listModel = new DefaultListModel();
    private final JList<? extends ListItem> list = new JList<ListItem>(this.listModel);
    private JPanel panel = new JPanel(new GridLayout(1, 0, 5, 0));
    private BGButton buttonInvertSelect = new BGButton();
    private BGButton buttonClearSelect = new BGButton();
    private BGButton buttonAllSelect = new BGButton();

    public BGUCheckList() {
        this(false);
    }

    public BGUCheckList(boolean single) {
        super(new GridBagLayout());
        this.add((Component)new JScrollPane(this.list), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonAllSelect.setActionCommand("all");
        this.buttonAllSelect.setMargin(new Insets(2, 2, 2, 2));
        this.buttonAllSelect.setText("\u0412\u0441\u0435");
        this.buttonAllSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUCheckList.this.buttonAllSelect_actionPerformed(actionEvent);
            }
        });
        this.buttonClearSelect.setActionCommand("clear");
        this.buttonClearSelect.setMargin(new Insets(2, 2, 2, 2));
        this.buttonClearSelect.setText("\u0421\u0431\u0440\u043e\u0441");
        this.buttonClearSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUCheckList.this.buttonClearSelect_actionPerformed(actionEvent);
            }
        });
        this.buttonInvertSelect.setMargin(new Insets(2, 2, 2, 2));
        this.buttonInvertSelect.setText("\u0418\u043d\u0432\u0435\u0440\u0442.");
        this.buttonInvertSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUCheckList.this.buttonInvertSelect_actionPerformed(actionEvent);
            }
        });
        this.panel.add(this.buttonAllSelect);
        this.panel.add(this.buttonClearSelect);
        this.panel.add(this.buttonInvertSelect);
        this.add((Component)this.panel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.list.setCellRenderer(new CheckListCellRenderer());
        this.list.setSelectionMode(0);
        if (single) {
            new CheckListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    BGUCheckList.this.firePropertyChange("itemChange", "1", "2");
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    BGUCheckList.this.firePropertyChange("itemChange", "1", "2");
                }

                @Override
                protected void doCheck(int index) {
                    if (index > -1 && BGUCheckList.this.list.isEnabled()) {
                        ListItem item = BGUCheckList.this.listModel.getElementAt(index);
                        if (!item.selected) {
                            BGUCheckList.this.setSelected(null);
                        }
                        item.selected = !item.selected;
                        BGUCheckList.this.list.repaint();
                    }
                }
            };
            this.setButtonPanelVisible(false);
        } else {
            new CheckListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    super.keyPressed(e);
                    BGUCheckList.this.firePropertyChange("itemChange", "1", "2");
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    BGUCheckList.this.firePropertyChange("itemChange", "1", "2");
                }
            };
        }
    }

    private void buttonInvertSelect_actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            this.listModel.getElementAt(i).invertSelected();
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    private void buttonClearSelect_actionPerformed(ActionEvent e) {
        this.setSelected(false);
    }

    private void buttonAllSelect_actionPerformed(ActionEvent e) {
        this.setSelected(true);
    }

    public void setButtonPanelVisible(boolean b) {
        this.panel.setVisible(b);
    }

    public void setSelected(Collection<?> items) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            ListItem item = this.listModel.getElementAt(i);
            item.selected = items.contains(item.item) || item.item instanceof Id && items.contains(((Id)item.item).getId());
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    public void setSelected(boolean selected) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            this.listModel.getElementAt((int)i).selected = selected;
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    public void clearSelection() {
        this.setSelected(false);
    }

    public Set<I> getSelected() {
        HashSet result = new HashSet();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            ListItem item = this.listModel.getElementAt(i);
            if (!item.selected) continue;
            result.add(item.item);
        }
        return result;
    }

    public Set<Integer> getSelectedIds() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            ListItem item = this.listModel.getElementAt(i);
            if (!item.selected) continue;
            result.add(((Id)item.item).getId());
        }
        return result;
    }

    public long getSelectedMask() {
        long result = 0L;
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            ListItem item = this.listModel.getElementAt(i);
            if (!item.selected) continue;
            result |= 1L << ((Id)item.item).getId();
        }
        return result;
    }

    public void setData(List<? extends I> data) {
        this.listModel.removeAllElements();
        if (data != null) {
            for (Id i : data) {
                ListItem item = new ListItem();
                item.item = i;
                this.listModel.addElement(item);
            }
        }
        this.list.repaint();
        this.firePropertyChange("itemChange", "1", "2");
    }

    public JList<? extends ListItem> getList() {
        return this.list;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.list.setEnabled(enabled);
        this.list.setBackground(enabled ? Color.WHITE : Color.LIGHT_GRAY);
        this.buttonAllSelect.setEnabled(enabled);
        this.buttonClearSelect.setEnabled(enabled);
        this.buttonInvertSelect.setEnabled(enabled);
    }

    private class CheckListCellRenderer
    extends JCheckBox
    implements ListCellRenderer<ListItem> {
        Border m_noFocusBorder = new EmptyBorder(1, 5, 1, 5);

        public CheckListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.m_noFocusBorder);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ListItem> list, ListItem value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            this.setText(value.toString());
            this.setSelected(value.selected);
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            return this;
        }
    }

    private class ListItem {
        I item;
        boolean selected;

        private ListItem() {
        }

        void invertSelected() {
            this.selected = !this.selected;
        }

        public String toString() {
            if (this.item instanceof IdTitle) {
                return ((IdTitle)this.item).getTitle();
            }
            return String.valueOf(this.item);
        }
    }

    private class CheckListener
    extends MouseAdapter
    implements MouseListener,
    KeyListener {
        public CheckListener() {
            BGUCheckList.this.list.addMouseListener(this);
            BGUCheckList.this.list.addKeyListener(this);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyChar() == ' ') {
                this.doCheck(BGUCheckList.this.list.getSelectedIndex());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doCheck(BGUCheckList.this.list.locationToIndex(e.getPoint()));
        }

        protected void doCheck(int index) {
            if (index > -1 && BGUCheckList.this.list.isEnabled()) {
                ListItem item = BGUCheckList.this.listModel.getElementAt(index);
                item.selected = !item.selected;
                BGUCheckList.this.list.repaint();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

