/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import bitel.billing.server.contract.object.bean.ObjectType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ObjectTypeManager {
    private Connection con;
    private static final String TABLE_NAME = "object_type";
    private static final String TABLE_NAME_MODULE = "object_type_module";

    public ObjectTypeManager(Connection con) {
        this.con = con;
    }

    public Map<Integer, ObjectType> getTypeMap() {
        HashMap<Integer, ObjectType> result = new HashMap<Integer, ObjectType>();
        try {
            String query = "SELECT * FROM object_type";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ObjectType type = this.getTypeFromRs(rs);
                result.put(type.getId(), type);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ObjectType> getTypeList(boolean onlyVisible) {
        ArrayList<ObjectType> result = new ArrayList<ObjectType>();
        try {
            Object query = "SELECT * FROM object_type";
            if (onlyVisible) {
                query = (String)query + " WHERE ishidden=0";
            }
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getTypeFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ObjectType getType(int id) {
        ObjectType result = null;
        try {
            String query = "SELECT * FROM object_type WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getTypeFromRs(rs);
            }
            rs.close();
            ps.close();
            if (result != null) {
                ArrayList<Integer> moduleList = new ArrayList<Integer>();
                query = "SELECT mid FROM object_type_module WHERE type_id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, id);
                rs = ps.executeQuery();
                while (rs.next()) {
                    moduleList.add(rs.getInt(1));
                }
                rs.close();
                ps.close();
                result.setModuleList(moduleList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateType(ObjectType type) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (type.getId() <= 0) {
                query = "INSERT INTO object_type (title, name_macros, comment, ishidden) VALUES (?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE object_type SET title=?, name_macros=?, comment=?, ishidden=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, type.getId());
            }
            ps.setString(1, type.getTitle());
            ps.setString(2, type.getNameMakros());
            ps.setString(3, type.getComment());
            ps.setBoolean(4, type.isHidden());
            ps.executeUpdate();
            if (type.getId() <= 0) {
                type.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
            this.deleteTypeModules(type.getId());
            query = "INSERT INTO object_type_module (type_id, mid) VALUES (?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, type.getId());
            for (Integer mid : type.getModuleList()) {
                ps.setInt(2, mid);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteType(int id) {
        try {
            String query = "DELETE FROM object_type WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
            this.deleteTypeModules(id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void deleteTypeModules(int id) throws SQLException {
        String query = "DELETE FROM object_type_module WHERE type_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.executeUpdate();
        ps.close();
    }

    private ObjectType getTypeFromRs(ResultSet rs) throws SQLException {
        ObjectType result = new ObjectType();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setNameMakros(rs.getString("name_macros"));
        result.setComment(rs.getString("comment"));
        result.setHidden(rs.getBoolean("ishidden"));
        return result;
    }
}

