/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.events.PersonalTariffTreeUpdateEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.TariffTreeModifiedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class TariffTreeBuilder {
    private static final Logger log = LogManager.getLogger();
    public static final int TREE_FOR_TP = 1;
    public static final int TREE_FOR_CID = 2;
    private Connection con;
    private static final long UPDATE_TIMEOUT = 8000L;
    private static final long CHECK_INTERVAL = 9000L;
    private static final Object CREATE_UPDATER_MUTEX = new Object();
    private static volatile Thread updaterThread;
    private static Map<Integer, Long> treeUpdateTime;

    public TariffTreeBuilder(Connection con) {
        this.con = con;
    }

    public byte[] getModuleTariffConfig(String module) {
        byte[] byArray;
        block8: {
            InputStream is = TariffTreeBuilder.class.getResourceAsStream("/ru/bitel/bgbilling/modules/" + module + "/common/tariff.xml");
            try {
                byArray = Utils.readByBlock((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    log.error("error get module " + module + " tariff xml", (Throwable)ex);
                    return null;
                }
            }
            is.close();
        }
        return byArray;
    }

    public void linkTree(int id, int mode, int param) {
        try {
            PreparedStatement psDel = null;
            String query = null;
            if (mode == 2) {
                query = "DELETE FROM contract_tree_link WHERE cid=?";
                psDel = this.con.prepareStatement(query);
                psDel.setInt(1, param);
                psDel.executeUpdate();
                psDel.close();
                query = "INSERT INTO contract_tree_link ( cid, tree_id ) VALUES ( ?, ? )";
            } else if (mode == 1) {
                query = "UPDATE tariff_plan SET tree_id=? WHERE id=?";
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, param);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            log.error("error link tariff tree", (Throwable)ex);
        }
    }

    public int createTree() {
        int tree_id = -1;
        try {
            String query = "INSERT INTO tariff_tree () VALUES () ";
            PreparedStatement ps = this.con.prepareStatement(query, 1);
            ps.executeUpdate();
            tree_id = ServerUtils.lastInsertId(ps);
            ps.close();
        }
        catch (Exception ex) {
            log.error("error create tariff tree", (Throwable)ex);
        }
        return tree_id;
    }

    public synchronized boolean addMTreeItems(int treeId, int moduleId, Element tree, boolean editable, int deep) {
        boolean result = false;
        try {
            int mtree = 0;
            int mtreeParent = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT id, parent_tree FROM module_tariff_tree WHERE mid=? AND tree_id=?");
            ps.setInt(1, moduleId);
            ps.setInt(2, treeId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                mtree = rs.getInt(1);
                mtreeParent = rs.getInt(2);
            }
            rs.close();
            ps.close();
            if (mtree > 0) {
                if (mtreeParent != 0) {
                    this.addMTreeItems(mtreeParent, moduleId, tree, false, deep + 1);
                }
                tree.setAttribute("id", String.valueOf(mtree));
                ps = this.con.prepareStatement("SELECT id, type, parent_node, data FROM mtree_node WHERE mtree_id=? ORDER BY pos");
                ps.setInt(1, mtree);
                rs = ps.executeQuery();
                while (rs.next()) {
                    Element item = XMLUtils.createElement((Element)tree, (String)"item");
                    item.setAttribute("id", rs.getString(1));
                    item.setAttribute("type", rs.getString(2));
                    item.setAttribute("parent", rs.getString(3));
                    item.setAttribute("data", rs.getString(4));
                    item.setAttribute("editable", String.valueOf(editable));
                    item.setAttribute("deep", String.valueOf(deep));
                }
                rs.close();
                ps.close();
                result = true;
            }
        }
        catch (Exception ex) {
            log.error("error addMTreeItems", (Throwable)ex);
        }
        return result;
    }

    public String deleteTree(int treeId) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "SELECT COUNT(*) FROM module_tariff_tree WHERE parent_tree=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, treeId);
            ResultSet rsCount = ps.executeQuery();
            if (rsCount.next() && rsCount.getInt(1) > 0) {
                return "\u0423 \u0434\u0435\u0440\u0435\u0432\u0430 \u0438\u043c\u0435\u044e\u0442\u0441\u044f \u043f\u043e\u0442\u043e\u043c\u043a\u0438!";
            }
            ps.close();
            query = "SELECT id FROM module_tariff_tree WHERE tree_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, treeId);
            query = "DELETE FROM mtree_node WHERE mtree_id=?";
            PreparedStatement psDeleteNodes = this.con.prepareStatement(query);
            query = "DELETE FROM module_tariff_tree WHERE id=?";
            PreparedStatement psDeleteModuleTree = this.con.prepareStatement(query);
            query = "DELETE FROM tariff_tree WHERE id=?";
            PreparedStatement psDeleteTariffTree = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int mtreeId = rs.getInt(1);
                psDeleteNodes.setInt(1, mtreeId);
                psDeleteNodes.executeUpdate();
                psDeleteModuleTree.setInt(1, mtreeId);
                psDeleteModuleTree.executeUpdate();
            }
            ps.close();
            psDeleteTariffTree.setInt(1, treeId);
            psDeleteTariffTree.executeUpdate();
            psDeleteNodes.close();
            psDeleteModuleTree.close();
            psDeleteTariffTree.close();
        }
        catch (Exception e) {
            log.error("error delete tariff tree", (Throwable)e);
        }
        return null;
    }

    public String deleteMtree(int treeId, int moduleId) {
        StringBuffer report = new StringBuffer();
        try {
            String query = "SELECT id FROM module_tariff_tree WHERE tree_id=? AND mid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, treeId);
            ps.setInt(2, moduleId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int mtreeId = rs.getInt(1);
                ps.close();
                query = "SELECT tree_id FROM module_tariff_tree WHERE parent_tree=? AND mid=? LIMIT 1";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, treeId);
                ps.setInt(2, moduleId);
                rs = ps.executeQuery();
                if (rs.next() && rs.getInt(1) > 0) {
                    report.append("\u0423 \u043f\u043e\u0434\u0434\u0435\u0440\u0435\u0432\u0430 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u043f\u043e\u0442\u043e\u043c\u043e\u043a: " + this.getTreeRef(rs.getInt(1)));
                    rs.close();
                    ps.close();
                } else {
                    ps.close();
                    query = "DELETE FROM mtree_node WHERE mtree_id=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, mtreeId);
                    ps.executeUpdate();
                    ps.close();
                    query = "DELETE FROM module_tariff_tree WHERE id=?";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, mtreeId);
                    ps.executeUpdate();
                    ps.close();
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            log.error("error deleteMtree treeId=" + treeId + ", moduleId=" + moduleId, (Throwable)e);
            report.append(e.getMessage());
        }
        return report.toString();
    }

    public boolean checkMtree(int treeId, int moduleId) {
        boolean result = false;
        try {
            String query = "SELECT * FROM module_tariff_tree WHERE tree_id=? AND mid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, treeId);
            ps.setInt(2, moduleId);
            result = ps.executeQuery().next();
            ps.close();
        }
        catch (Exception e) {
            log.error("error checkMtree treeId=" + treeId + ", moduleId=" + moduleId, (Throwable)e);
        }
        return result;
    }

    public void createMtree(int treeId, int moduleId, int parentTreeId) {
        try {
            String query = "UPDATE module_tariff_tree SET parent_tree=? WHERE tree_id=? AND mid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, parentTreeId);
            ps.setInt(2, treeId);
            ps.setInt(3, moduleId);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO module_tariff_tree (tree_id, mid, parent_tree) VALUES (?, ?, ?)";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, treeId);
                ps.setInt(2, moduleId);
                ps.setInt(3, parentTreeId);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            log.error("error createMtree treeId=" + treeId + ", moduleId=" + moduleId + ", parentTreeId=" + parentTreeId, (Throwable)e);
        }
    }

    public int createMtreeNode(int mtree, int parent, String type) {
        int pos = this.getMaxPosIntNode(parent);
        ++pos;
        String query = "INSERT INTO mtree_node( parent_node, mtree_id, type, pos, data ) VALUES( ?, ? ,?, ?, '' )";
        int result = -1;
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, parent);
            ps.setInt(2, mtree);
            ps.setString(3, type);
            ps.setInt(4, pos);
            ps.executeUpdate();
            result = ServerUtils.lastInsertId(this.con);
            this.updateMTreeModifTime(mtree);
            ps.close();
        }
        catch (Exception ex) {
            log.error("error createMtreeNode mtree=" + mtree + ", parent=" + parent + ", type=" + type, (Throwable)ex);
        }
        return result;
    }

    public void updateMtreeNode(int id, String data) {
        try {
            String query = "UPDATE mtree_node SET data=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, data);
            ps.setInt(2, id);
            ps.executeUpdate();
            this.updateMTreeModifTime(this.getMtreeIdForNode(id));
            ps.close();
        }
        catch (Exception ex) {
            log.error("error updateMtreeNode id=" + id + ", data=" + data, (Throwable)ex);
        }
    }

    public void deleteMtreeNode(int code) {
        try {
            this.updateMTreeModifTime(this.getMtreeIdForNode(code));
            String query = "SELECT id FROM mtree_node WHERE parent_node=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, code);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.deleteMtreeNode(rs.getInt(1));
            }
            rs.close();
            ps.close();
            query = "DELETE FROM mtree_node WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, code);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            log.error("error deleteMtreeNode code=" + code, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createUpdaterThread() {
        Object object = CREATE_UPDATER_MUTEX;
        synchronized (object) {
            if (updaterThread == null) {
                updaterThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    long current = System.currentTimeMillis();
                                    for (Map.Entry<Integer, Long> me : treeUpdateTime.entrySet()) {
                                        if (me.getValue() >= current) continue;
                                        Connection con = Setup.getSetup().getDBConnectionFromPool();
                                        try {
                                            int mtreeId = me.getKey();
                                            if (log.isDebugEnabled()) {
                                                log.debug("Update modif time for mtree: " + mtreeId);
                                            }
                                            TariffTreeBuilder.updateMTreeModifTimeInBase(con, mtreeId);
                                            treeUpdateTime.remove(mtreeId);
                                        }
                                        finally {
                                            ServerUtils.closeConnection(con);
                                        }
                                    }
                                    1.sleep(9000L);
                                }
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                };
                updaterThread.start();
            }
        }
    }

    private static void updateMTreeModifTimeInBase(Connection con, int mtree_id) {
        try {
            String query = "SELECT tree_id, mid FROM module_tariff_tree WHERE id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, mtree_id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int tree_id = rs.getInt(1);
                int mid = rs.getInt(2);
                TariffTreeBuilder.updateMTreeModifTime(con, mtree_id, tree_id, mid);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            log.error("error updateMTreeModifTimeInBase mtree_id=" + mtree_id, (Throwable)ex);
        }
    }

    private static void updateMTreeModifTime(Connection con, int mtree_id, int tree_id, int mid) {
        try {
            String query = "UPDATE module_tariff_tree SET lm=? WHERE id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setLong(1, System.currentTimeMillis());
            ps.setInt(2, mtree_id);
            ps.executeUpdate();
            ps.close();
            query = "SELECT id FROM tariff_tree WHERE parent_tree=?";
            ps = con.prepareStatement(query);
            ps.setInt(1, tree_id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int child_tree_id = rs.getInt(1);
                query = "SELECT id FROM module_tariff_tree WHERE tree_id=? AND mid=?";
                PreparedStatement ps2 = con.prepareStatement(query);
                ps2.setInt(1, child_tree_id);
                ps2.setInt(2, mid);
                ResultSet rsMtreeData = ps2.executeQuery();
                if (rsMtreeData.next()) {
                    int child_mtree_id = rsMtreeData.getInt(1);
                    TariffTreeBuilder.updateMTreeModifTime(con, child_mtree_id, child_tree_id, mid);
                }
                rsMtreeData.close();
                ps2.close();
            }
            rs.close();
            ps.close();
            query = "SELECT id, tree_id, mid FROM module_tariff_tree WHERE parent_tree=?";
            ps = con.prepareStatement(query);
            ps.setInt(1, tree_id);
            rs = ps.executeQuery();
            while (rs.next()) {
                int childMtreeId = rs.getInt(1);
                int childTreeId = rs.getInt(2);
                int childMid = rs.getInt(3);
                TariffTreeBuilder.updateMTreeModifTime(con, childMtreeId, childTreeId, childMid);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            log.error("error updateMTreeModifTime mtree_id=" + mtree_id + ", tree_id=" + tree_id + ", mid=" + mid, (Throwable)ex);
        }
    }

    private void updateMTreeModifTime(int mtree_id) {
        TariffTreeBuilder.createUpdaterThread();
        if (log.isDebugEnabled()) {
            log.debug("Set mtree: " + mtree_id + " on update.");
        }
        treeUpdateTime.put(mtree_id, System.currentTimeMillis() + 8000L);
    }

    public void getMtreeModifiedEvents(int mtreeId, int userId, List<TariffTreeModifiedEvent> events) throws BGException {
        try {
            String query = "SELECT tree_id, mid FROM module_tariff_tree WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mtreeId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int treeId = rs.getInt(1);
                int moduleId = rs.getInt(2);
                events.add(new TariffTreeModifiedEvent(moduleId, treeId, userId));
                this.getMtreeModifiedEvents(treeId, moduleId, userId, events);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void getMtreeModifiedEvents(int parentTreeId, int mid, int userId, List<TariffTreeModifiedEvent> events) throws BGException {
        try {
            String query = "SELECT tree_id FROM module_tariff_tree WHERE parent_tree=? AND mid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, parentTreeId);
            ps.setInt(2, mid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int treeId = rs.getInt(1);
                events.add(new TariffTreeModifiedEvent(mid, treeId, userId));
                this.getMtreeModifiedEvents(treeId, mid, userId, events);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private int getMtreeIdForNode(int node_id) {
        int result = -1;
        try {
            String query = "SELECT mtree_id FROM mtree_node WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, node_id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public long getLastModificationTimeForTree(int treeId, int mid) {
        long result = 0L;
        try {
            String query = "SELECT id FROM module_tariff_tree WHERE mid=? AND tree_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mid);
            ps.setInt(2, treeId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int mtree_id = rs.getInt(1);
                ps.close();
                query = "SELECT lm FROM module_tariff_tree WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, mtree_id);
                rs = ps.executeQuery();
                if (rs.next()) {
                    result = rs.getLong(1);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void setNodePos(int code, int pos) {
        try {
            String query = "UPDATE mtree_node SET pos=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, pos);
            ps.setInt(2, code);
            ps.executeUpdate();
            this.updateMTreeModifTime(this.getMtreeIdForNode(code));
            ps.close();
        }
        catch (Exception ex) {
            log.error("error set node pos code=" + code + ", pos=" + pos, (Throwable)ex);
        }
    }

    public int getNodePos(int code) {
        int result = -1;
        try {
            String query = "SELECT pos FROM mtree_node WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && rs.getObject(1) != null) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            log.error("error get node pos code=" + code, (Throwable)ex);
        }
        return result;
    }

    private int getMaxPosIntNode(int code) {
        int result = -1;
        try {
            String query = "SELECT MAX(pos) FROM mtree_node WHERE parent_node=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, code);
            ResultSet rs = ps.executeQuery();
            if (rs.next() && rs.getObject(1) != null) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            log.error("error get max pos int node code=" + code, (Throwable)ex);
        }
        return result;
    }

    public void changeParent(int id, int new_parent) {
        try {
            int pos = this.getMaxPosIntNode(new_parent);
            String query = "UPDATE mtree_node SET parent_node=?, pos=? WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, new_parent);
            ps.setInt(2, ++pos);
            ps.setInt(3, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            log.error("error change parent id=" + id, (Throwable)ex);
        }
    }

    public int cloneNode(int id, int parent_id) {
        int result = -1;
        try {
            String query = "SELECT mtree_id, type, data, pos FROM mtree_node WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            int pos = this.getMaxPosIntNode(parent_id);
            if (rs.next()) {
                ps.close();
                query = "INSERT INTO mtree_node ( parent_node, mtree_id, type, data, pos ) VALUES ( ?, ?, ?, ?, ? )";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(1, parent_id);
                ps.setInt(2, rs.getInt("mtree_id"));
                ps.setString(3, rs.getString("type"));
                ps.setString(4, rs.getString("data"));
                ps.setInt(5, rs.getInt(++pos));
                ps.executeUpdate();
                result = ServerUtils.lastInsertId(ps);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            log.error("error clone node id=" + id, (Throwable)ex);
        }
        return result;
    }

    public boolean checkOrderChildren(int parentId, int treeId) throws BGException {
        try {
            String query = "SELECT pos, mtree_id FROM mtree_node WHERE parent_node=? AND mtree_id=? ORDER BY pos";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, parentId);
            ps.setInt(2, treeId);
            ResultSet rs = ps.executeQuery();
            int previous = 0;
            if (rs.next()) {
                previous = rs.getInt(1);
            } else {
                rs.close();
                ps.close();
                return true;
            }
            while (rs.next()) {
                if (previous == rs.getInt(1)) {
                    rs.close();
                    ps.close();
                    return false;
                }
                previous = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException();
        }
        return true;
    }

    public void fixOrder(int parentId, int treeId) throws BGException {
        try {
            String query = "SELECT id FROM mtree_node WHERE parent_node=? AND mtree_id=? ORDER BY pos";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, parentId);
            ps.setInt(2, treeId);
            ResultSet rs = ps.executeQuery();
            int pos = 0;
            while (rs.next()) {
                this.setNodePos(rs.getInt(1), pos++);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException();
        }
    }

    public boolean checkOneTree(int node1, int node2) throws BGException {
        try {
            if (this.getMtreeIdForNode(node1) != this.getMtreeIdForNode(node2)) {
                return false;
            }
        }
        catch (Exception ex) {
            throw new BGException();
        }
        return true;
    }

    public String getTreeRef(int tree_id) throws SQLException {
        Object ref = "";
        String query = "SELECT title FROM tariff_plan WHERE tree_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, tree_id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            ref = "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d '" + rs.getString(1) + "'";
            rs.close();
            ps.close();
        } else {
            ps.close();
            query = "SELECT t1.title, t2.title FROM contract AS t1, contract_tree_link AS t2 WHERE t2.tree_id=? AND t2.cid=t1.id";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, tree_id);
            rs = ps.executeQuery();
            if (rs.next()) {
                ref = "\u0422\u0430\u0440\u0438\u0444 '" + rs.getString(2) + "' \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 '" + rs.getString(1) + "'";
            }
            rs.close();
            ps.close();
        }
        return ref;
    }

    public int getCidForNode(int nodeId) {
        int result = -1;
        try {
            String query = "SELECT contract_tree_link.cid FROM mtree_node LEFT JOIN module_tariff_tree ON module_tariff_tree.id= mtree_node.mtree_id LEFT JOIN contract_tree_link ON contract_tree_link.tree_id= module_tariff_tree.tree_id WHERE mtree_node.id =?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, nodeId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            log.error("error get cid for node nodeId=" + nodeId, (Throwable)e);
        }
        return result;
    }

    public int getCidForMTree(int mTreeId) {
        int result = -1;
        try {
            String query = "SELECT contract_tree_link.cid FROM module_tariff_tree LEFT JOIN contract_tree_link ON contract_tree_link.tree_id= module_tariff_tree.tree_id WHERE module_tariff_tree.id =?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mTreeId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            log.error("error get cid for MTree mTreeId=" + mTreeId, (Throwable)e);
        }
        return result;
    }

    public void createPersonalTariffTreeUpdateEvent(int userId, int nodeId, int mTreeId, int treeId, ServerContext context) throws SQLException, BGException {
        String query;
        int cid = 0;
        int ptid = 0;
        PreparedStatement ps = null;
        if (nodeId != -1) {
            query = "SELECT contract_tree_link.id, contract_tree_link.cid FROM mtree_node LEFT JOIN module_tariff_tree ON module_tariff_tree.id= mtree_node.mtree_id LEFT JOIN contract_tree_link ON contract_tree_link.tree_id= module_tariff_tree.tree_id WHERE mtree_node.id =?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, nodeId);
        } else if (mTreeId != -1) {
            query = "SELECT contract_tree_link.id, contract_tree_link.cid FROM module_tariff_tree LEFT JOIN contract_tree_link ON contract_tree_link.tree_id= module_tariff_tree.tree_id WHERE module_tariff_tree.id =?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, mTreeId);
        } else if (treeId != -1) {
            query = "SELECT contract_tree_link.id, contract_tree_link.cid FROM contract_tree_link WHERE contract_tree_link.tree_id =?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, treeId);
        }
        if (ps != null) {
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                ptid = rs.getInt(1);
                cid = rs.getInt(2);
            }
            ps.close();
        }
        if (ptid != 0 && cid != 0) {
            context.publishAfterCommit(new PersonalTariffTreeUpdateEvent(userId, cid, ptid));
        }
    }

    static {
        treeUpdateTime = new ConcurrentHashMap<Integer, Long>();
    }
}

