/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.apps.server.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsAbstractAction;
import ru.bitel.bgbilling.kernel.apps.server.bean.AppsContext;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstarctDaoConstant;

public class AppsManager
extends AbstarctDaoConstant
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger();
    protected final Connection con;
    protected final int userId;

    public AppsManager(Connection con, int userId) {
        this.con = con;
        this.userId = userId;
    }

    public void doModuleAction(String module, int moduleId, String action, int contractId, HttpServletRequest request, Map<String, Object> dataMap, Map<String, String> requestParamsMap) throws BGException {
        BGModule bgModule = ModuleCache.getInstance().getModule(moduleId);
        if (bgModule == null || !bgModule.getName().equals(module)) {
            throw new BGMessageException("\u041d\u0435 \u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043c\u043e\u0434\u0443\u043b\u044c: " + moduleId);
        }
        if (bgModule != null && action != null) {
            this.doExecute(bgModule.getInstalledModule().getPackageServer(), action, contractId, request, dataMap, requestParamsMap);
        }
    }

    public void doPluginAction(String pluginId, String action, int contractId, HttpServletRequest request, Map<String, Object> dataMap, Map<String, String> requestParamsMap) throws BGException {
        BGPluginServer bgPluginServer = BGPluginManagerServer.getManager().getPlugin(pluginId);
        if (bgPluginServer != null && action != null) {
            this.doExecute(bgPluginServer.getPackServer(), action, contractId, request, dataMap, requestParamsMap);
        }
    }

    private void doExecute(String serverPackage, String action, int contractId, HttpServletRequest request, Map<String, Object> dataMap, Map<String, String> requestParamsMap) {
        block9: {
            String actionClassName = serverPackage + ".action.apps.Action" + action.substring(0, 1).toUpperCase() + action.substring(1);
            try {
                Class<?> actionClass = Class.forName(actionClassName);
                if (!AppsAbstractAction.class.isAssignableFrom(actionClass)) break block9;
                AppsContext appsContext = new AppsContext(contractId, request, dataMap, this.con, requestParamsMap);
                AppsAbstractAction appsAbstractAction = (AppsAbstractAction)actionClass.newInstance();
                appsAbstractAction.setContext(appsContext);
                try {
                    String operation = request.getParameter("operation");
                    if (Utils.isBlankString((String)operation)) {
                        operation = "execute";
                    }
                    Method method = appsAbstractAction.getClass().getMethod(operation, new Class[0]);
                    method.invoke((Object)appsAbstractAction, new Object[0]);
                    appsAbstractAction.dataMap.put(action, appsAbstractAction.actionMap);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null && e.getCause() instanceof BGException) {
                        BGException ex = (BGException)e.getCause();
                        appsAbstractAction.request.setAttribute("error", (Object)ex.getMessage());
                        if (!(ex instanceof BGMessageException)) {
                            logger.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    appsAbstractAction.request.setAttribute("error", (Object)"\u0414\u0430\u043d\u043d\u0430\u044f \u0444\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430. \u0415\u0441\u043b\u0438 \u0443 \u0432\u0430\u0441 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f, \u0442\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043a \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0443, \u0438\u043d\u0430\u0447\u0435 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435.");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    appsAbstractAction.request.setAttribute("error", (Object)"\u0421\u0438\u0441\u0442\u0435\u043c\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435");
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws Exception {
    }
}

