/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.common.bean;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;

public class BGInstalledModule
extends IdTitle {
    public static final String TYPE_MODULE = "module";
    public static final String TYPE_PLUGIN = "plugin";
    public static final String TYPE_UPDATE = "update";
    private boolean enabled = true;
    private String type;
    private String name;
    private String version;
    private String packageClient;
    private String packageServer;
    private String build;
    private Map<String, Element> clientExtensionMap;
    private Map<String, Element> serverExtensionMap;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackageClient() {
        return this.packageClient;
    }

    public void setPackageClient(String packageClient) {
        this.packageClient = packageClient;
    }

    public String getPackageServer() {
        return this.packageServer;
    }

    public void setPackageServer(String packageServer) {
        this.packageServer = packageServer;
    }

    public String getBuild() {
        return this.build;
    }

    public void setBuild(String build) {
        this.build = build;
    }

    private void setDocument(Document document) {
        Element rootElement = document.getDocumentElement();
        this.name = rootElement.getAttribute("name");
        this.version = rootElement.getAttribute("version");
        for (Element extension : XMLUtils.selectElements((Node)document.getDocumentElement(), (String)"/module/extension")) {
            String point = extension.getAttribute("point");
            if (!Utils.notBlankString((String)point)) continue;
            this.serverExtensionMap.put(point, extension);
        }
    }

    public Map<String, Element> getServerExtensionMap() {
        if (this.serverExtensionMap != null) {
            return this.serverExtensionMap;
        }
        this.serverExtensionMap = new HashMap<String, Element>();
        this.doLoadServerModuleXml();
        return this.serverExtensionMap;
    }

    public Map<String, Element> getClientExtensionMap() {
        if (this.clientExtensionMap != null) {
            return this.clientExtensionMap;
        }
        this.clientExtensionMap = new HashMap<String, Element>();
        InputStream moduleXml = this.getInputStream(this.packageClient);
        if (moduleXml != null) {
            Document document = XMLUtils.parseDocument((InputSource)new InputSource(moduleXml));
            for (Element extension : XMLUtils.selectElements((Node)document.getDocumentElement(), (String)"/module/extension")) {
                String point = extension.getAttribute("point");
                if (point == null || point.trim().length() <= 0) continue;
                this.clientExtensionMap.put(point, extension);
            }
        }
        return this.clientExtensionMap;
    }

    private void doLoadServerModuleXml() {
        InputStream moduleXml = this.getInputStream(this.packageServer);
        if (moduleXml != null) {
            try {
                this.setDocument(XMLUtils.parseDocument((InputSource)new InputSource(moduleXml)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private InputStream getInputStream(String packageName) {
        InputStream moduleXml = null;
        try {
            moduleXml = BGInstalledModule.class.getResourceAsStream("/" + packageName.replace('.', '/') + "/module.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return moduleXml;
    }
}

