/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.search.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;
import ru.bitel.bgbilling.kernel.contract.search.common.service.ContractSearchService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;

public class ContractSearchRules
extends BGUPanel {
    private ContractSearchService searchService;
    private SearchImplementationTableModel tableModel;
    private JPanel searchesPanel;
    private BGUList<SearchImplementation> searchesList;
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();

    protected void jbInit() throws Exception {
        this.initListSearches();
        this.tableModel = new SearchImplementationTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.add(this.searchesPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.performAction("refresh");
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                try {
                    ContractSearchRules.this.searchesPanel.setVisible(true);
                    ContractSearchRules.this.searchesList.setData(ContractSearchRules.this.getService().getSearches());
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SearchImplementation searchImplementation = (SearchImplementation)((Object)ContractSearchRules.this.tableModel.getSelectedRow());
                if (searchImplementation != null && ClientUtils.confirmDelete((Object)((Object)searchImplementation))) {
                    ContractSearchRules.this.deleteSearch();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                try {
                    ContractSearchRules.this.tableModel.setData(ContractSearchRules.this.getService().getSelectedSearches());
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        };
    }

    private void initListSearches() {
        this.searchesPanel = new JPanel(new GridBagLayout());
        this.searchesPanel.setVisible(false);
        this.searchesList = new BGUList();
        BGSwingUtilites.wrapBorder((JPanel)this.searchesPanel, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u044b \u043f\u043e\u0438\u0441\u043a\u043e\u0432 \u0438\u0437 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445");
        this.okCancel.getButtonOk().addActionListener(e -> this.saveSelectedSearches());
        this.okCancel.getButton(BGButtonPanel.CANCEL).addActionListener(e -> this.searchesPanel.setVisible(false));
        JButton selectAll = new JButton("\u0412\u044b\u0431\u0440\u0430\u0442\u044c \u0432\u0441\u0451");
        selectAll.addActionListener(e -> this.searchesList.setSelectionInterval(0, this.searchesList.getModel().getSize()));
        this.searchesPanel.add((Component)new JScrollPane((Component)this.searchesList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.searchesPanel.add((Component)selectAll, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.searchesPanel.add((Component)this.okCancel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void deleteSearch() {
        List searchImplementations = this.tableModel.getSelectedRows();
        if (Utils.notEmptyCollection((Collection)searchImplementations)) {
            searchImplementations.forEach(search -> {
                try {
                    this.getService().deleteSearch((SearchImplementation)((Object)search));
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            });
            this.performAction("refresh");
        }
    }

    private void saveSelectedSearches() {
        try {
            List selectedSearches = this.searchesList.getSelectedValuesList();
            if (Utils.isEmptyCollection((Collection)selectedSearches)) {
                ClientUtils.showMessageDialog((Object)"\u0412\u044b \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043b\u0438 \u043d\u0438 \u043e\u0434\u043d\u0443 \u0437\u0430\u043f\u0438\u0441\u044c");
                return;
            }
            this.tableModel.getRows().forEach(row -> selectedSearches.removeIf(selected -> selected.getPathToImplClass().equals(row.getPathToImplClass()) && selected.getModuleId() == row.getModuleId()));
            this.getService().updateSearchList(selectedSearches);
            this.tableModel.setData(this.getService().getSelectedSearches());
            this.searchesPanel.setVisible(false);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private ContractSearchService getService() {
        if (this.searchService == null) {
            this.searchService = (ContractSearchService)((ClientContext)this.getContext()).getPort(ContractSearchService.class);
        }
        return this.searchService;
    }

    static class SearchImplementationTableModel
    extends BGTableModel<SearchImplementation> {
        public SearchImplementationTableModel() {
            super(SearchImplementation.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043b\u0430\u0441\u0441 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", -1, -1, -1, "pathToImplClass", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u043e\u0434\u0443\u043b\u044c", 100, 200, 300, "moduleTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

