/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamItem;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.CheckMaker;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.Check;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PaymentQueueManager;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class CashCheckUtils {
    private static final Logger log = LogManager.getLogger();

    public static Printer getPrinter(int kkmNum) throws BGException {
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
        PrinterManager printerManager = new PrinterManager(plugin);
        return printerManager.getPrinter(kkmNum);
    }

    @Deprecated
    public static Printer getPrinter(String address, int port) {
        Printer p = new Printer();
        p.setAddress(address);
        p.setPort(port);
        p.setId(-1);
        p.setTitle(address + ":" + port);
        p.setHidden(true);
        return p;
    }

    public static void printCheck(Check check, Printer printer, int kkmPass, Connection con, int paymentId) throws BGException {
        CashCheckUtils.printCheck(check, printer, kkmPass, con, paymentId, "script?", -1, null);
    }

    @Deprecated
    public static void printCheck(Check check, Printer printer, int kkmPass, Connection con, int paymentId, String posMapping, int contractId) throws BGException {
        CashCheckUtils.printCheck(check, printer, kkmPass, con, paymentId, posMapping, contractId, null);
    }

    public static void printCheck(Check check, Printer printer, int kkmPass, Connection con, int paymentId, String posMapping, int contractId, Integer logId) throws BGException {
        String submit = null;
        String pendingId = null;
        try {
            BigDecimal clientsumma = check.getPaymentsum();
            submit = printer.fiscalize().check(String.valueOf(kkmPass), clientsumma, check);
        }
        catch (BGException e) {
            new PaymentQueueManager(con).updatePaymentLog(paymentId, printer.getId(), check.getCheckData(), check.getCheckType(), posMapping, e.getMessage(), null, contractId, logId);
            throw e;
        }
        if (printer.fiscalize().isAsynchronous()) {
            pendingId = submit;
        }
        new PaymentQueueManager(con).updatePaymentLog(paymentId, printer.getId(), check.getCheckData(), check.getCheckType(), posMapping, null, pendingId, contractId, logId);
    }

    public static void printCheckVirtual(Check check, Printer printer, Connection con, int paymentId, String posMapping, int contractId) throws BGException {
        new PaymentQueueManager(con).updatePaymentLog(paymentId, printer.getId(), check.getCheckData(), check.getCheckType(), posMapping, "new", null, contractId, null);
    }

    public static void printCheckCharge(Check check, Printer printer, int kkmPass, Connection con, int chargeId) throws BGException {
        CashCheckUtils.printCheckCharge(check, printer, kkmPass, con, chargeId, "script?", -1);
    }

    public static void printCheckCharge(Check check, Printer printer, int kkmPass, Connection con, int chargeId, String posMapping, int contractId) throws BGException {
        String submit = null;
        String pendingId = null;
        try {
            BigDecimal clientsumma = check.getPaymentsum();
            submit = printer.fiscalize().checkreturn(String.valueOf(kkmPass), clientsumma, check);
        }
        catch (BGException e) {
            new PaymentQueueManager(con).updateChargeLog(chargeId, printer.getId(), check.getCheckData(), check.getCheckType(), posMapping, e.getMessage(), null, contractId);
            throw e;
        }
        if (printer.fiscalize().isAsynchronous()) {
            pendingId = submit;
        }
        new PaymentQueueManager(con).updateChargeLog(chargeId, printer.getId(), check.getCheckData(), check.getCheckType(), posMapping, null, pendingId, contractId);
    }

    public static void ZReport(Printer printer, int kkmPass) throws BGException {
        printer.fiscalize().zreport(String.valueOf(kkmPass));
    }

    public static void openDay(Printer printer, int kkmPass) throws BGException {
        printer.fiscalize().openday(String.valueOf(kkmPass));
    }

    public static void sendMailsAutoprint(String keysuffix, String subject, String body) {
        AlarmSender.sendAlarm((AlarmErrorMessage)new AlarmErrorMessage("cashcheck.autoprint." + keysuffix, subject, body), (long)System.currentTimeMillis());
    }

    public static void runCheckMakeraddPaymentAuto(Setup setup, Connection con, Connection conSlave, Payment payment, Check check, Printer printer) throws BGException {
        CashCheckUtils.runCheckMakerAddPayment(PrinterManager.PaymentPrintMode.auto, setup, con, conSlave, payment, check, printer);
    }

    public static void runCheckMakeraddPaymentAutoDelay(Setup setup, Connection con, Connection conSlave, Payment payment, Check check, Printer printer) throws BGException {
        CashCheckUtils.runCheckMakerAddPayment(PrinterManager.PaymentPrintMode.delay, setup, con, conSlave, payment, check, printer);
    }

    public static CheckMaker getCheckMaker(Setup setup, Connection con, Connection conSlave, Payment payment, Printer printer) throws BGException {
        String checkBuilderClass;
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
        PrinterManager printerManager = new PrinterManager(plugin);
        PrinterManager.PaymentMapping paymentchargeMapping = payment != null ? (payment.isPayment() ? printerManager.getPt(payment.getPaymentTypeId()) : printerManager.getCh(payment.getPaymentTypeId())) : null;
        String string = checkBuilderClass = paymentchargeMapping != null ? paymentchargeMapping.checkbuilder : null;
        if (checkBuilderClass == null) {
            String string2 = checkBuilderClass = printer != null ? printer.getCheckbuilder() : null;
            if (checkBuilderClass == null) {
                checkBuilderClass = plugin.getSetup().get("checkbuilder");
            }
        }
        CheckMaker dynCheckBuilder = null;
        if (checkBuilderClass != null) {
            try {
                dynCheckBuilder = (CheckMaker)DynamicClassManager.getInstance().newInstance(CheckMaker.class, checkBuilderClass);
                dynCheckBuilder.init(setup, con, conSlave);
            }
            catch (ClassCastException e) {
                throw new BGException("requires CheckMaker-implemented checkbuilder dyn.code (checkbuilder=" + checkBuilderClass + ")");
            }
        } else {
            throw new BGException("requires CheckMaker-implemented checkbuilder dyn.code (parameter \"checkbuilder\")");
        }
        return dynCheckBuilder;
    }

    public static void runCheckMakerAddPayment(PrinterManager.PaymentPrintMode printMode, Setup setup, Connection con, Connection conSlave, final Payment payment, Check check, Printer printer) throws BGException {
        CheckMaker dynCheckBuilder = CashCheckUtils.getCheckMaker(setup, con, conSlave, payment, printer);
        switch (printMode) {
            case auto: {
                dynCheckBuilder.addPaymentAuto(payment, check, printer);
                break;
            }
            case delay: {
                dynCheckBuilder.addPaymentAutoDelay(payment, check, printer);
                break;
            }
            case manual: {
                dynCheckBuilder.addPayment(payment, check, printer);
                dynCheckBuilder.endCreate((Set<Integer>)new HashSet<Integer>(){
                    {
                        this.add(payment.getContractId());
                    }
                }, check, printer);
            }
        }
    }

    public static void runCheckMakerAddPaymentRefund(Setup setup, Connection con, Connection conSlave, Payment payment, Check check, Printer printer) throws BGException {
        CheckMaker dynCheckBuilder = CashCheckUtils.getCheckMaker(setup, con, conSlave, payment, printer);
        dynCheckBuilder.addPaymentRefund(payment, check, printer);
        dynCheckBuilder.endCreateRefund(payment.getContractId(), check, printer);
    }

    public static List<Payment> getQueue(Connection con, Date fromDate, Date toDate, Integer registratorId) throws BGException {
        PaymentQueueManager paymentQueueManager = new PaymentQueueManager(con);
        List<Integer> paytypes = CashCheckUtils.getAllPaytypes(registratorId);
        Period period = new Period(fromDate, toDate);
        Page page = new Page(0, 1000000000);
        Result<Payment> paymentResult = paymentQueueManager.getPaymentQueue(period, paytypes, page);
        return paymentResult.getList();
    }

    public static List<Integer> getAllPaytypes(Integer registratorId) {
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
        PrinterManager printerManager = new PrinterManager(plugin);
        ArrayList<Integer> paytypes = new ArrayList<Integer>();
        Map<Integer, List<Integer>> registratorPtMap = printerManager.getRegistratorPtMap();
        for (Map.Entry<Integer, List<Integer>> registratorPt : registratorPtMap.entrySet()) {
            Integer regId = registratorPt.getKey();
            List<Integer> ptList = registratorPt.getValue();
            if (registratorId != null && !registratorId.equals(regId)) continue;
            paytypes.addAll(ptList);
        }
        return paytypes;
    }

    public static String getEmailParam(Connection con, int cid, int pid) throws BGException {
        try (ContractParameterManager bgParamMan = new ContractParameterManager(con);){
            ContractEmailParamValue contractEmailParamValue = bgParamMan.getEmailParam(cid, pid);
            if (contractEmailParamValue != null) {
                String[] emailsArray;
                if (contractEmailParamValue.getEmail() != null && (emailsArray = contractEmailParamValue.getEmail().split("\n")).length > 0) {
                    String email = emailsArray[0].trim();
                    int index = email.indexOf("<");
                    if (index != -1) {
                        email = email.substring(index + 1, email.length());
                    }
                    if ((index = email.indexOf(">")) != -1) {
                        email = email.substring(0, index);
                    }
                    String string = email;
                    return string;
                }
                emailsArray = null;
                return emailsArray;
            }
            PhoneParamValue phoneParamValue = bgParamMan.getPhoneParam(cid, pid);
            if (phoneParamValue != null) {
                if (phoneParamValue.size() > 0) {
                    PhoneParamItem phoneParamItem = phoneParamValue.getPhoneItem(0);
                    String string = phoneParamItem.getPhone();
                    return string;
                }
                String string = null;
                return string;
            }
            String string = bgParamMan.getStringParam(cid, pid);
            return string;
        }
    }

    public static String getEmailCustomer(Connection con, int cid) throws BGException {
        CustomerDao customerDao = new CustomerDao(con);
        Optional customerLink = customerDao.getCustomerLink(cid, LocalDateTime.now());
        if (customerLink.isPresent()) {
            JSONObject customerData = customerDao.getCustomerDataJson(((CustomerLink)customerLink.get()).getCustomerId());
            for (int i = 1; i < 10; ++i) {
                try {
                    String email = customerData.getJSONObject("customer").getJSONObject("contact").getString("email_" + i);
                    if (Utils.notBlankString((String)email)) {
                        return email;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static HttpReply doHttpRequest(String method, String url, String body, Map<String, String> requestProperties, int timeout, Logger logger) throws BGException {
        HttpURLConnection con = null;
        try {
            InputStream is;
            long t0 = System.currentTimeMillis();
            URL url2 = new URL(url);
            con = (HttpsURLConnection)url2.openConnection();
            if (timeout > 0) {
                con.setConnectTimeout(timeout);
                con.setReadTimeout(timeout);
            }
            con.setRequestMethod(method);
            con.setDoOutput(body != null);
            con.setDoInput(true);
            if (requestProperties != null) {
                for (Map.Entry<String, String> rp : requestProperties.entrySet()) {
                    con.addRequestProperty(rp.getKey(), rp.getValue());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("--" + method + " " + url);
                logger.debug("->" + (body != null ? body : "[no body]"));
            }
            long t1 = System.currentTimeMillis();
            if (body != null) {
                OutputStream os = con.getOutputStream();
                os.write(body.getBytes(StandardCharsets.UTF_8));
                os.close();
            }
            long t2 = System.currentTimeMillis();
            StringBuilder _result = new StringBuilder();
            long t3 = System.currentTimeMillis();
            int code = con.getResponseCode();
            InputStream inputStream = is = code == 200 ? con.getInputStream() : con.getErrorStream();
            if (is != null) {
                int ch;
                InputStreamReader rd = new InputStreamReader(is, "UTF-8");
                while ((ch = rd.read()) != -1) {
                    _result.append((char)ch);
                }
                rd.close();
            }
            String result = _result.toString();
            long t4 = System.currentTimeMillis();
            long t_connect = t1 - t0;
            long t_write = t2 - t1;
            long t_wait = t3 - t2;
            long t_read = t4 - t3;
            if (logger.isDebugEnabled()) {
                logger.debug("<-" + (!result.isEmpty() ? result : "[no body]") + "\nconnect: " + t_connect + "ms, write: " + t_write + "ms, wait: " + t_wait + "ms, read: " + t_read + "ms");
            }
            HttpReply httpReply = new HttpReply(code, result);
            return httpReply;
        }
        catch (IOException e) {
            throw new BGException("error connect or data transfer (" + url + "):\n" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static String getCashierName(Connection con, int userId) throws BGException {
        try (UserManager um = new UserManager(con);){
            User user = (User)um.get(userId);
            if (user != null) {
                String userCashcheckName;
                Preferences prefs = user.getConfigSetup();
                if (prefs != null && Utils.notBlankString((String)(userCashcheckName = prefs.get("cashcheck.name")))) {
                    String string = userCashcheckName;
                    return string;
                }
                String string = user.getName();
                return string;
            }
        }
        return null;
    }

    public static String getCashierInn(Connection con, int userId) throws BGException {
        try (UserManager um = new UserManager(con);){
            User user = (User)um.get(userId);
            String string = user != null ? user.getConfigSetup().get("cashcheck.inn") : null;
            return string;
        }
    }

    public static void sleepBatch() throws InterruptedException {
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
        long delayPaymentTimeoutMs = plugin.getSetup().getLong("delay.payment.timeout.ms", 10L);
        Thread.sleep(delayPaymentTimeoutMs);
    }

    public static List<Contract> getContractsWithBalance(Connection con, LocalDate month) throws BGException {
        try (ContractDaoInt contractDao = new ContractDaoInt(con, 1);){
            List<Contract> list = contractDao.getContractsWithBalance(month);
            return list;
        }
    }

    private static byte[] encodeNumber(long number, int bytes) {
        if (number < 0L) {
            long summan = 1L;
            for (int i = 0; i < bytes; ++i) {
                summan *= 256L;
            }
            number += summan;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16);
        for (int n = 0; n < bytes; ++n) {
            if (number > 0L) {
                byte number1 = (byte)(number % 256L);
                outputStream.write(number1);
                number /= 256L;
                continue;
            }
            outputStream.write(0);
        }
        return outputStream.toByteArray();
    }

    public static byte[] TLV(int tag, String value, String charsetName) {
        try {
            return CashCheckUtils.TLV(tag, value.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] TLV(int tag, long value, int len) {
        return CashCheckUtils.TLV(tag, CashCheckUtils.encodeNumber(value, len));
    }

    public static byte[] TLV(int tag, byte[] value) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16384);
            outputStream.write(new byte[]{(byte)(tag % 256), (byte)(tag / 256 % 256)});
            outputStream.write(new byte[]{(byte)(value.length % 256), (byte)(value.length / 256 % 256)});
            outputStream.write(value);
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] STLV(byte[] ... tlvs) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(16384);
            for (byte[] tlv : tlvs) {
                outputStream.write(tlv);
            }
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] convertSTAGtoSTLV(Check.STAG stag) {
        ArrayList<byte[]> subtags = new ArrayList<byte[]>();
        for (Map.Entry tlv_tag : stag.entrySet()) {
            Integer tlv_ntag = (Integer)tlv_tag.getKey();
            Object tlv_vtag = tlv_tag.getValue();
            if (tlv_vtag instanceof Long) {
                long tlv_value = (Long)tlv_vtag;
                subtags.add(CashCheckUtils.TLV((int)tlv_ntag, tlv_value, 4));
                continue;
            }
            if (tlv_vtag instanceof String) {
                String tlv_value = (String)tlv_vtag;
                subtags.add(CashCheckUtils.TLV((int)tlv_ntag, tlv_value, "cp866"));
                continue;
            }
            if (tlv_vtag instanceof byte[]) {
                byte[] tlv_value = (byte[])tlv_vtag;
                subtags.add(CashCheckUtils.TLV(tlv_ntag, tlv_value));
                continue;
            }
            throw new RuntimeException("error tag type " + tlv_vtag.getClass());
        }
        return CashCheckUtils.STLV((byte[][])subtags.toArray((T[])new byte[0][]));
    }

    public static BigDecimal getTax(BigDecimal sum, int TAXPERCENT) {
        BigDecimal tax1 = sum.divide(new BigDecimal((double)(100 + TAXPERCENT) / 100.0), 10, RoundingMode.HALF_UP);
        tax1 = tax1.multiply(new BigDecimal((double)TAXPERCENT / 100.0));
        tax1 = tax1.setScale(2, RoundingMode.HALF_UP);
        return tax1;
    }

    public static BigDecimal vatCalc(BigDecimal sum, int vatType) throws BGMessageException {
        switch (vatType) {
            default: {
                throw new BGMessageException(vatType + " \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 vat");
            }
            case 1000999: {
                return BigDecimal.ZERO;
            }
            case 1000000: {
                return BigDecimal.ZERO;
            }
            case 1000010: {
                return CashCheckUtils.getTax(sum, 10);
            }
            case 1000018: {
                return CashCheckUtils.getTax(sum, 18);
            }
            case 1000110: {
                return CashCheckUtils.getTax(sum, 10);
            }
            case 1000118: {
                return CashCheckUtils.getTax(sum, 18);
            }
            case 1000020: {
                return CashCheckUtils.getTax(sum, 20);
            }
            case 1000120: {
                return CashCheckUtils.getTax(sum, 20);
            }
            case 1000005: {
                return CashCheckUtils.getTax(sum, 5);
            }
            case 1000105: {
                return CashCheckUtils.getTax(sum, 5);
            }
            case 1000007: {
                return CashCheckUtils.getTax(sum, 7);
            }
            case 1000107: {
                return CashCheckUtils.getTax(sum, 7);
            }
            case 1000022: {
                return CashCheckUtils.getTax(sum, 22);
            }
            case 1000122: 
        }
        return CashCheckUtils.getTax(sum, 122);
    }

    public static class HttpReply {
        public int code;
        public String body;

        public HttpReply(int code, String body) {
            this.code = code;
            this.body = body;
        }

        public String toString() {
            return String.format("HttpReply{code:%d,len:%d}", this.code, this.body.length());
        }
    }

    private static final class ContractDaoInt
    extends ContractDao {
        public ContractDaoInt(Connection con, int userId) {
            super(con, userId);
        }

        public List<Contract> getContractsWithBalance(LocalDate month) throws BGException {
            String what = null;
            String join = "LEFT JOIN contract_balance AS _cb ON _cb.cid=contract.id";
            String filter = "_cb.cid IS NOT NULL AND _cb.mm=" + month.getMonthValue() + " AND _cb.yy=" + month.getYear();
            List contracts = this.list(false, null, what, join, null, filter, null, null, new Object[0]);
            return contracts;
        }
    }
}

