/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.bean;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.DateTimeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

public class PaymentQueueManager {
    private final Connection con;
    private final BGPluginServer plugin;
    private final PrinterManager printerManager;

    public PaymentQueueManager(Connection con) {
        this.con = con;
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
        this.printerManager = new PrinterManager(this.plugin);
    }

    public Result<Payment> getPaymentQueue(Period period, List<Integer> paytypes, Page page) throws BGException {
        LocalDate fiscalStart = this.plugin.getSetup().getLocalDate("fiscal.start", null);
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT SQL_CALC_FOUND_ROWS log.id, log.payment_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ");
            query.append("FROM contract_payment ");
            query.append("LEFT JOIN contract ON contract_payment.cid=contract.id ");
            query.append("LEFT JOIN contract_payment_types ON contract_payment.pt=contract_payment_types.id ");
            query.append("LEFT JOIN cashcheck_payment_log AS log ON contract_payment.id=log.payment_id ");
            query.append("WHERE ( log.dt IS NULL ) ");
            if (period.getDateFrom() != null) {
                query.append(" AND contract_payment.dt>='");
                query.append(TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (period.getDateTo() != null) {
                query.append(" AND contract_payment.dt<='");
                query.append(TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (fiscalStart != null) {
                query.append(" AND contract_payment.dt>='");
                query.append(DateTimeUtils.format((LocalDate)fiscalStart, (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (paytypes != null && !paytypes.isEmpty()) {
                query.append(" AND contract_payment.pt in (").append(Utils.toString(paytypes)).append(")");
            } else {
                query.append(" AND contract_payment.pt in (-1)");
            }
            query.append(" ORDER BY contract_payment.id DESC LIMIT ");
            query.append(page.getPageFirstRecordNumber());
            query.append(", ");
            query.append(page.getPageSize());
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, true);
                result.add(payment);
                PrinterManager.PaymentMapping paymentMapping = this.printerManager.getPt(payment.getPaymentTypeId());
                payment.setPosMapping((String)(paymentMapping != null ? paymentMapping.print.name() + ":" + Utils.toString(paymentMapping.fr) : "?"));
            }
            rs.close();
            st.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    private static void loadPaymentFromRS(Payment payment, ResultSet rs, boolean isPayment) throws SQLException {
        payment.setLogId(rs.getInt("log.id"));
        int cpid = rs.getInt("contract_payment.id");
        int lpid = rs.getInt("log_payment_id");
        payment.setPaymentId(cpid > 0 ? cpid : lpid);
        payment.setPaymentTypeId(rs.getInt("pt"));
        payment.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dt")));
        payment.setContractId(rs.getInt("contract.id"));
        payment.setSumma(rs.getBigDecimal("summa"));
        payment.setUserId(rs.getInt("uid"));
        payment.setComment(rs.getString("comment"));
        payment.setContractTitle(rs.getString("contract_title"));
        payment.setPaymentTypesTitle(rs.getString("contract_payment_types_title"));
        payment.setQueueDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("log_dt")));
        payment.setContractComment(rs.getString("contract_comment"));
        payment.setPosId(rs.getInt("log_pos_id"));
        payment.setCheckData(rs.getString("log_check_data"));
        payment.setLastError(rs.getString("log_last_error"));
        try {
            payment.setCheckType(Check.Type.valueOf((String)rs.getString("log_check_type")));
        }
        catch (Exception e) {
            payment.setCheckType(null);
        }
        payment.setPosMapping(rs.getString("log_pos_mapping"));
        payment.setPendingId(rs.getString("log_pending_id"));
        payment.setFiscalData(rs.getString("log_fiscal_data"));
        payment.setIsPayment(isPayment);
    }

    public List<Payment> getPaymentNotLogList(List<Integer> paymentIds) throws BGException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT log.id, log.payment_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ");
            query.append("FROM contract_payment ");
            query.append("LEFT JOIN contract ON contract_payment.cid=contract.id ");
            query.append("LEFT JOIN contract_payment_types ON contract_payment.pt=contract_payment_types.id ");
            query.append("LEFT JOIN cashcheck_payment_log AS log ON contract_payment.id=log.payment_id ");
            query.append("WHERE contract_payment.id in (-1," + Utils.toString(paymentIds) + ")");
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, true);
                result.add(payment);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updatePaymentLog(int paymentId, int posId, String checkData, Check.Type checkType, String posMapping, String errorText, String pendingId, int contractId, Integer logId) throws BGException {
        try {
            String query = null;
            query = logId == null ? "INSERT INTO `cashcheck_payment_log` (`payment_id`,`pos_id`, `check_data`, `check_type`, `pos_mapping`, `last_error`, `pending_id`, `contract_id`) VALUES (?,?,?,?,?,?,?,?)" : "UPDATE `cashcheck_payment_log` SET `payment_id`=?,`pos_id`=?, `check_data`=?, `check_type`=?, `pos_mapping`=?, `last_error`=?, `pending_id`=?, `contract_id`=?, `dt`=NOW() WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, paymentId);
            ps.setInt(2, posId);
            ps.setString(3, checkData);
            if (checkType != null) {
                ps.setString(4, checkType.name());
            } else {
                ps.setNull(4, 12);
            }
            ps.setString(5, posMapping);
            if (errorText != null) {
                ps.setString(6, errorText);
            } else {
                ps.setNull(6, 12);
            }
            if (pendingId != null) {
                ps.setString(7, pendingId);
            } else {
                ps.setNull(7, 12);
            }
            if (contractId > 0) {
                ps.setInt(8, contractId);
            } else {
                ps.setNull(8, 4);
            }
            if (logId != null) {
                ps.setInt(9, logId);
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Deprecated
    public void updatePaymentLog(int paymentId, int posId) throws BGException {
        this.updatePaymentLog(paymentId, posId, null, null, "?", null, null, -1, null);
    }

    public Result<Payment> getPaymentLog(int printerId, Period period, Page page) throws BGException {
        return this.getPaymentLog(null, printerId, null, null, period, page, null);
    }

    public Result<Payment> getPaymentLog(Set<Integer> cids, int printerId, Boolean erroredType, String posMapping, Period period, Page page, Collection<Integer> logIds) throws BGException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT SQL_CALC_FOUND_ROWS log.id, log.payment_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ");
            query.append("FROM cashcheck_payment_log AS log ");
            query.append("LEFT JOIN contract_payment ON log.payment_id=contract_payment.id ");
            query.append("LEFT JOIN contract ON IFNULL(contract_payment.cid, log.contract_id) = contract.id ");
            query.append("LEFT JOIN contract_payment_types ON contract_payment.pt=contract_payment_types.id ");
            query.append("WHERE ( " + printerId + "=0 OR log.pos_id=" + printerId + " ) ");
            if (erroredType == Boolean.TRUE) {
                query.append(" AND log.last_error IS NOT NULL");
            } else if (erroredType == Boolean.FALSE) {
                query.append(" AND log.last_error IS NULL");
            }
            if (posMapping != null) {
                if (!"".equals(posMapping)) {
                    query.append(" AND log.pos_mapping = '" + posMapping + "'");
                } else {
                    query.append(" AND (log.pos_mapping = '' OR log.pos_mapping IS NULL)");
                }
            }
            if (period != null && period.getDateFrom() != null) {
                query.append(" AND log.dt>='");
                query.append(TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (period != null && period.getDateTo() != null) {
                query.append(" AND log.dt<=DATE_ADD('");
                query.append(TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd"));
                query.append("', INTERVAL 1 DAY )");
            }
            if (cids != null && !cids.isEmpty()) {
                String c = Utils.toString(cids);
                query.append(" AND (cid IN (" + c + ") OR contract.id IN (" + c + "))");
            }
            if (logIds != null) {
                query.append(" AND log.id IN (" + (Serializable)(!logIds.isEmpty() ? Utils.toString(logIds) : Integer.valueOf(-1)) + ")");
            }
            query.append(" ORDER BY log.dt DESC ");
            if (page != null) {
                query.append(" LIMIT ");
                query.append(page.getPageFirstRecordNumber());
                query.append(", ");
                query.append(page.getPageSize());
            }
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, true);
                result.add(payment);
            }
            rs.close();
            st.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    public Result<Payment> getChargeQueue(Period period, List<Integer> chatypes, Page page) throws BGException {
        LocalDate fiscalStart = this.plugin.getSetup().getLocalDate("fiscal.start", null);
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            Object query = "";
            query = (String)query + "SELECT SQL_CALC_FOUND_ROWS log.id, log.charge_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ";
            query = (String)query + "FROM contract_charge as contract_payment ";
            query = (String)query + "LEFT JOIN contract ON contract_payment.cid=contract.id ";
            query = (String)query + "LEFT JOIN contract_charge_types AS contract_payment_types ON contract_payment.pt=contract_payment_types.id ";
            query = (String)query + "LEFT JOIN cashcheck_charge_log AS log ON contract_payment.id=log.charge_id ";
            query = (String)query + "WHERE ( log.dt IS NULL ) ";
            if (period.getDateFrom() != null) {
                query = (String)query + " AND contract_payment.dt>='" + TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd") + "'";
            }
            if (period.getDateTo() != null) {
                query = (String)query + " AND contract_payment.dt<='" + TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd") + "'";
            }
            if (fiscalStart != null) {
                query = (String)query + " AND contract_payment.dt>='" + DateTimeUtils.format((LocalDate)fiscalStart, (String)"yyyy-MM-dd") + "'";
            }
            query = chatypes != null && !chatypes.isEmpty() ? (String)query + " AND contract_payment.pt in (" + Utils.toString(chatypes) + ")" : (String)query + " AND contract_payment.pt in (-1)";
            query = (String)query + " ORDER BY contract_payment.id DESC LIMIT ";
            query = (String)query + page.getPageFirstRecordNumber();
            query = (String)query + ", ";
            query = (String)query + page.getPageSize();
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery((String)query);
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, false);
                result.add(payment);
                PrinterManager.PaymentMapping chargeMapping = this.printerManager.getCh(payment.getPaymentTypeId());
                payment.setPosMapping((String)(chargeMapping != null ? chargeMapping.print.name() + ":" + Utils.toString(chargeMapping.fr) : "?"));
            }
            rs.close();
            st.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    public List<Payment> getChargesList(List<Integer> chargeIds) throws BGException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            String query = "SELECT log.id, log.charge_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title FROM contract_charge as contract_payment LEFT JOIN contract ON contract_payment.cid=contract.id LEFT JOIN contract_charge_types AS contract_payment_types ON contract_payment.pt=contract_payment_types.id LEFT JOIN cashcheck_charge_log AS log ON contract_payment.id=log.charge_id WHERE contract_payment.id in (-1," + Utils.toString(chargeIds) + ")";
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, false);
                result.add(payment);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateChargeLog(int chargeId, int posId, String checkData, Check.Type checkType, String posMapping, String errorText, String pendingId, int contractId) throws BGException {
        try {
            String query = "REPLACE INTO `cashcheck_charge_log` (`charge_id`,`pos_id`, `check_data`, `check_type`, `pos_mapping`, `last_error`, `pending_id`, `contract_id`) VALUES (?,?,?,?,?,?,?,?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, chargeId);
            ps.setInt(2, posId);
            ps.setString(3, checkData);
            if (checkType != null) {
                ps.setString(4, checkType.name());
            } else {
                ps.setNull(4, 12);
            }
            ps.setString(5, posMapping);
            if (errorText != null) {
                ps.setString(6, errorText);
            } else {
                ps.setNull(6, 12);
            }
            if (pendingId != null) {
                ps.setString(7, pendingId);
            } else {
                ps.setNull(7, 12);
            }
            if (contractId > 0) {
                ps.setInt(8, contractId);
            } else {
                ps.setNull(8, 4);
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Deprecated
    public void updateChargeLog(int chargeId, int posId) throws BGException {
        this.updateChargeLog(chargeId, posId, null, null, "?", null, null, -1);
    }

    public Result<Payment> getChargeLog(Set<Integer> cids, int printerId, Boolean erroredType, String posMapping, Period period, Page page) throws BGException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT SQL_CALC_FOUND_ROWS log.id, log.charge_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ");
            query.append("FROM cashcheck_charge_log AS log ");
            query.append("LEFT JOIN contract_charge AS contract_payment ON log.charge_id=contract_payment.id ");
            query.append("LEFT JOIN contract ON IFNULL(contract_payment.cid, log.contract_id) = contract.id ");
            query.append("LEFT JOIN contract_charge_types AS contract_payment_types ON contract_payment.pt=contract_payment_types.id ");
            query.append("WHERE ( " + printerId + "=0 OR log.pos_id=" + printerId + " ) ");
            if (erroredType == Boolean.TRUE) {
                query.append(" AND log.last_error IS NOT NULL");
            } else if (erroredType == Boolean.FALSE) {
                query.append(" AND log.last_error IS NULL");
            }
            if (posMapping != null) {
                if (!"".equals(posMapping)) {
                    query.append(" AND log.pos_mapping = '" + posMapping + "'");
                } else {
                    query.append(" AND (log.pos_mapping = '' OR log.pos_mapping IS NULL)");
                }
            }
            if (period != null && period.getDateFrom() != null) {
                query.append(" AND log.dt>='");
                query.append(TimeUtils.format((Date)period.getDateFrom(), (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (period != null && period.getDateTo() != null) {
                query.append(" AND log.dt<=DATE_ADD('");
                query.append(TimeUtils.format((Date)period.getDateTo(), (String)"yyyy-MM-dd"));
                query.append("', INTERVAL 1 DAY )");
            }
            if (cids != null && !cids.isEmpty()) {
                String c = Utils.toString(cids);
                query.append(" AND (cid IN (" + c + ") OR contract.id IN (" + c + "))");
            }
            query.append(" ORDER BY log.dt DESC ");
            if (page != null) {
                query.append(" LIMIT ");
                query.append(page.getPageFirstRecordNumber());
                query.append(", ");
                query.append(page.getPageSize());
            }
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, false);
                result.add(payment);
            }
            rs.close();
            st.close();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return new Result(result, page);
    }

    public void updatePaymentLastErrorForPendingId(String pendingId, String lastError) throws BGException {
        try {
            String query = "UPDATE cashcheck_payment_log SET last_error=? WHERE pending_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, lastError);
            ps.setString(2, pendingId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updatePaymentFiscalDataForPendingId(String pendingId, String fiscalData) throws BGException {
        try {
            String query = "UPDATE cashcheck_payment_log SET fiscal_data=? WHERE pending_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, fiscalData);
            ps.setString(2, pendingId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<Payment> getNeedPendingIdLog(int printerId, Date fromDate, Date toDate, boolean isError) throws BGException {
        ArrayList<Payment> result = new ArrayList<Payment>();
        try {
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT log.id, log.payment_id as log_payment_id, log.dt as log_dt, log.pos_id as log_pos_id, log.check_data as log_check_data, log.last_error as log_last_error, log.check_type as log_check_type, log.pos_mapping as log_pos_mapping, log.pending_id as log_pending_id, log.fiscal_data as log_fiscal_data, contract_payment.*, contract.id, contract.title as contract_title, contract.comment as contract_comment, contract_payment_types.title as contract_payment_types_title ");
            query.append("FROM cashcheck_payment_log AS log ");
            query.append("LEFT JOIN contract_payment ON log.payment_id=contract_payment.id ");
            query.append("LEFT JOIN contract ON IFNULL(contract_payment.cid, log.contract_id) = contract.id ");
            query.append("LEFT JOIN contract_payment_types ON contract_payment.pt=contract_payment_types.id ");
            query.append("WHERE ( " + printerId + "<=0 OR log.pos_id=" + printerId + " ) AND log.pending_id IS NOT NULL AND log.fiscal_data IS NULL");
            if (isError) {
                query.append(" AND log.last_error IS NOT NULL");
            } else {
                query.append(" AND log.last_error IS NULL");
            }
            if (fromDate != null) {
                query.append(" AND log.dt>='");
                query.append(TimeUtils.format((Date)fromDate, (String)"yyyy-MM-dd"));
                query.append("'");
            }
            if (toDate != null) {
                query.append(" AND log.dt<=DATE_ADD('");
                query.append(TimeUtils.format((Date)toDate, (String)"yyyy-MM-dd"));
                query.append("', INTERVAL 1 DAY )");
            }
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                Payment payment = new Payment();
                PaymentQueueManager.loadPaymentFromRS(payment, rs, true);
                result.add(payment);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Set<String> getExistingPosMapping() throws BGException {
        HashSet<String> result = new HashSet<String>();
        try {
            this._allPosMapping(result, "cashcheck_payment_log");
            this._allPosMapping(result, "cashcheck_charge_log");
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    private void _allPosMapping(Set<String> result, String table) throws SQLException {
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery("SELECT DISTINCT pos_mapping FROM " + table);
        while (rs.next()) {
            result.add(rs.getString(1) != null ? rs.getString(1) : "");
        }
        rs.close();
        st.close();
    }
}

