/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.cashcheck.common.BGPrinterNotloggedMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.server.util.UserSession;
import ru.bitel.common.ParameterMap;

public class PrinterManager {
    private static final String SESSION_CurrentRegistratorId = "ru.bitel.bgbilling.plugins.cashcheck.CurrentRegistratorId";
    private static final String SESSION_CurrentRegistratorPassword = "ru.bitel.bgbilling.plugins.cashcheck.CurrentRegistratorPassword";
    private static final Logger log = LogManager.getLogger();
    private BGPluginServer plugin;
    private static volatile Map<Integer, Printer> printerMap = null;
    private static volatile Map<Integer, PaymentMapping> _ptMap = null;
    private static volatile Map<Integer, PaymentMapping> _chMap = null;
    private static volatile Map<Integer, List<Integer>> _retPt = null;
    private static volatile Map<Integer, List<Integer>> _retCh = null;

    public PrinterManager(BGPluginServer plugin) {
        this.plugin = plugin;
    }

    private Map<Integer, Printer> getPrinterMap() {
        if (printerMap == null) {
            SortedMap list = this.plugin.getSetup().subIndexed("fr.");
            printerMap = new HashMap<Integer, Printer>();
            for (Map.Entry frItem : list.entrySet()) {
                try {
                    Printer p = new Printer();
                    int id = (Integer)frItem.getKey();
                    ParameterMap frConfig = (ParameterMap)frItem.getValue();
                    p.setId(id);
                    p.setTitle(frConfig.get("title"));
                    p.setFiscalizatorType((Printer.FiscalizatorType)frConfig.getEnum(Printer.FiscalizatorType.class, "fiscalizator", (Enum)Printer.FiscalizatorType.cashcheckserver));
                    p.setHidden(frConfig.getBoolean("hidden", false));
                    p.setAutoclose(frConfig.getBoolean("autoclose", false));
                    if (p.isAutoclose()) {
                        p.setAutoclosePass(Integer.parseInt(frConfig.get("autoclose.pass")));
                    }
                    p.setCheckbuilder(frConfig.get("checkbuilder", null));
                    p.setPass(frConfig.getInt("pass", -1));
                    p.setConfig(frConfig);
                    printerMap.put(id, p);
                }
                catch (Exception e) {
                    log.error("cashcheck: \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430 fr." + frItem.getKey() + " \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b \u0438 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u044e\u0442\u0441\u044f", (Throwable)e);
                }
            }
        }
        return printerMap;
    }

    public Collection<Printer> getPrinters() {
        return this.getPrinterMap().values();
    }

    private void _getPtChMap(Map<Integer, PaymentMapping> ptchMap, String typePrefix) {
        SortedMap list = this.plugin.getSetup().subIndexed(typePrefix);
        for (Map.Entry ptItem : list.entrySet()) {
            try {
                int pt;
                PaymentMapping pm = new PaymentMapping();
                pm.pt = pt = ((Integer)ptItem.getKey()).intValue();
                for (Integer fr : ((ParameterMap)ptItem.getValue()).getIntegerList("fr", new ArrayList())) {
                    try {
                        this.getPrinter(fr);
                        pm.fr.add(fr);
                    }
                    catch (Exception e) {
                        log.error("cashcheck: \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043a\u043e\u043d\u043a\u0440\u0435\u0442\u043d\u043e\u0433\u043e \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430 \u0432 \u043c\u0430\u043f\u043f\u0438\u043d\u0433\u0435 " + typePrefix + ptItem.getKey() + ".fr=" + fr + " \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b \u0438 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u0442\u0441\u044f: " + e.getMessage());
                    }
                }
                if (pm.fr.isEmpty()) {
                    throw new Exception("empty fr list");
                }
                pm.print = (PaymentPrintMode)((ParameterMap)ptItem.getValue()).getEnum(PaymentPrintMode.class, "print", (Enum)PaymentPrintMode.manual);
                if (pm.print == PaymentPrintMode.auto || pm.print == PaymentPrintMode.delay) {
                    pm.pass = ((ParameterMap)ptItem.getValue()).getInt("pass", -1);
                }
                pm.checkbuilder = ((ParameterMap)ptItem.getValue()).get("checkbuilder", null);
                ptchMap.put(pt, pm);
            }
            catch (Exception e) {
                log.error("cashcheck: \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 " + typePrefix + ptItem.getKey() + " \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b \u0438 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u044e\u0442\u0441\u044f: " + e.getMessage());
            }
        }
    }

    public Map<Integer, PaymentMapping> getPtMap() {
        if (_ptMap == null) {
            _ptMap = new HashMap<Integer, PaymentMapping>();
            this._getPtChMap(_ptMap, "pt.");
        }
        return _ptMap;
    }

    public Map<Integer, PaymentMapping> getChMap() {
        if (_chMap == null) {
            _chMap = new HashMap<Integer, PaymentMapping>();
            this._getPtChMap(_chMap, "ch.");
        }
        return _chMap;
    }

    public PaymentMapping getPt(int paymentTypeId) {
        return this.getPtMap().get(paymentTypeId);
    }

    public PaymentMapping getCh(int chargeTypeId) {
        return this.getChMap().get(chargeTypeId);
    }

    private void _getRegistratorPtChMap(Map<Integer, List<Integer>> retPtCh, Map<Integer, PaymentMapping> ptchMap) {
        for (Map.Entry<Integer, PaymentMapping> ptMapEntry : ptchMap.entrySet()) {
            Integer paymentchargeTypeId = ptMapEntry.getKey();
            List<Integer> registratorList = ptMapEntry.getValue().fr;
            for (Integer registratorNum : registratorList) {
                if (!retPtCh.containsKey(registratorNum)) {
                    retPtCh.put(registratorNum, new ArrayList());
                }
                retPtCh.get(registratorNum).add(paymentchargeTypeId);
            }
        }
    }

    public Map<Integer, List<Integer>> getRegistratorPtMap() {
        if (_retPt == null) {
            _retPt = new HashMap<Integer, List<Integer>>();
            this._getRegistratorPtChMap(_retPt, this.getPtMap());
        }
        return _retPt;
    }

    public Map<Integer, List<Integer>> getRegistratorChMap() {
        if (_retCh == null) {
            _retCh = new HashMap<Integer, List<Integer>>();
            this._getRegistratorPtChMap(_retCh, this.getChMap());
        }
        return _retCh;
    }

    public static void setCurrentRegistrator(int registratorId, String password) {
        if (registratorId > 0) {
            UserSession.getInstance().setAttribute(SESSION_CurrentRegistratorId, (Object)registratorId);
            UserSession.getInstance().setAttribute(SESSION_CurrentRegistratorPassword, (Object)password);
        } else {
            UserSession.getInstance().removeAttribute(SESSION_CurrentRegistratorId);
            UserSession.getInstance().removeAttribute(SESSION_CurrentRegistratorPassword);
        }
    }

    public static int getCurrentRegistratorId() {
        Integer registratorId = (Integer)UserSession.getInstance().getAttribute(SESSION_CurrentRegistratorId);
        int id = registratorId != null ? registratorId : 0;
        return id;
    }

    public static String getCurrentRegistratorPassword() {
        return (String)UserSession.getInstance().getAttribute(SESSION_CurrentRegistratorPassword);
    }

    public Printer getPrinter() throws BGPrinterNotloggedMessageException, BGException {
        int registratorId = PrinterManager.getCurrentRegistratorId();
        if (registratorId == 0) {
            throw new BGPrinterNotloggedMessageException("\u041a\u041a\u041c \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
        }
        return this.getPrinter(registratorId);
    }

    public Printer getPrinter(int kkmNum) throws BGException {
        Map<Integer, Printer> printers = this.getPrinterMap();
        Printer printer = printers.get(kkmNum);
        if (printer == null) {
            throw new BGException("\u041a\u041a\u041c#" + kkmNum + " \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
        }
        return printer.clone();
    }

    public static void resetCache() {
        printerMap = null;
        _ptMap = null;
        _chMap = null;
        _retPt = null;
        _retCh = null;
    }

    public static class PaymentMapping {
        public int pt;
        public List<Integer> fr = new ArrayList<Integer>();
        public PaymentPrintMode print;
        public int pass;
        public String checkbuilder;
    }

    public static enum PaymentPrintMode {
        manual,
        auto,
        delay;

    }
}

