/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.auth.http;

import bitel.billing.server.admin.auth.Auth;
import bitel.billing.server.admin.auth.AuthException;
import bitel.billing.server.admin.auth.http.HttpAuthError;
import bitel.billing.server.admin.auth.http.HttpAuthException;
import bitel.billing.server.admin.auth.http.HttpLogin;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.io.Base64;

public abstract class HttpAuth<A extends HttpLogin, B, C, D>
extends Auth<A, HttpServletRequest, B, C, D> {
    private String loginPath = this.getClass().getName() + ".HttpLogin";

    public HttpAuth(Setup setup) {
    }

    @Override
    public A login(HttpServletRequest request, B b, C c, D d) throws AuthException {
        try {
            HttpSession session = request.getSession();
            HttpLogin a = (HttpLogin)session.getAttribute(this.loginPath);
            if (a == null) {
                X509Certificate[] certs;
                String[] baseAuth = this.getBasicAuth(request);
                a = this.getLogin(request, b, c, d, baseAuth);
                boolean needCertificateAuth = this.isNeedCertificateAuth(a, b, c, d);
                if ((needCertificateAuth || this.isNeedSecureConnection(a, b, c, d)) && !request.isSecure()) {
                    throw new HttpAuthException(HttpAuthError.NEED_SECURE_CONNECTION, "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e SSL/TLS \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435.");
                }
                if (this.isNeedBaseAuth(a, b, c, d)) {
                    if (baseAuth != null) {
                        if (!baseAuth[0].equals(a.login) || !Arrays.equals(baseAuth[1].toCharArray(), a.password)) {
                            throw new HttpAuthException(HttpAuthError.LOGIN_PASSWORD_ERROR, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c.");
                        }
                    } else {
                        throw new HttpAuthException(HttpAuthError.NEED_BASE_AUTH, "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 BASE \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f.");
                    }
                }
                if (this.isNeedCertificateAuth(a, b, c, d) && (certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate")) != null && certs.length > 0) {
                    X509Certificate cert = certs[0];
                    try {
                        cert.checkValidity(new Date());
                    }
                    catch (CertificateExpiredException e) {
                        throw new HttpAuthException(HttpAuthError.CERTIFICATE_EXPIRED, "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d.");
                    }
                    catch (CertificateNotYetValidException e) {
                        throw new HttpAuthException(HttpAuthError.CERTIFICATE_NOT_YET_VALID, "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u0435\u0449\u0435 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d.");
                    }
                    boolean certOk = true;
                    try {
                        certOk = a.getPublicKey().equals(cert.getPublicKey()) && this.checkCertificate(cert);
                    }
                    catch (AuthException auth) {
                        throw auth;
                    }
                    catch (Exception e) {
                        certOk = false;
                        log.error("HttpAuth. \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f(\u0441\u0440\u0430\u0432\u043d\u0435\u043d\u0438\u044f) \u043e\u0442\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430 \u0443 \u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430.");
                        e.printStackTrace();
                    }
                    if (!certOk) {
                        throw new HttpAuthException(HttpAuthError.CERTIFICATE_NOT_VALID, "\u041a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442 \u043e\u0442\u043a\u043b\u043e\u043d\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439.");
                    }
                }
            }
            return (A)a;
        }
        catch (AuthException auth) {
            throw auth;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HttpAuthException(HttpAuthError.SYSTEM_ERROR, "\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430.");
        }
    }

    protected abstract A getLogin(HttpServletRequest var1, B var2, C var3, D var4, String[] var5) throws AuthException;

    protected abstract boolean isNeedBaseAuth(A var1, B var2, C var3, D var4);

    protected abstract boolean isNeedSecureConnection(A var1, B var2, C var3, D var4);

    protected abstract boolean isNeedCertificateAuth(A var1, B var2, C var3, D var4);

    protected boolean checkCertificate(X509Certificate cert) throws AuthException {
        return true;
    }

    protected final String[] getBasicAuth(HttpServletRequest request) {
        String unencoded;
        int colon;
        String userName = null;
        String userPswd = null;
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.startsWith("Basic ") && (colon = (unencoded = Base64.decode((String)(authorization = authorization.substring(6).trim()), (String)"UTF-8")).indexOf(58)) > 0) {
            try {
                userName = unencoded.substring(0, colon);
                userPswd = unencoded.substring(colon + 1);
            }
            catch (Exception ex) {
                userName = null;
                userPswd = null;
                ex.printStackTrace();
            }
        }
        if (userName != null && userPswd != null) {
            return new String[]{userName, userPswd};
        }
        return null;
    }
}

