/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.admin.action.base.ActionBase;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogEntry;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

@ActionConType(value=2)
public class ActionQueryLogTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Page page = this.getPage();
        Period period = this.getPeriod();
        int userId = this.getIntParameter("userId", -2);
        String actionList = this.getParameter("actions");
        String cidList = this.getParameter("contracts");
        String parameter = this.getParameter("parameter", "");
        String pvalue = this.getParameter("pvalue", "");
        boolean isregexp = this.getBooleanParameter("isregexp", false);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        List<BGSQueryLogEntry> result = BGSQueryLogDao.getLogTable(this.context.getConnectionSet(), period, userId, cidList, actionList, parameter, pvalue, isregexp, page);
        for (BGSQueryLogEntry entry : result) {
            Element row = this.createElement(data, "row");
            row.setAttribute("dtime", TimeUtils.format((Date)entry.getDate(), (String)"dd.MM.yyyy HH:mm:ss"));
            row.setAttribute("user", entry.getUserName());
            row.setAttribute("ipaddr", entry.getRemoteAddr());
            row.setAttribute("contract", entry.getContractTitle());
            row.setAttribute("module", entry.getModuleName());
            row.setAttribute("action", entry.getActionTitle());
            row.setAttribute("query", entry.getQueryString());
        }
        this.setPageAttribute(table, page);
        ServerUtils.prepareElementToSerialize(this.rootNode);
    }
}

