/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.errorlog.action;

import bitel.billing.server.ActionBase;
import bitel.billing.server.admin.errorlog.bean.PeriodicErrorManager;
import bitel.billing.server.admin.errorlog.bean.PeriodicProcessErrorMessage;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ActionGetPeriodicErrors
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        Page page = this.getPage();
        Date month = this.getDateParameter("month");
        Period period = this.getPeriod();
        String contains = this.getParameter("contains");
        if (page == null || month == null) {
            throw new BGIllegalArgumentException();
        }
        if (period.getDateFrom() == null || period.getDateTo() == null) {
            period = null;
        }
        PeriodicErrorManager manager = new PeriodicErrorManager(this.con);
        SearchResult searchResult = new SearchResult(period, page);
        manager.getErrors((SearchResult<PeriodicProcessErrorMessage>)searchResult, month, contains);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (PeriodicProcessErrorMessage message : searchResult.getList()) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(message.getId()));
            row.setAttribute("regdate", TimeUtils.formatDate((Date)message.getRegistrationTime()));
            row.setAttribute("subject", message.getSubject());
            row.setAttribute("calcdate", TimeUtils.format((Date)message.getMonth(), (String)"MM.yyyy"));
            row.setAttribute("comment", message.getText());
        }
        this.setPageAttribute(table, page);
    }
}

