/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.ContractMemo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.server.util.ServerUtils;

@Deprecated
public class ContractMemoManager {
    private Connection con;
    private static final String TABLE_NAME = "contract_comment";

    public ContractMemoManager(Connection con) {
        this.con = con;
    }

    public void updateMemo(ContractMemo memo) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (memo.getId() <= 0) {
                query = "INSERT INTO contract_comment SET subject=?, comment=?, uid=?, visibled=?, dt=NOW(), cid=?";
                ps = this.con.prepareStatement(query, 1);
                ps.setInt(5, memo.getContractId());
            } else {
                query = "UPDATE contract_comment SET subject=?, comment=?, uid=?, dt=NOW(), visibled=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, memo.getId());
            }
            ps.setString(1, memo.getSubject());
            ps.setString(2, memo.getComment());
            ps.setInt(3, memo.getUserId());
            ps.setBoolean(4, memo.isVisibled());
            ps.executeUpdate();
            if (memo.getId() <= 0) {
                memo.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteMemo(int id) {
        try {
            String query = "DELETE FROM contract_comment WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ContractMemo getMemo(int id) {
        ContractMemo result = null;
        try {
            String query = "SELECT * FROM contract_comment WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getMemoFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<ContractMemo> getUserMemoList(int cid) {
        return this.getMemoList(cid, true);
    }

    public List<ContractMemo> getMemoList(int cid, boolean flag) {
        ArrayList<ContractMemo> result = new ArrayList<ContractMemo>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT * FROM ");
            query.append(TABLE_NAME);
            query.append(" WHERE cid=? ");
            if (flag) {
                query.append("AND visibled=true ");
            }
            query.append("ORDER BY dt DESC");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractMemo memo = this.getMemoFromRs(rs);
                result.add(memo);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private ContractMemo getMemoFromRs(ResultSet rs) throws SQLException {
        ContractMemo memo = new ContractMemo();
        memo.setId(rs.getInt("id"));
        memo.setContractId(rs.getInt("cid"));
        memo.setTime(rs.getTimestamp("dt"));
        memo.setUserId(rs.getInt("uid"));
        memo.setSubject(rs.getString("subject"));
        memo.setComment(rs.getString("comment"));
        memo.setVisibled(rs.getBoolean("visibled"));
        return memo;
    }
}

