/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import bitel.billing.server.contract.bean.ParameterHistoryEntry;
import bitel.billing.server.util.db.ColumnValue;
import bitel.billing.server.util.db.TableCopier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ListParamValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamItem;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.kernel.contract.param.server.bean.ContractParameterPrefDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@Deprecated
public class ContractParameterManager
implements AutoCloseable {
    private static volatile Map<Integer, Boolean> PARAMETERS_HISTORY = new HashMap<Integer, Boolean>();
    public static final String CONTRACT_PARAMETERS_PREF = "contract_parameters_pref";
    public static final String CONTRACT_PARAMETER_TYPE_STRING = ContractParameterPrefType.TYPE_TEXT.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_ADDRESS = ContractParameterPrefType.TYPE_ADDRESS.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_EMAIL = ContractParameterPrefType.TYPE_EMAIL.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_SERVICING_PERSON = ContractParameterPrefType.TYPE_SERVICING_PERSON.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_BOOLEAN = ContractParameterPrefType.TYPE_FLAG.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_DATE = ContractParameterPrefType.TYPE_DATE.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_LIST = ContractParameterPrefType.TYPE_LIST.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_LIST_VALUES = "contract_parameter_type_7_values";
    public static final String CONTRACT_PARAMETER_TYPE_CONTRACT = ContractParameterPrefType.TYPE_CONTRACT_REF.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_PHONE = ContractParameterPrefType.TYPE_PHONE.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_PHONE_ITEM = "contract_parameter_type_phone_item";
    public static final String CONTRACT_PARAMETER_TYPE_MULTILIST = ContractParameterPrefType.TYPE_MULTILIST.getTableName();
    public static final String CONTRACT_PARAMETER_TYPE_MULTILIST_ITEM = "contract_parameter_type_multilist_item";
    public static final String CONTRACT_PARAMETER_TYPE_MULTILIST_VALUES = "contract_parameter_type_multilist_values";
    private Map<Integer, ContractParameterPref> parameterIdTypeMap = null;
    protected Connection con;
    private Map<String, PreparedStatement> psCache = new HashMap<String, PreparedStatement>();

    public ContractParameterManager(Connection con) {
        this.con = con;
    }

    public static void resetParametersHistoryMap() {
        PARAMETERS_HISTORY = new HashMap<Integer, Boolean>();
    }

    private boolean checkParameterHistoryLogging(int pid) {
        return this.checkParameterHistoryLogging(this.con, pid);
    }

    private boolean checkParameterHistoryLogging(Connection con, int pid) {
        boolean result = false;
        if (PARAMETERS_HISTORY.containsKey(pid)) {
            result = PARAMETERS_HISTORY.get(pid);
        } else {
            try {
                HashMap<Integer, Boolean> historyMap = new HashMap<Integer, Boolean>();
                Statement st = con.createStatement();
                ResultSet rs = st.executeQuery("SELECT id, flags FROM contract_parameters_pref");
                while (rs.next()) {
                    boolean has;
                    int id = rs.getInt(1);
                    boolean bl = has = (rs.getInt(2) & 1) > 0;
                    if (id == pid) {
                        result = has;
                    }
                    historyMap.put(id, has);
                }
                rs.close();
                st.close();
                PARAMETERS_HISTORY.putAll(historyMap);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public Calendar getDateParam(int cid, int pid) {
        Calendar result = null;
        try {
            String query = "SELECT val FROM " + CONTRACT_PARAMETER_TYPE_DATE + " WHERE cid=? AND pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = TimeUtils.convertDateToCalendar((Date)rs.getDate(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, Date> getDateParamMap(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, Date> result = new HashMap<Integer, Date>();
        try {
            String query = "SELECT pid, val FROM " + CONTRACT_PARAMETER_TYPE_DATE + " WHERE cid=" + cid;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                int pid = rs.getInt(1);
                if (pids != null && !pids.contains(pid)) continue;
                result.put(pid, rs.getDate(2));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateDateParam(int cid, int pid, Date value, int userId) {
        int changeRows = 0;
        try {
            int index = 1;
            int foundRows = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM " + CONTRACT_PARAMETER_TYPE_DATE + " WHERE cid=? AND pid=?");
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows == 0) {
                PreparedStatement ps1 = this.con.prepareStatement("INSERT INTO " + CONTRACT_PARAMETER_TYPE_DATE + " SET cid=?, pid=?, val=?");
                ps1.setInt(index++, cid);
                ps1.setInt(index++, pid);
                ps1.setDate(index++, TimeUtils.convertDateToSqlDate((Date)value));
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                PreparedStatement ps2 = this.con.prepareStatement("UPDATE " + CONTRACT_PARAMETER_TYPE_DATE + " SET val=? WHERE cid=? AND pid=? AND NOT(val<=>?)");
                ps2.setDate(index++, TimeUtils.convertDateToSqlDate((Date)value));
                ps2.setInt(index++, cid);
                ps2.setInt(index++, pid);
                ps2.setDate(index++, TimeUtils.convertDateToSqlDate((Date)value));
                changeRows = ps2.executeUpdate();
                ps2.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateDateParamLog(cid, pid, value, userId);
        }
    }

    private void updateDateParamLog(int cid, int pid, Date value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_DATE + "_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)value));
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ContractParameterManager deleteDateParam(int cid, int pid, int userId) throws BGException {
        if (this.deleteParameter(cid, pid) > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateDateParamLog(cid, pid, null, userId);
        }
        return this;
    }

    public Boolean getFlagParam(int contractId, int parameterId) {
        Boolean result = null;
        try {
            String query = null;
            ResultSet rs = null;
            PreparedStatement ps = null;
            query = "SELECT val FROM " + CONTRACT_PARAMETER_TYPE_BOOLEAN + " WHERE cid=? AND pid=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            rs = ps.executeQuery();
            if (rs.next()) {
                result = new Boolean(rs.getBoolean(1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean getFlagParam(int contractId, int parameterId, boolean defaultValue) {
        boolean flagValue = defaultValue;
        Boolean param = this.getFlagParam(contractId, parameterId);
        if (param != null) {
            flagValue = param;
        }
        return flagValue;
    }

    public Map<Integer, Boolean> getFlagParamMap(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, Boolean> result = new HashMap<Integer, Boolean>();
        try {
            String query = "SELECT pid, val FROM " + CONTRACT_PARAMETER_TYPE_BOOLEAN + " WHERE cid=" + cid;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                int pid = rs.getInt(1);
                if (pids != null && !pids.contains(pid)) continue;
                result.put(pid, rs.getBoolean(2));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Deprecated
    public void setFlagParam(int cid, int pid, boolean value) {
        this.updateFlagParam(cid, pid, value, 0);
    }

    public void setFlagParam(int cid, int pid, boolean value, int userId) {
        this.updateFlagParam(cid, pid, value, userId);
    }

    public void updateFlagParam(int cid, int pid, boolean value, int userId) {
        int changeRows = 0;
        try {
            int index = 1;
            int foundRows = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM " + CONTRACT_PARAMETER_TYPE_BOOLEAN + " WHERE cid=? AND pid=?");
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows == 0) {
                PreparedStatement ps1 = this.con.prepareStatement("INSERT INTO " + CONTRACT_PARAMETER_TYPE_BOOLEAN + " SET cid=?, pid=?, val=?");
                ps1.setInt(index++, cid);
                ps1.setInt(index++, pid);
                ps1.setBoolean(index++, value);
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                PreparedStatement ps2 = this.con.prepareStatement("UPDATE " + CONTRACT_PARAMETER_TYPE_BOOLEAN + " SET val=? WHERE cid=? AND pid=? AND NOT(val<=>?)");
                ps2.setBoolean(index++, value);
                ps2.setInt(index++, cid);
                ps2.setInt(index++, pid);
                ps2.setBoolean(index++, value);
                changeRows = ps2.executeUpdate();
                ps2.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateFlagParamLog(cid, pid, value, userId);
        }
    }

    private void updateFlagParamLog(int cid, int pid, Boolean value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_BOOLEAN + "_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            if (value != null) {
                ps.setBoolean(index++, value);
            } else {
                ps.setObject(index++, null);
            }
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ContractParameterManager deleteFlagParam(int cid, int pid, int userId) throws BGException {
        if (this.deleteParameter(cid, pid) > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateFlagParamLog(cid, pid, null, userId);
        }
        return this;
    }

    public String getStringParam(int cid, int pid) {
        String result = null;
        try {
            String query = "SELECT val FROM " + CONTRACT_PARAMETER_TYPE_STRING + " WHERE cid=? AND pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, String> getStringParamMap(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        try {
            String query = "SELECT pid, val FROM " + CONTRACT_PARAMETER_TYPE_STRING + " WHERE cid=" + cid;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                int pid = rs.getInt(1);
                if (pids != null && !pids.contains(pid)) continue;
                result.put(pid, rs.getString(2));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public PhoneParamValue getPhoneParam(int cid, int pid) {
        PhoneParamValue value = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT * FROM ");
            query.append(CONTRACT_PARAMETER_TYPE_PHONE);
            query.append(" WHERE cid=? AND pid=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                value = new PhoneParamValue();
                value.setPhones(rs.getString("value"));
            }
            rs.close();
            ps.close();
            if (value != null) {
                query = new StringBuffer();
                query.append("SELECT * FROM ");
                query.append(CONTRACT_PARAMETER_TYPE_PHONE_ITEM);
                query.append(" WHERE cid=? AND pid=? ORDER BY n");
                ps = this.con.prepareStatement(query.toString());
                ps.setInt(1, cid);
                ps.setInt(2, pid);
                rs = ps.executeQuery();
                while (rs.next()) {
                    PhoneParamItem item = new PhoneParamItem();
                    item.setPhone(rs.getString("phone"));
                    item.setFormat(rs.getString("format"));
                    item.setComment(rs.getString("comment"));
                    value.addPhoneItem(item);
                }
                rs.close();
                ps.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public Map<Integer, PhoneParamValue> getPhoneParamMap(int contractId, Set<Integer> pids) throws BGException {
        HashMap<Integer, PhoneParamValue> result = new HashMap<Integer, PhoneParamValue>();
        try {
            int pid;
            String query = "SELECT * FROM " + CONTRACT_PARAMETER_TYPE_PHONE + " WHERE cid=" + contractId;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                pid = rs.getInt("pid");
                if (pids != null && !pids.contains(pid)) continue;
                PhoneParamValue value = new PhoneParamValue();
                value.setPhones(rs.getString("value"));
                result.put(pid, value);
            }
            rs.close();
            st.close();
            if (result.isEmpty()) {
                return result;
            }
            query = "SELECT * FROM " + CONTRACT_PARAMETER_TYPE_PHONE_ITEM + " WHERE cid=" + contractId + " ORDER BY n";
            st = this.con.createStatement();
            rs = st.executeQuery(query);
            while (rs.next()) {
                pid = rs.getInt("pid");
                if (pids != null && !pids.contains(pid)) continue;
                PhoneParamItem item = new PhoneParamItem();
                item.setPhone(rs.getString("phone"));
                item.setFormat(rs.getString("format"));
                item.setComment(rs.getString("comment"));
                PhoneParamValue value = (PhoneParamValue)result.get(pid);
                if (value == null) continue;
                value.addPhoneItem(item);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateStringParam(int contractId, int parameterId, String value, int userId) throws BGException {
        int changeRows = 0;
        try {
            int index = 1;
            int foundRows = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM " + CONTRACT_PARAMETER_TYPE_STRING + " WHERE cid=? AND pid=?");
            ps.setInt(index++, contractId);
            ps.setInt(index++, parameterId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows == 0) {
                PreparedStatement ps1 = this.con.prepareStatement("INSERT INTO " + CONTRACT_PARAMETER_TYPE_STRING + " SET cid=?, pid=?, val=?");
                ps1.setInt(index++, contractId);
                ps1.setInt(index++, parameterId);
                ps1.setString(index++, value);
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                PreparedStatement ps2 = this.con.prepareStatement("UPDATE " + CONTRACT_PARAMETER_TYPE_STRING + " SET val=? WHERE cid=? AND pid=? AND NOT(BINARY val<=> BINARY ?)");
                ps2.setString(index++, value);
                ps2.setInt(index++, contractId);
                ps2.setInt(index++, parameterId);
                ps2.setString(index++, value);
                changeRows = ps2.executeUpdate();
                ps2.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(parameterId)) {
            this.updateStringParamLog(contractId, parameterId, value, userId);
        }
    }

    private void updateStringParamLog(int contractId, int parameterId, String value, int userId) {
        try {
            int index = 1;
            String query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_STRING + "_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(index++, contractId);
            ps.setInt(index++, parameterId);
            ps.setString(index++, value);
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ContractParameterManager deleteStringParam(int contractId, int parameterId, int userId) throws BGException {
        if (this.deleteParameter(contractId, parameterId) > 0 && this.checkParameterHistoryLogging(parameterId)) {
            this.updateStringParamLog(contractId, parameterId, null, userId);
        }
        return this;
    }

    public void setContractRefParam(int cid, int pid, int value, int userId) {
        int changeRows = 0;
        try {
            int index = 1;
            int foundRows = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM " + CONTRACT_PARAMETER_TYPE_CONTRACT + " WHERE cid=? AND pid=?");
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows == 0) {
                PreparedStatement ps1 = this.con.prepareStatement("INSERT INTO " + CONTRACT_PARAMETER_TYPE_CONTRACT + " SET cid=?, pid=?, val=?");
                ps1.setInt(index++, cid);
                ps1.setInt(index++, pid);
                ps1.setInt(index++, value);
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                PreparedStatement ps2 = this.con.prepareStatement("UPDATE " + CONTRACT_PARAMETER_TYPE_CONTRACT + " SET val=? WHERE cid=? AND pid=? AND NOT(val<=>?)");
                ps2.setInt(index++, value);
                ps2.setInt(index++, cid);
                ps2.setInt(index++, pid);
                ps2.setInt(index++, value);
                changeRows = ps2.executeUpdate();
                ps2.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateIntegerParamLog(cid, pid, value, userId);
        }
    }

    public Integer getContractRefParam(int cid, int pid) {
        Integer result = null;
        String query = null;
        try {
            query = "SELECT val FROM " + CONTRACT_PARAMETER_TYPE_CONTRACT + " WHERE cid=? AND pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, Integer> getContractRefParamMap(int cid, Set<Integer> pids) throws SQLException {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT pid, val FROM ");
        query.append(CONTRACT_PARAMETER_TYPE_CONTRACT);
        query.append(" WHERE cid=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, cid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int pid = rs.getInt(1);
            if (pids != null && !pids.contains(pid)) continue;
            result.put(pid, rs.getInt(2));
        }
        rs.close();
        ps.close();
        return result;
    }

    private void updateIntegerParamLog(int cid, int pid, Integer value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_CONTRACT + "_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ps.setObject(index++, value);
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteContractRefParam(int cid, int pid, int userId) throws BGException {
        if (this.deleteParameter(cid, pid) > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateIntegerParamLog(cid, pid, null, userId);
        }
    }

    public Integer getListParam(int cid, int pid) {
        Integer result = null;
        try {
            String query = "SELECT val FROM " + CONTRACT_PARAMETER_TYPE_LIST + " WHERE cid=? AND pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isListValueUsed(int id) throws SQLException {
        return this.isListValueUsed(id, CONTRACT_PARAMETER_TYPE_LIST);
    }

    public boolean isMultiListValueUsed(int id) throws SQLException {
        return this.isListValueUsed(id, CONTRACT_PARAMETER_TYPE_MULTILIST_ITEM);
    }

    private boolean isListValueUsed(int id, String tableName) throws SQLException {
        boolean result = false;
        PreparedStatement ps = this.con.prepareStatement("SELECT COUNT(*) FROM " + tableName + " WHERE val=?");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1) > 0;
        }
        rs.close();
        ps.close();
        return result;
    }

    public String getListParamValue(int cid, int pid) throws BGException {
        ListParamValue value = this.getContractListParamValue(cid, pid);
        if (value == null) {
            return null;
        }
        return value.getId() == 0 ? value.getCustomValue() : value.getValue();
    }

    public String getMultiListParamValue(int cid, int pid) throws BGException {
        try {
            String query = "SELECT val FROM " + CONTRACT_PARAMETER_TYPE_MULTILIST + " WHERE cid=? AND pid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            String result = "";
            if (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public Map<Integer, ListParamValue> getListParamValueMap(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, ListParamValue> result = new HashMap<Integer, ListParamValue>();
        try {
            String query = "SELECT cp.pid, cp.val AS id, vls.title AS val, cp.custom_value AS custom_value FROM " + CONTRACT_PARAMETER_TYPE_LIST + " as cp LEFT JOIN " + CONTRACT_PARAMETER_TYPE_LIST_VALUES + " as vls ON vls.id=cp.val WHERE cid=" + cid;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                int pid = rs.getInt(1);
                if (pids != null && !pids.contains(pid)) continue;
                result.put(pid, this.getListParamValueFromRs(rs));
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Map<Integer, String> getMultiListParamValueMapString(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        try {
            String query = "SELECT pid, val FROM " + CONTRACT_PARAMETER_TYPE_MULTILIST + " WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int pid = rs.getInt(1);
                String value = rs.getString(2);
                if (pids != null && !pids.contains(pid)) continue;
                result.put(pid, value);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Map<Integer, MultiListParamValues> getMultiListParamValueMap(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, MultiListParamValues> result = new HashMap<Integer, MultiListParamValues>();
        try {
            Object query = "SELECT item.val AS id, val.title AS val, item.custom_value AS custom_value, item.pid AS pid FROM contract_parameter_type_multilist_item AS item  LEFT JOIN contract_parameter_type_multilist_values AS val on val.id = item.val where item.cid=?";
            if (pids != null && pids.size() != 0) {
                query = (String)query + " AND item.pid IN (" + Utils.toString(pids) + ")";
            }
            PreparedStatement ps = this.con.prepareStatement((String)query);
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int pid = rs.getInt("pid");
                MultiListParamValues listValues = (MultiListParamValues)result.get(pid);
                if (listValues == null) {
                    listValues = new MultiListParamValues();
                    result.put(pid, listValues);
                }
                listValues.add(this.getListParamValueFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateListParam(int cid, int pid, ListParamValue value, int userId) {
        int changeRows = 0;
        try {
            int index = 1;
            int foundRows = 0;
            PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM " + CONTRACT_PARAMETER_TYPE_LIST + " WHERE cid=? AND pid=?");
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("INSERT INTO ");
                sb.append(CONTRACT_PARAMETER_TYPE_LIST);
                sb.append(" SET cid=?, pid=?, val=?, custom_value=?");
                PreparedStatement ps1 = this.con.prepareStatement(sb.toString());
                ps1.setInt(index++, cid);
                ps1.setInt(index++, pid);
                ps1.setInt(index++, value.getId());
                ps1.setString(index++, value.getCustomValue());
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("UPDATE ");
                sb.append(CONTRACT_PARAMETER_TYPE_LIST);
                sb.append(" SET val=?, custom_value=?");
                sb.append(" WHERE cid=? AND pid=? AND (val<>? OR custom_value<>?)");
                PreparedStatement ps1 = this.con.prepareStatement(sb.toString());
                ps1.setInt(index++, value.getId());
                ps1.setString(index++, value.getCustomValue());
                ps1.setInt(index++, cid);
                ps1.setInt(index++, pid);
                ps1.setInt(index++, value.getId());
                ps1.setString(index++, value.getCustomValue());
                changeRows = ps1.executeUpdate();
                ps1.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (changeRows > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateListParamLog(cid, pid, value.getId(), value.getCustomValue(), userId);
        }
    }

    public void updateMultiListParameterAndItems(int cid, int pid, MultiListParamValues values, int userId) {
        try {
            int index = 1;
            StringBuilder sb = new StringBuilder();
            sb.append(" DELETE FROM ");
            sb.append(CONTRACT_PARAMETER_TYPE_MULTILIST_ITEM);
            sb.append(" WHERE cid=? AND pid=?");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ps.executeUpdate();
            ps.close();
            for (ListParamValue value : values) {
                index = 1;
                sb = new StringBuilder();
                sb.append("INSERT INTO ");
                sb.append(CONTRACT_PARAMETER_TYPE_MULTILIST_ITEM);
                sb.append(" SET cid=?, pid=?, val=?, custom_value=?");
                ps = this.con.prepareStatement(sb.toString());
                ps.setInt(index++, cid);
                ps.setInt(index++, pid);
                int id = value.getId();
                String customValue = value.getCustomValue();
                ps.setInt(index++, id);
                ps.setString(index, customValue);
                ps.executeUpdate();
                ps.close();
            }
            values = this.getMultiListParamValues(cid, pid);
            this.updateMultiListParameter(cid, pid, values, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateMultiListParameter(int cid, int pid, MultiListParamValues values, int userID) {
        this.updateMultiListParameter(this.con, cid, pid, values, userID);
    }

    public void updateMultiListParameter(Connection con, int cid, int pid, MultiListParamValues values, int userID) {
        String val = "";
        try {
            if (values.size() > 0) {
                val = values.toStringValue();
                String query = "REPLACE INTO " + CONTRACT_PARAMETER_TYPE_MULTILIST + " ( cid, pid, val ) VALUES (?, ?, ?)";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, cid);
                ps.setInt(2, pid);
                ps.setString(3, val);
                ps.executeUpdate();
                ps.close();
            } else {
                String query = "DELETE FROM " + CONTRACT_PARAMETER_TYPE_MULTILIST + " WHERE cid=? AND pid=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, cid);
                ps.setInt(2, pid);
                ps.executeUpdate();
                ps.close();
                val = null;
            }
            if (this.checkParameterHistoryLogging(con, pid)) {
                this.updateMultiListParamLog(con, cid, pid, val, userID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateListParamLog(int cid, int pid, Integer value, String customValue, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            String title = "";
            if (value != null) {
                title = value == 0 ? customValue : this.getListTitle(value, CONTRACT_PARAMETER_TYPE_LIST_VALUES);
            }
            query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_LIST + "_log SET cid=?, pid=?, val=?, title=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ps.setObject(index++, value);
            ps.setString(index++, title);
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateMultiListParamLog(int cid, int pid, String value, int userId) {
        this.updateMultiListParamLog(this.con, cid, pid, value, userId);
    }

    private void updateMultiListParamLog(Connection con, int cid, int pid, String value, int userId) {
        try (Connection connect = Setup.getSetup().getDBConnectionFromPool();){
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_MULTILIST + "_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
            ps = connect.prepareStatement(query);
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            ps.setObject(index++, value);
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getListTitle(int id) throws SQLException {
        return this.getListTitle(id, CONTRACT_PARAMETER_TYPE_LIST_VALUES);
    }

    public String getMultiListTitle(int id) throws SQLException {
        return this.getListTitle(id, CONTRACT_PARAMETER_TYPE_MULTILIST_VALUES);
    }

    private String getListTitle(int id, String tableName) throws SQLException {
        return this.getListTitle(this.con, id, tableName);
    }

    private String getListTitle(Connection con, int id, String tableName) throws SQLException {
        PreparedStatement ps = null;
        String query = "SELECT title FROM " + tableName + " WHERE id=?";
        ps = con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        String title = "";
        if (rs.next()) {
            title = rs.getString(1);
        }
        rs.close();
        ps.close();
        return title;
    }

    public List<IdTitle> getListValues(int parameterId) throws BGException {
        return this.getListValues(parameterId, CONTRACT_PARAMETER_TYPE_LIST_VALUES);
    }

    public List<IdTitle> getMultiListValues(int parameterId) throws BGException {
        return this.getListValues(parameterId, CONTRACT_PARAMETER_TYPE_MULTILIST_VALUES);
    }

    private List<IdTitle> getListValues(int parameterId, String tableName) throws BGException {
        ArrayList<IdTitle> list = new ArrayList<IdTitle>();
        try {
            String query = "SELECT id, title FROM " + tableName + " WHERE pid=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, parameterId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                IdTitle idTitle = new IdTitle(rs.getInt(1), rs.getString(2));
                list.add(idTitle);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    public ListParamValue getContractListParamValue(int contractId, int parameterId) throws BGException {
        ListParamValue listParamValue = null;
        try {
            String query = "SELECT id, title, custom_value FROM " + CONTRACT_PARAMETER_TYPE_LIST + " AS c LEFT JOIN contract_parameter_type_7_values AS v ON val=id WHERE c.pid=? AND c.cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, parameterId);
            ps.setInt(2, contractId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                listParamValue = new ListParamValue();
                listParamValue.setId(rs.getInt(1));
                listParamValue.setValue(rs.getString(2));
                listParamValue.setCustomValue(rs.getString(3));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return listParamValue;
    }

    public MultiListParamValues getMultiListParamValues(int contractId, int parameterId) throws SQLException {
        return this.getMultiListParameterValues(this.con, contractId, parameterId);
    }

    private MultiListParamValues getMultiListParameterValues(Connection con, int cid, int pid) throws SQLException {
        MultiListParamValues listValues = new MultiListParamValues();
        String query = "SELECT item.val AS id, val.title AS val, item.custom_value AS custom_value  FROM contract_parameter_type_multilist_item AS item  LEFT JOIN contract_parameter_type_multilist_values AS val on val.id = item.val where item.cid=? AND item.pid=?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setInt(1, cid);
        ps.setInt(2, pid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            listValues.add(this.getListParamValueFromRs(rs));
        }
        rs.close();
        ps.close();
        return listValues;
    }

    private ListParamValue getListParamValueFromRs(ResultSet rs) throws SQLException {
        ListParamValue value = new ListParamValue();
        value.setId(Utils.parseInt((String)rs.getString("id")));
        value.setValue(rs.getString("val"));
        value.setCustomValue(rs.getString("custom_value"));
        return value;
    }

    public int updateMultiListParameterValue(int id, int pid, String title) throws SQLException {
        if (pid > 0 && title != null && title.length() > 0) {
            return this.updateListValue(id, pid, title, CONTRACT_PARAMETER_TYPE_MULTILIST_VALUES);
        }
        return 0;
    }

    public void replaceMultiListCustomValues(int id, int pid, String customValue) throws SQLException {
        String query = "UPDATE contract_parameter_type_multilist_item SET val=?, custom_value=? WHERE pid=? AND custom_value=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setString(2, "");
        ps.setInt(3, pid);
        ps.setString(4, customValue);
        ps.executeUpdate();
        ps.close();
        query = "SELECT cid FROM contract_parameter_type_multilist_item WHERE pid=? AND val=?";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, pid);
        ps.setInt(2, id);
        ResultSet rs = ps.executeQuery();
        int cid = -1;
        while (rs.next()) {
            cid = rs.getInt(1);
            MultiListParamValues listValues = this.getMultiListParamValues(cid, pid);
            this.updateMultiListParameter(cid, pid, listValues, 0);
        }
        rs.close();
        ps.close();
    }

    public int updateListValue(int id, int pid, String title) throws SQLException {
        if (pid > 0 && title != null && title.length() > 0) {
            return this.updateListValue(id, pid, title, CONTRACT_PARAMETER_TYPE_LIST_VALUES);
        }
        return 0;
    }

    public void replaceCustomListValue(int id, int pid, String customValue) throws SQLException {
        String query = "UPDATE " + CONTRACT_PARAMETER_TYPE_LIST + " SET val=?, custom_value=? WHERE pid=? AND custom_value=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ps.setString(2, "");
        ps.setInt(3, pid);
        ps.setString(4, customValue);
        ps.executeUpdate();
        ps.close();
    }

    private int updateListValue(int id, final int pid, final String title, String tableName) throws SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (id == 0) {
            query = "INSERT INTO " + tableName + " ( pid, title ) VALUES (?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, pid);
            ps.setString(2, title);
            ps.executeUpdate();
            id = ServerUtils.lastInsertId(this.con);
        } else {
            query = "UPDATE " + tableName + " SET title=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setString(1, title);
            ps.setInt(2, id);
            ps.executeUpdate();
            if (tableName.equals(CONTRACT_PARAMETER_TYPE_MULTILIST)) {
                this.updateAllMultiListParamsOnContracts(pid, id);
            } else {
                final int finalId = id;
                ExecutorService executor = Executors.newFixedThreadPool(1);
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        String query = "SELECT cid FROM " + CONTRACT_PARAMETER_TYPE_LIST + " WHERE pid=? AND val=?";
                        try (Connection connect = Setup.getSetup().getDBConnectionFromPool();
                             PreparedStatement ps = connect.prepareStatement(query);){
                            ps.setInt(1, pid);
                            ps.setInt(2, finalId);
                            ResultSet rs = ps.executeQuery();
                            while (rs.next()) {
                                ContractParameterManager.this.updateListParamLog(rs.getInt(1), pid, finalId, title, 0);
                            }
                            rs.close();
                        }
                        catch (SQLException exp) {
                            exp.printStackTrace();
                        }
                    }
                });
            }
        }
        ps.close();
        return id;
    }

    private void updateAllMultiListParamsOnContracts(final int pid, final int val) throws SQLException {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                String query = "SELECT cid FROM contract_parameter_type_multilist_item WHERE pid=? AND val=? ";
                try (Connection connect = Setup.getSetup().getDBConnectionFromPool();
                     PreparedStatement ps = connect.prepareStatement(query);){
                    ps.setInt(1, pid);
                    ps.setInt(2, val);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        int cid = rs.getInt(1);
                        MultiListParamValues listValues = ContractParameterManager.this.getMultiListParameterValues(connect, cid, pid);
                        ContractParameterManager.this.updateMultiListParameter(connect, cid, pid, listValues, 0);
                    }
                    rs.close();
                }
                catch (SQLException exp) {
                    exp.printStackTrace();
                }
            }
        });
    }

    public boolean checkMultiListValue(int val, int pid) throws SQLException {
        String query = null;
        PreparedStatement ps = null;
        query = "SELECT COUNT(*) FROM contract_parameter_type_multilist_item WHERE pid=? AND val=? ";
        ps = this.con.prepareStatement(query);
        ps.setInt(1, pid);
        ps.setInt(2, val);
        ResultSet rs = ps.executeQuery();
        int value = 0;
        while (rs.next()) {
            value = rs.getInt(1);
        }
        rs.close();
        ps.close();
        return value != 0;
    }

    public void deleteListValue(int id) throws SQLException {
        this.deleteListValue(id, CONTRACT_PARAMETER_TYPE_LIST_VALUES);
    }

    public void deleteMultiListValue(int id) throws SQLException {
        this.deleteListValue(id, CONTRACT_PARAMETER_TYPE_MULTILIST_VALUES);
    }

    private void deleteListValue(int id, String tableName) throws SQLException {
        if (id > 0) {
            String query = "DELETE FROM " + tableName + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
    }

    public void deleteListCustomValue(String customValue, int pid) throws SQLException {
        this.deleteListCustomValue(customValue, pid, CONTRACT_PARAMETER_TYPE_LIST);
    }

    public void deleteMultiListCustomValue(String customValue, int pid) throws SQLException {
        String query = "SELECT cid FROM contract_parameter_type_multilist_item WHERE pid=? AND custom_value=? ";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, pid);
        ps.setString(2, customValue);
        ResultSet rs = ps.executeQuery();
        ArrayList<Integer> contracts = new ArrayList<Integer>();
        while (rs.next()) {
            int cid = rs.getInt(1);
            contracts.add(cid);
        }
        this.deleteListCustomValue(customValue, pid, CONTRACT_PARAMETER_TYPE_MULTILIST_ITEM);
        for (Integer cid : contracts) {
            MultiListParamValues listValues = this.getMultiListParamValues(cid, pid);
            this.updateMultiListParameter(cid, pid, listValues, 0);
        }
        rs.close();
        ps.close();
    }

    private void deleteListCustomValue(String customValue, int pid, String tableName) throws SQLException {
        String query = "DELETE FROM " + tableName + " WHERE custom_value=? AND pid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, customValue);
        ps.setInt(2, pid);
        ps.executeUpdate();
        ps.close();
    }

    public int getMultilistParamId(String title) throws SQLException {
        String query = "SELECT id FROM contract_parameter_type_multilist_values WHERE title = ?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(1, title);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            int result = rs.getInt(1);
            rs.close();
            ps.close();
            return result;
        }
        rs.close();
        ps.close();
        return -1;
    }

    public MultiListParamValues setMultiListTitleValues(MultiListParamValues listValues) throws SQLException {
        for (ListParamValue elemListValues : listValues) {
            int id = elemListValues.getId();
            if (id == -1) continue;
            String value = this.getListTitle(id, CONTRACT_PARAMETER_TYPE_MULTILIST_VALUES);
            elemListValues.setValue(value);
        }
        return listValues;
    }

    public ContractParameterManager deleteListParam(int cid, int pid, int userId) throws BGException {
        if (this.deleteParameter(cid, pid) > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateListParamLog(cid, pid, null, null, userId);
        }
        return this;
    }

    @Deprecated
    public List<IdTitle> getParameterListValues(int parameterId) throws BGException {
        return this.getListValues(parameterId);
    }

    public String getEmailFromParam(int cid, int pid) {
        if (cid < 1 || pid < 1) {
            return null;
        }
        ContractEmailParamValue mailParam = this.getEmailParam(cid, pid);
        if (mailParam != null) {
            return mailParam.getEmail();
        }
        return this.getStringParam(cid, pid);
    }

    public ContractEmailParamValue getEmailParam(int cid, int pid) {
        ContractEmailParamValue result = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT id, email FROM " + CONTRACT_PARAMETER_TYPE_EMAIL + " WHERE cid=" + cid + " AND pid=" + pid);){
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new ContractEmailParamValue();
                result.setEmailId(rs.getInt("id"));
                result.setEmail(rs.getString("email"));
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<Integer, ContractEmailParamValue> getEmailParamMap(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, ContractEmailParamValue> result = new HashMap<Integer, ContractEmailParamValue>();
        try {
            String query = "SELECT id, email, pid FROM " + CONTRACT_PARAMETER_TYPE_EMAIL + " WHERE cid=" + cid;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                int pid = rs.getInt("pid");
                if (pids != null && !pids.contains(pid)) continue;
                ContractEmailParamValue value = new ContractEmailParamValue();
                value.setEmailId(rs.getInt("id"));
                value.setEmail(rs.getString("email"));
                result.put(pid, value);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateEmailParam(int contractId, int parameterId, ContractEmailParamValue value, int userId) throws BGException {
        if (value == null || Utils.isEmptyString((String)value.getEmail())) {
            try (PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + CONTRACT_PARAMETER_TYPE_EMAIL + " WHERE cid=? AND pid=?");){
                ps.setInt(1, contractId);
                ps.setInt(2, parameterId);
                if (ps.executeUpdate() <= 0 || !this.checkParameterHistoryLogging(parameterId)) return;
                this.updateEmailParamLog(contractId, parameterId, null, userId);
                return;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + CONTRACT_PARAMETER_TYPE_EMAIL + " SET cid=?, pid=?, email=? ON DUPLICATE KEY UPDATE email=?");){
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            ps.setString(3, value.getEmail());
            ps.setString(4, value.getEmail());
            if (ps.executeUpdate() <= 0 || !this.checkParameterHistoryLogging(parameterId)) return;
            this.updateEmailParamLog(contractId, parameterId, value, userId);
            return;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateEmailParamLog(int contractId, int parameterId, ContractEmailParamValue value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_EMAIL + "_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, contractId);
            ps.setInt(index++, parameterId);
            ps.setString(index++, value == null ? null : value.getEmail());
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ContractAddressParamValue getAddressParam(int contractId, int parameterId) {
        ContractAddressParamValue result = null;
        try (PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + CONTRACT_PARAMETER_TYPE_ADDRESS + " WHERE cid=? AND pid=?");){
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result = new ContractAddressParamValue();
                    result.setHouseId(rs.getInt("hid"));
                    result.setPod(rs.getInt("pod"));
                    result.setFlat(rs.getString("flat"));
                    result.setRoom(rs.getString("room"));
                    result.setFloor(rs.getInt("floor"));
                    result.setAddress(rs.getString("address"));
                    result.setComment(rs.getString("comment"));
                    result.setFormatKey(rs.getString("format_key"));
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Map<Integer, ContractAddressParamValue> getAddressParamMap(int cid, Set<Integer> pids) throws BGException {
        HashMap<Integer, ContractAddressParamValue> result = new HashMap<Integer, ContractAddressParamValue>();
        try {
            String query = "SELECT * FROM " + CONTRACT_PARAMETER_TYPE_ADDRESS + " WHERE cid=" + cid;
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                int pid = rs.getInt("pid");
                if (pids != null && !pids.contains(pid)) continue;
                ContractAddressParamValue value = new ContractAddressParamValue();
                value.setHouseId(rs.getInt("hid"));
                value.setPod(rs.getInt("pod"));
                value.setFlat(rs.getString("flat"));
                value.setRoom(rs.getString("room"));
                value.setFloor(rs.getInt("floor"));
                value.setAddress(rs.getString("address"));
                value.setComment(rs.getString("comment"));
                value.setFormatKey(rs.getString("format_key"));
                result.put(pid, value);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public Map<Integer, Integer> getAddressCustomParam() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String sql = "SELECT pid, count(*) FROM contract_parameter_type_2 where hid='0' group by pid";
        try {
            PreparedStatement ps = this.con.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                map.put(rs.getInt("pid"), rs.getInt(2));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public void updateAddressParam(int cid, int pid, ContractAddressParamValue value, int userId) throws BGException {
        try {
            boolean foundRows = false;
            int changeRows = 0;
            PreparedStatement ps = null;
            StringBuilder query = new StringBuilder();
            query.append("SELECT ");
            query.append("count(*)");
            query.append(" FROM ");
            query.append(CONTRACT_PARAMETER_TYPE_ADDRESS);
            query.append(" WHERE ");
            query.append("cid=? AND pid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                foundRows = rs.getInt(1) > 0;
            }
            rs.close();
            ps.close();
            int index = 1;
            if (foundRows) {
                query = new StringBuilder();
                query.append("UPDATE ");
                query.append(CONTRACT_PARAMETER_TYPE_ADDRESS);
                query.append(" SET ");
                query.append("hid=?, pod=?, flat=?, room=?, floor=?, address=?, comment=?, format_key=?");
                query.append(" WHERE ");
                query.append("cid=? AND pid=? AND (hid!=? OR pod!=? OR flat!=? OR room!=? OR floor!=? OR address!=? OR comment!=? OR format_key!=?)");
                PreparedStatement ps1 = this.con.prepareStatement(query.toString());
                index = this.setAddressPs(value, ps1, index);
                ps1.setInt(index++, cid);
                ps1.setInt(index++, pid);
                this.setAddressPs(value, ps1, index);
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                query = new StringBuilder();
                query.append("INSERT INTO ");
                query.append(CONTRACT_PARAMETER_TYPE_ADDRESS);
                query.append(" SET ");
                query.append("hid=?, pod=?, flat=?, room=?, floor=?, address=?, comment=?, format_key=?, cid=?, pid=?");
                PreparedStatement ps1 = this.con.prepareStatement(query.toString());
                index = this.setAddressPs(value, ps1, index);
                ps1.setInt(index++, cid);
                ps1.setInt(index++, pid);
                changeRows = ps1.executeUpdate();
                ps1.close();
            }
            if (changeRows > 0 && this.checkParameterHistoryLogging(pid)) {
                this.updateAddressParamLog(cid, pid, value, userId);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void updateAddressParamLog(int cid, int pid, ContractAddressParamValue value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_ADDRESS + "_log SET cid=?, pid=?, val=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, cid);
            ps.setInt(index++, pid);
            if (value != null) {
                ps.setString(index++, value.getAddress());
            } else {
                ps.setObject(index++, null);
            }
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int setAddressPs(ContractAddressParamValue value, PreparedStatement ps, int index) throws SQLException {
        ps.setInt(index++, value.getHouseId());
        ps.setInt(index++, value.getPod());
        ps.setString(index++, value.getFlat());
        ps.setString(index++, value.getRoom());
        ps.setInt(index++, value.getFloor());
        ps.setString(index++, value.getAddress());
        ps.setString(index++, value.getComment());
        ps.setString(index++, value.getFormatKey());
        return index;
    }

    public void deleteAddressParam(int cid, int pid, int userId) throws BGException {
        if (this.deleteParameter(cid, pid) > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updateAddressParamLog(cid, pid, null, userId);
        }
    }

    public void updatePhoneParam(int cid, int pid, PhoneParamValue value, int userId) {
        if (value != null) {
            boolean flagIsChange = false;
            try {
                int index = 1;
                int rowCountBD = 0;
                PreparedStatement ps = this.con.prepareStatement("SELECT count(*) FROM contract_parameter_type_phone_item WHERE cid=? AND pid=?");
                ps.setInt(index++, cid);
                ps.setInt(index++, pid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    rowCountBD = rs.getInt(1);
                }
                rs.close();
                ps.close();
                index = 1;
                ps = this.con.prepareStatement("SELECT phone, comment, format FROM contract_parameter_type_phone_item WHERE cid=? AND pid=?");
                ps.setInt(index++, cid);
                ps.setInt(index++, pid);
                rs = ps.executeQuery();
                if (rowCountBD == value.size()) {
                    int n = 0;
                    while (rs.next()) {
                        String clientFormat;
                        PhoneParamItem item = value.getPhoneItem(n);
                        String bdFild = rs.getString("comment") + rs.getString("phone");
                        String clientFild = item != null ? item.getPhone() + item.getComment() : "";
                        String bdFormat = rs.getString("format");
                        String string = clientFormat = item != null & item.getFormat() != null ? item.getFormat() : "";
                        if (!bdFild.equals(clientFild) || !clientFormat.equals(bdFormat)) {
                            flagIsChange = true;
                        }
                        ++n;
                    }
                } else {
                    flagIsChange = true;
                }
                rs.close();
                ps.close();
                Object query = null;
                if (flagIsChange) {
                    index = 1;
                    query = "DELETE FROM contract_parameter_type_phone_item WHERE pid=? AND cid=? ";
                    ps = this.con.prepareStatement((String)query);
                    ps.setInt(index++, pid);
                    ps.setInt(index++, cid);
                    ps.executeUpdate();
                    ps.close();
                    index = 1;
                    query = "DELETE FROM " + CONTRACT_PARAMETER_TYPE_PHONE + " WHERE pid=? AND cid=? ";
                    ps = this.con.prepareStatement((String)query);
                    ps.setInt(index++, pid);
                    ps.setInt(index++, cid);
                    ps.executeUpdate();
                    ps.close();
                    index = 1;
                    query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_PHONE + " SET pid=?, cid=?, value=?";
                    ps = this.con.prepareStatement((String)query);
                    ps.setInt(index++, pid);
                    ps.setInt(index++, cid);
                    ps.setString(index++, value.getPhones() == null ? "" : value.getPhones());
                    ps.executeUpdate();
                    ps.close();
                    index = 1;
                    query = "INSERT INTO contract_parameter_type_phone_item SET pid=?, cid=?, n=?, phone=?, format=?, comment=?";
                    ps = this.con.prepareStatement((String)query);
                    ps.setInt(index++, pid);
                    ps.setInt(index++, cid);
                    for (int n = 0; n < value.size(); ++n) {
                        index = 3;
                        PhoneParamItem item = value.getPhoneItem(n);
                        ps.setInt(index++, n + 1);
                        ps.setString(index++, item.getPhone());
                        ps.setString(index++, item.getFormat());
                        ps.setString(index++, item.getComment());
                        ps.executeUpdate();
                    }
                    ps.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (flagIsChange) {
                this.updatePhoneParamLog(cid, pid, value, userId);
            }
        }
    }

    private void updatePhoneParamLog(int cid, int pid, PhoneParamValue value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO " + CONTRACT_PARAMETER_TYPE_PHONE + "_log SET pid=?, cid=?, val=?, data=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, pid);
            ps.setInt(index++, cid);
            if (value != null) {
                ps.setString(index++, value.getPhones());
                ps.setString(index++, value.getData());
            } else {
                ps.setString(index++, null);
                ps.setString(index++, null);
            }
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteEmailParam(int contractId, int parameterId, int userId) throws BGException {
        if (this.deleteParameter(contractId, parameterId) > 0 && this.checkParameterHistoryLogging(parameterId)) {
            this.updateEmailParamLog(contractId, parameterId, null, userId);
        }
    }

    public void deletePhoneParam(int cid, int pid, int userId) throws BGException {
        if (this.deleteParameter(cid, pid) > 0 && this.checkParameterHistoryLogging(pid)) {
            this.updatePhoneParamLog(cid, pid, null, userId);
        }
    }

    public void deleteParamForContractByType(int parameterTypeId, int contractId) {
        this.deleteParamForContract(this.getTableName(parameterTypeId), contractId);
        if (parameterTypeId == 9) {
            this.deleteParamForContract(CONTRACT_PARAMETER_TYPE_PHONE_ITEM, contractId);
        } else if (parameterTypeId == 11) {
            this.deleteParamForContract(CONTRACT_PARAMETER_TYPE_MULTILIST_ITEM, contractId);
        }
        this.deleteParamLogForContractByType(parameterTypeId, contractId);
    }

    public void deleteParamLogForContractByType(int parameterTypeId, int contractId) {
        this.deleteParamForContract(this.getTableName(parameterTypeId) + "_log", contractId);
    }

    public void deleteParam(int parameterId) throws BGException {
        try {
            PreparedStatement ps;
            ContractParameterPrefType pt = this.getParamPref(parameterId).getType();
            if (pt == ContractParameterPrefType.TYPE_SEPARATOR) {
                return;
            }
            if (pt == ContractParameterPrefType.TYPE_EMAIL) {
                ps = this.con.prepareStatement("DELETE m.* FROM contract_parameter_type_3_mail m LEFT JOIN contract_parameter_type_3 t ON t.id=m.eid WHERE t.pid=" + parameterId);
                ps.executeUpdate();
                ps.close();
            }
            StringBuffer query = new StringBuffer();
            query.append("DELETE FROM ");
            query.append(pt.getTableName());
            query.append(" WHERE pid=?");
            ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, parameterId);
            ps.executeUpdate();
            ps.close();
            if (pt == ContractParameterPrefType.TYPE_PHONE) {
                ps = this.con.prepareStatement("DELETE FROM contract_parameter_type_phone_item WHERE pid=" + parameterId);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteParamLog(int parameterId) throws BGException {
        try {
            ContractParameterPrefType pt = this.getParamPref(parameterId).getType();
            if (pt == ContractParameterPrefType.TYPE_SEPARATOR) {
                return;
            }
            StringBuffer query = new StringBuffer();
            query.append("DELETE FROM ");
            query.append(pt.getTableName());
            query.append("_log WHERE pid=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, parameterId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void deleteParamForContract(String tableName, int cid) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "DELETE FROM " + tableName + " WHERE cid=?";
            ps = this.createPs(query);
            ps.setInt(index++, cid);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private PreparedStatement createPs(String query) throws SQLException {
        PreparedStatement ps = this.psCache.get(query);
        if (ps == null) {
            ps = this.con.prepareStatement(query);
            this.psCache.put(query, ps);
        }
        return ps;
    }

    private int deleteParameter(int contractId, int parameterId) throws BGException {
        int updateRows = 0;
        ContractParameterPrefType pt = this.getParamPref(parameterId).getType();
        try {
            PreparedStatement ps = null;
            ps = this.con.prepareStatement("DELETE FROM " + pt.getTableName() + " WHERE cid=? AND pid=?");
            ps.setInt(1, contractId);
            ps.setInt(2, parameterId);
            updateRows = ps.executeUpdate();
            ps.close();
            if (pt == ContractParameterPrefType.TYPE_PHONE) {
                ps = this.con.prepareStatement("DELETE FROM contract_parameter_type_phone_item WHERE cid=? AND pid=?");
                ps.setInt(1, contractId);
                ps.setInt(2, parameterId);
                updateRows = ps.executeUpdate();
                ps.close();
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return updateRows;
    }

    public List<ParameterHistoryEntry> getParameterHistory(int cid, int pid) throws BGException {
        ArrayList<ParameterHistoryEntry> result = new ArrayList<ParameterHistoryEntry>();
        try {
            ContractParameterPrefType pt = this.getParamPref(pid).getType();
            String query = "SELECT " + this.getValueSelect(pt) + ", log.dt_change, user.name, user_id  FROM " + pt.getTableName() + "_log AS log  LEFT JOIN user ON log.user_id=user.id  WHERE log.cid=? AND log.pid=?  ORDER BY log.dt_change";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, pid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ParameterHistoryEntry entry = new ParameterHistoryEntry();
                entry.setValue(rs.getString(1));
                entry.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(2)));
                int userId = rs.getInt(4);
                if (userId == -1) {
                    entry.setUser("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c");
                } else if (userId == 0) {
                    entry.setUser("\u0421\u0435\u0440\u0432\u0435\u0440");
                } else if (rs.getString(3) == null) {
                    entry.setUser("??? [userId=" + userId + "]");
                } else {
                    entry.setUser(rs.getString(3));
                }
                result.add(entry);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void clearParameterHistory(int cid, int pid, int parameterTypeId) throws SQLException {
        String sql = "DELETE FROM " + this.getTableName(parameterTypeId) + "_log WHERE cid=? AND pid=?";
        PreparedStatement ps = this.con.prepareStatement(sql);
        ps.setInt(1, cid);
        ps.setInt(2, pid);
        ps.executeUpdate();
        ps.close();
    }

    public String getTableName(int parameterTypeId) {
        ContractParameterPrefType type = ContractParameterPrefType.getType(parameterTypeId);
        return type.getTableName();
    }

    public List<String> getEmailParameterByContractId(int contractId) throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append(" email ");
        query.append(" FROM ");
        query.append(CONTRACT_PARAMETER_TYPE_EMAIL);
        query.append(" WHERE ");
        query.append("cid=?");
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(1, contractId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            if (Utils.isBlankString((String)rs.getString(1))) continue;
            list.add(rs.getString(1));
        }
        rs.close();
        ps.close();
        return list;
    }

    public List<IdTitle> getAllParams(int cid, String tableName, String pids) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT param.pid, pref.title");
            query.append(" FROM ");
            query.append(tableName);
            query.append(" AS param LEFT JOIN contract_parameters_pref AS pref ON param.pid=pref.id ");
            query.append(" WHERE param.cid=?");
            if (pids != null) {
                query.append(" AND param.pid IN (");
                query.append(pids);
                query.append(")");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new IdTitle(rs.getInt("pid"), rs.getString("pref.title")));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void copyContractParams(String where, Map<String, ColumnValue> valuesPairs) {
        TableCopier copier = new TableCopier(this.con);
        try {
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_STRING, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_ADDRESS, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_EMAIL, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_SERVICING_PERSON, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_BOOLEAN, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_DATE, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_LIST, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_CONTRACT, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_PHONE, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_PHONE_ITEM, where, valuesPairs);
            copier.copyRecord(CONTRACT_PARAMETER_TYPE_MULTILIST, where, valuesPairs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void searchCustomAddress(SearchResult<String[]> searchResult, int parameterId) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List result = searchResult.getList();
            try {
                String query = "SELECT SQL_CALC_FOUND_ROWS cid, address, a.comment, pid, contract.title FROM contract_parameter_type_2 AS a LEFT JOIN contract ON contract.id=a.cid WHERE pid=" + parameterId + " AND hid=0" + page.sqlLimit();
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query);
                while (rs.next()) {
                    int index = 0;
                    String[] value = new String[5];
                    value[index++] = rs.getString("cid");
                    value[index++] = rs.getString("address");
                    value[index++] = rs.getString("a.comment");
                    value[index++] = rs.getString("pid");
                    value[index++] = rs.getString("contract.title");
                    result.add(value);
                }
                rs.close();
                st.close();
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    private String getValueSelect(ContractParameterPrefType parameterType) {
        String title = "log.val as value";
        if (parameterType == ContractParameterPrefType.TYPE_LIST) {
            title = "concat( '[id=', CAST(log.val AS CHAR), '] ', IF(ISNULL(log.title),'',log.title) ) as value";
        }
        return title;
    }

    @Deprecated
    public HashMap<Integer, String> getValuesForPids(List<Integer> pids, int cid) {
        return this.getValuesForPids(new HashSet<Integer>(pids), cid);
    }

    public HashMap<Integer, String> getValuesForPids(Set<Integer> pids, int contractId) {
        LinkedHashMap<Integer, String> values = new LinkedHashMap<Integer, String>();
        try (ContractParameterPrefDao prefDao = new ContractParameterPrefDao(this.con);){
            Map<Integer, String> dataType1 = null;
            Map<Integer, ContractAddressParamValue> dataType2 = null;
            Map<Integer, ContractEmailParamValue> dataType3 = null;
            HashMap dataType4 = null;
            HashMap<String, String> directory = null;
            Map<Integer, Boolean> dataType5 = null;
            Map<Integer, Date> dataType6 = null;
            Map<Integer, ListParamValue> dataTypeList = null;
            Map<Integer, ContractParamValue> dataType8 = null;
            Map<Integer, PhoneParamValue> dataType9 = null;
            Map<Integer, MultiListParamValues> dataTypeMultiList = null;
            for (ContractParameterPref pid : prefDao.getContractParameterPrefList(pids)) {
                String value = null;
                switch (pid.getType()) {
                    case TYPE_TEXT: {
                        String strParam;
                        if (dataType1 == null) {
                            dataType1 = this.getStringParamMap(contractId, pids);
                        }
                        value = (strParam = dataType1.get(pid.getId())) != null ? strParam : null;
                        break;
                    }
                    case TYPE_ADDRESS: {
                        ContractAddressParamValue address;
                        if (dataType2 == null) {
                            dataType2 = this.getAddressParamMap(contractId, pids);
                        }
                        value = (address = dataType2.get(pid.getId())) != null ? address.getAddress() : null;
                        break;
                    }
                    case TYPE_EMAIL: {
                        ContractEmailParamValue emailParamValue;
                        if (dataType3 == null) {
                            dataType3 = this.getEmailParamMap(contractId, pids);
                        }
                        if ((emailParamValue = dataType3.get(pid.getId())) == null || emailParamValue.getEmail() == null) break;
                        value = emailParamValue.getEmail().replaceAll("\n", "; ");
                        break;
                    }
                    case TYPE_SERVICING_PERSON: {
                        Hashtable val;
                        Integer integ;
                        ResultSet rs;
                        PreparedStatement ps;
                        if (dataType4 == null) {
                            dataType4 = new HashMap();
                            ps = this.con.prepareStatement("SELECT pid, val1, val2 FROM contract_parameter_type_4 WHERE cid=" + contractId);
                            try {
                                rs = ps.executeQuery();
                                while (rs.next()) {
                                    Integer pd = rs.getInt(1);
                                    String string = rs.getString(3);
                                    Hashtable<String, Integer> val3 = (Hashtable<String, Integer>)dataType4.get(pd);
                                    if (val3 == null) {
                                        val3 = new Hashtable<String, Integer>();
                                        val3.put(string, 1);
                                        dataType4.put(pd, val3);
                                        continue;
                                    }
                                    integ = (Integer)val3.get(string);
                                    val3.put(string, integ == null ? 1 : integ + 1);
                                }
                                rs.close();
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                        }
                        if (directory == null) {
                            directory = new HashMap<String, String>();
                            ps = this.con.prepareStatement("SELECT id, title FROM contract_parameter_type_4_directory");
                            try {
                                rs = ps.executeQuery();
                                while (rs.next()) {
                                    directory.put(rs.getString(1), rs.getString(2));
                                }
                                rs.close();
                            }
                            finally {
                                if (ps != null) {
                                    ps.close();
                                }
                            }
                        }
                        if ((val = (Hashtable)dataType4.get(pid.getId())) == null) break;
                        StringBuilder buf = new StringBuilder();
                        for (Map.Entry entry : val.entrySet()) {
                            String title = (String)directory.get(entry.getKey());
                            integ = (Integer)entry.getValue();
                            if (title == null || integ == null) continue;
                            if (buf.length() > 0) {
                                buf.append("; ");
                            }
                            buf.append(title);
                            buf.append(": ");
                            buf.append(integ);
                        }
                        value = buf.toString();
                        break;
                    }
                    case TYPE_FLAG: {
                        Boolean bool;
                        if (dataType5 == null) {
                            dataType5 = this.getFlagParamMap(contractId, pids);
                        }
                        value = (bool = dataType5.get(pid.getId())) != null ? Utils.booleanToStringInt((boolean)bool) : null;
                        break;
                    }
                    case TYPE_DATE: {
                        Date date;
                        if (dataType6 == null) {
                            dataType6 = this.getDateParamMap(contractId, pids);
                        }
                        value = (date = dataType6.get(pid.getId())) != null ? TimeUtils.formatDate((Date)dataType6.get(pid.getId())) : null;
                        break;
                    }
                    case TYPE_LIST: {
                        ListParamValue listParamValue;
                        if (dataTypeList == null) {
                            dataTypeList = this.getListParamValueMap(contractId, null);
                        }
                        value = (listParamValue = dataTypeList.get(pid.getId())) != null ? listParamValue.toString() : null;
                        break;
                    }
                    case TYPE_CONTRACT_REF: {
                        ContractParamValue param;
                        if (dataType8 == null) {
                            dataType8 = this.getContractParamValueMap(contractId);
                        }
                        String string = value = (param = dataType8.get(pid.getId())) == null ? null : param.getTitle();
                        if (value != null || pids == null) break;
                        value = "";
                        break;
                    }
                    case TYPE_PHONE: {
                        PhoneParamValue phoneParamValue;
                        if (dataType9 == null) {
                            dataType9 = this.getPhoneParamMap(contractId, pids);
                        }
                        value = (phoneParamValue = dataType9.get(pid.getId())) != null ? phoneParamValue.getPhones() : null;
                        break;
                    }
                    case TYPE_MULTILIST: {
                        MultiListParamValues multiListParamValues;
                        if (dataTypeMultiList == null) {
                            dataTypeMultiList = this.getMultiListParamValueMap(contractId, null);
                        }
                        String string = value = (multiListParamValues = dataTypeMultiList.get(pid.getId())) != null ? multiListParamValues.toStringValue() : null;
                    }
                }
                if (value == null) continue;
                values.put(pid.getId(), value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public String getTextlikeParam(int contractId, final int pid) {
        if (contractId <= 0 || pid <= 0) {
            return null;
        }
        HashMap<Integer, String> v = this.getValuesForPids((Set<Integer>)new HashSet<Integer>(){
            {
                this.add(pid);
            }
        }, contractId);
        return v.getOrDefault(pid, null);
    }

    public ContractParameterPref getParamPref(int parameterId) throws BGException {
        ContractParameterPref result;
        if (this.parameterIdTypeMap == null) {
            this.parameterIdTypeMap = new HashMap<Integer, ContractParameterPref>();
        }
        if ((result = this.parameterIdTypeMap.get(parameterId)) == null) {
            try (ContractParameterPrefDao prefDao = new ContractParameterPrefDao(this.con);){
                ContractParameterPref pref = (ContractParameterPref)prefDao.get(parameterId);
                if (pref == null) {
                    throw new BGException("Type parameterId not found!");
                }
                result = pref;
                this.parameterIdTypeMap.put(parameterId, result);
            }
        }
        return result;
    }

    public Map<Integer, ContractParamValue> getContractParamValueMap(int cid) throws BGException {
        HashMap<Integer, ContractParamValue> result = new HashMap<Integer, ContractParamValue>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT t1.pid, contract.title, contract.comment FROM contract_parameter_type_8 AS t1 LEFT JOIN contract ON contract.id=t1.val WHERE t1.cid=?");
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (!Utils.notBlankString((String)rs.getString(2))) continue;
                ContractParamValue value = new ContractParamValue();
                value.setId(rs.getInt(1));
                value.setTitle(rs.getString(2));
                value.setComment(rs.getString(3));
                result.put(value.getId(), value);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    @Override
    public void close() throws BGException {
        try {
            for (PreparedStatement ps : this.psCache.values()) {
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

