/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.object.bean;

import bitel.billing.server.contract.bean.ParameterHistoryEntry;
import bitel.billing.server.contract.object.bean.AddressParamValue;
import bitel.billing.server.contract.object.bean.ContractObject;
import bitel.billing.server.contract.object.bean.DateParamValue;
import bitel.billing.server.contract.object.bean.FlagParamValue;
import bitel.billing.server.contract.object.bean.ListParamValue;
import bitel.billing.server.contract.object.bean.ObjectManager;
import bitel.billing.server.contract.object.bean.ParamValue;
import bitel.billing.server.contract.object.bean.TextParamValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ParamValueManager {
    private static volatile HashMap<Integer, Boolean> PARAMETERS_HISTORY = new HashMap();
    private Connection con;
    private static final String PARAM_PREF = "object_param";
    private static final String TEXT_VALUE_TABLE = "object_param_value_text";
    private static final String DATE_VALUE_TABLE = "object_param_value_date";
    private static final String LIST_VALUE_TABLE = "object_param_value_list";
    private static final String ADDRESS_VALUE_TABLE = "object_param_value_address";
    private static final String FLAG_VALUE_TABLE = "object_param_value_flag";

    public ParamValueManager(Connection con) {
        this.con = con;
    }

    public void deleteActivityParamValues(int objectId) {
        this.deleteValuesFromTable(objectId, TEXT_VALUE_TABLE);
        this.deleteValuesFromTable(objectId, DATE_VALUE_TABLE);
        this.deleteValuesFromTable(objectId, LIST_VALUE_TABLE);
        this.deleteValuesFromTable(objectId, ADDRESS_VALUE_TABLE);
        this.deleteValuesFromTable(objectId, FLAG_VALUE_TABLE);
    }

    public void copyObjectParams(int fromObject, int toObject) {
        try {
            this.copyParams(TEXT_VALUE_TABLE, "param_id, value", fromObject, toObject);
            this.copyParams(DATE_VALUE_TABLE, "param_id, value", fromObject, toObject);
            this.copyParams(LIST_VALUE_TABLE, "param_id, value", fromObject, toObject);
            this.copyParams(ADDRESS_VALUE_TABLE, "param_id, hid, flat, room, pod, floor, address, comment", fromObject, toObject);
            this.copyParams(FLAG_VALUE_TABLE, "param_id, value", fromObject, toObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyParams(String tableName, String columns, int fromObject, int toObject) throws SQLException {
        String query = "INSERT INTO " + tableName + " (object_id, " + columns + ") SELECT ?, " + columns + " FROM " + tableName + " WHERE object_id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, toObject);
        ps.setInt(2, fromObject);
        ps.executeUpdate();
        ps.close();
    }

    private void deleteValuesFromTable(int objectId, String tableName) {
        try {
            String query = "DELETE FROM " + tableName + " WHERE object_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AddressParamValue getAddressParamValue(int objectId, int paramId) {
        AddressParamValue result = null;
        try {
            String query = "SELECT * FROM object_param_value_address WHERE object_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getAddressParam(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void searchCustomAddressParams(SearchResult<String[]> searchResult, int paramId) throws BGException {
        Page page = searchResult.getPage();
        List result = searchResult.getList();
        try {
            String query = "SELECT SQL_CALC_FOUND_ROWS address, a.comment, object_id, param_id, object.title FROM " + ADDRESS_VALUE_TABLE + " AS a LEFT JOIN object ON object.id=a.object_id WHERE param_id=" + paramId + " AND hid=0" + page.sqlLimit();
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                int index = 0;
                String[] value = new String[5];
                value[index++] = rs.getString("object_id");
                value[index++] = rs.getString("address");
                value[index++] = rs.getString("a.comment");
                value[index++] = rs.getString("param_id");
                value[index++] = rs.getString("object.title");
                result.add(value);
            }
            rs.close();
            st.close();
            page.setRecordCount(ServerUtils.foundRows(this.con));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public DateParamValue getDateParamValue(int objectId, int paramId) {
        DateParamValue result = null;
        try {
            String query = "SELECT * FROM object_param_value_date WHERE object_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getDateParam(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public ListParamValue getListParamValue(int objectId, int paramId) {
        ListParamValue result = null;
        try {
            String query = "SELECT * FROM object_param_value_list WHERE object_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getListParam(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public TextParamValue getTextParamValue(int objectId, int paramId) {
        TextParamValue result = null;
        try {
            String query = "SELECT * FROM object_param_value_text WHERE object_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getTextParam(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public FlagParamValue getFlagParamValue(int objectId, int paramId) {
        FlagParamValue result = null;
        try {
            String query = "SELECT * FROM object_param_value_flag WHERE object_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFlagParam(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateParamValue(ParamValue value, int userId) throws BGMessageException {
        if (value instanceof TextParamValue) {
            this.updateTextParam((TextParamValue)value, userId);
        } else if (value instanceof AddressParamValue) {
            if (((AddressParamValue)value).getAddress().length() > 0) {
                this.updateAddressParam((AddressParamValue)value, userId);
            } else if (this.deleteParamValue(value, ADDRESS_VALUE_TABLE) > 0) {
                AddressParamValue param = (AddressParamValue)value;
                param.setAddress("");
                this.updateAddressParamLog(param, userId);
            }
        } else if (value instanceof DateParamValue) {
            this.updateDateParam((DateParamValue)value, userId);
        } else if (value instanceof ListParamValue) {
            if (((ListParamValue)value).getValue() != 0) {
                this.updateListParam((ListParamValue)value, userId);
            } else if (this.deleteParamValue(value, LIST_VALUE_TABLE) > 0) {
                this.updateListParamLog((ListParamValue)value, userId);
            }
        } else if (value instanceof FlagParamValue) {
            this.updateFlagParam((FlagParamValue)value, userId);
        }
        ObjectManager objectManager = new ObjectManager(this.con);
        ContractObject object = objectManager.getObject(value.getObjectId());
        objectManager.saveTitleByMacros(object);
    }

    private void updateTextParam(TextParamValue value, int userId) {
        int changeRows = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int index = 1;
            int foundRows = 0;
            ps = this.con.prepareStatement("SELECT count(*) FROM object_param_value_text WHERE object_id=? AND param_id=? ");
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows > 0) {
                PreparedStatement ps1 = this.con.prepareStatement("UPDATE object_param_value_text SET value=? WHERE object_id=? AND param_id=? AND NOT(value<=>?)  ");
                ps1.setString(index++, value.getValue());
                ps1.setInt(index++, value.getObjectId());
                ps1.setInt(index++, value.getParamId());
                ps1.setString(index++, value.getValue());
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                PreparedStatement ps2 = this.con.prepareStatement("INSERT INTO object_param_value_text (object_id, param_id, value) VALUES (?, ?, ?)");
                ps2.setInt(index++, value.getObjectId());
                ps2.setInt(index++, value.getParamId());
                ps2.setString(index++, value.getValue());
                changeRows = ps2.executeUpdate();
                ps2.close();
            }
            if (changeRows > 0 && this.checkParameterHistoryLogging(value.getParamId())) {
                this.updateTextParamLog(value, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateFlagParam(FlagParamValue value, int userId) {
        int changeRows = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int index = 1;
            int foundRows = 0;
            ps = this.con.prepareStatement("SELECT count(*) FROM object_param_value_flag WHERE object_id=? AND param_id=?");
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows > 0) {
                PreparedStatement ps1 = this.con.prepareStatement("UPDATE object_param_value_flag SET value=? WHERE object_id=? AND param_id=? AND NOT(value<=>?)");
                ps1.setBoolean(index++, value.getValue());
                ps1.setInt(index++, value.getObjectId());
                ps1.setInt(index++, value.getParamId());
                ps1.setBoolean(index++, value.getValue());
                changeRows = ps1.executeUpdate();
                ps1.close();
            } else {
                PreparedStatement ps2 = this.con.prepareStatement("INSERT INTO object_param_value_flag (object_id, param_id, value) VALUES (?, ?, ?)");
                ps2.setInt(index++, value.getObjectId());
                ps2.setInt(index++, value.getParamId());
                ps2.setBoolean(index++, value.getValue());
                changeRows = ps2.executeUpdate();
                ps2.close();
            }
            if (changeRows > 0 && this.checkParameterHistoryLogging(value.getParamId())) {
                this.updateFlagParamLog(value, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateListParam(ListParamValue value, int userId) {
        int changeRows = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int index = 1;
            int foundRows = 0;
            ps = this.con.prepareStatement("SELECT count(*) FROM object_param_value_list WHERE object_id=? AND param_id=? ");
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            index = 1;
            if (foundRows > 0) {
                ps = this.con.prepareStatement("UPDATE object_param_value_list SET value=? WHERE object_id=? AND param_id=? AND NOT(value<=>?) ");
                ps.setInt(index++, value.getValue());
                ps.setInt(index++, value.getObjectId());
                ps.setInt(index++, value.getParamId());
                ps.setInt(index++, value.getValue());
                changeRows = ps.executeUpdate();
            } else {
                ps = this.con.prepareStatement("INSERT INTO object_param_value_list (object_id, param_id, value) VALUES (?, ?, ?)");
                ps.setInt(index++, value.getObjectId());
                ps.setInt(index++, value.getParamId());
                ps.setInt(index++, value.getValue());
                changeRows = ps.executeUpdate();
            }
            ps.close();
            if (changeRows > 0 && this.checkParameterHistoryLogging(value.getParamId())) {
                this.updateListParamLog(value, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateAddressParam(AddressParamValue value, int userId) {
        try {
            PreparedStatement ps = null;
            int foundRows = 0;
            int changeRows = 0;
            ps = this.con.prepareStatement("SELECT count(*) FROM object_param_value_address WHERE object_id=? AND param_id=?");
            ps.setInt(1, value.getObjectId());
            ps.setInt(2, value.getParamId());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                foundRows = rs.getInt(1);
            }
            ps.close();
            if (foundRows > 0) {
                String query = "UPDATE object_param_value_address SET hid=?, flat=?, room=?, pod=?, floor=?, address=?, comment=?, format_key=? WHERE object_id=? AND param_id=? AND (hid!=? OR flat!=? OR room!=? OR pod!=? OR floor!=? OR address!=? OR comment!=? OR format_key!=?)";
                ps = this.con.prepareStatement(query);
                int index = 1;
                ps.setInt(1, value.getHouseId());
                index = this.setAddressPs(value, ps, index);
                ps.setInt(index++, value.getObjectId());
                ps.setInt(index++, value.getParamId());
                this.setAddressPs(value, ps, index);
                changeRows = ps.executeUpdate();
            } else {
                String query = "INSERT INTO object_param_value_address (object_id, param_id, hid, flat, room, pod, floor, address, comment, format_key) VALUES  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query);
                int index = 1;
                ps.setInt(index++, value.getObjectId());
                ps.setInt(index++, value.getParamId());
                this.setAddressPs(value, ps, index);
                changeRows = ps.executeUpdate();
            }
            ps.close();
            if (changeRows > 0 && this.checkParameterHistoryLogging(value.getParamId())) {
                this.updateAddressParamLog(value, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int setAddressPs(AddressParamValue value, PreparedStatement ps, int index) throws SQLException {
        ps.setInt(index++, value.getHouseId());
        ps.setString(index++, value.getFlat());
        ps.setString(index++, value.getRoom());
        ps.setInt(index++, value.getPod());
        ps.setInt(index++, value.getFloor());
        ps.setString(index++, value.getAddress());
        ps.setString(index++, value.getComment());
        ps.setString(index++, value.getFormatKey());
        return index;
    }

    private void updateDateParam(DateParamValue value, int userId) {
        int changeRows = 0;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            int index = 1;
            int foundRows = 0;
            ps = this.con.prepareStatement("SELECT count(*) FROM object_param_value_date WHERE object_id=? AND param_id=?");
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            rs = ps.executeQuery();
            while (rs.next()) {
                foundRows = rs.getInt(1);
            }
            rs.close();
            ps.close();
            if (foundRows > 0) {
                ps = this.con.prepareStatement("UPDATE object_param_value_date SET value=? WHERE object_id=? AND param_id=? AND NOT(value<=>?)");
                index = 1;
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)value.getValue()));
                ps.setInt(index++, value.getObjectId());
                ps.setInt(index++, value.getParamId());
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)value.getValue()));
                changeRows = ps.executeUpdate();
            } else {
                ps = this.con.prepareStatement("INSERT INTO object_param_value_date(object_id, param_id, value) VALUES (?, ?, ?)");
                index = 1;
                ps.setInt(index++, value.getObjectId());
                ps.setInt(index++, value.getParamId());
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)value.getValue()));
                changeRows = ps.executeUpdate();
            }
            ps.close();
            if (changeRows > 0 && this.checkParameterHistoryLogging(value.getParamId())) {
                this.updateDateParamLog(value, userId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int deleteParamValue(ParamValue value, String tableName) {
        int res = 0;
        try {
            String query = "DELETE FROM " + tableName + " WHERE object_id=? AND param_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, value.getObjectId());
            ps.setInt(2, value.getParamId());
            res = ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public Map<Integer, ParamValue> getObjectParamMap(int objectId) {
        HashMap<Integer, ParamValue> result = new HashMap<Integer, ParamValue>();
        this.loadParams(result, objectId, TEXT_VALUE_TABLE);
        this.loadParams(result, objectId, ADDRESS_VALUE_TABLE);
        this.loadParams(result, objectId, DATE_VALUE_TABLE);
        this.loadParams(result, objectId, LIST_VALUE_TABLE);
        this.loadParams(result, objectId, FLAG_VALUE_TABLE);
        return result;
    }

    private void loadParams(Map<Integer, ParamValue> params, int objectId, String tableName) {
        try {
            String query = "SELECT * FROM " + tableName + " WHERE object_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ParamValue value = null;
                if (tableName.equals(TEXT_VALUE_TABLE)) {
                    value = this.getTextParam(rs);
                } else if (tableName.equals(ADDRESS_VALUE_TABLE)) {
                    value = this.getAddressParam(rs);
                } else if (tableName.equals(DATE_VALUE_TABLE)) {
                    value = this.getDateParam(rs);
                } else if (tableName.equals(LIST_VALUE_TABLE)) {
                    value = this.getListParam(rs);
                } else if (tableName.equals(FLAG_VALUE_TABLE)) {
                    value = this.getFlagParam(rs);
                }
                params.put(value.getParamId(), value);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private TextParamValue getTextParam(ResultSet rs) throws SQLException {
        TextParamValue value = new TextParamValue();
        value.setObjectId(rs.getInt("object_id"));
        value.setParamId(rs.getInt("param_id"));
        value.setValue(rs.getString("value"));
        return value;
    }

    private FlagParamValue getFlagParam(ResultSet rs) throws SQLException {
        FlagParamValue value = new FlagParamValue();
        value.setObjectId(rs.getInt("object_id"));
        value.setParamId(rs.getInt("param_id"));
        value.setValue(rs.getBoolean("value"));
        return value;
    }

    private AddressParamValue getAddressParam(ResultSet rs) throws SQLException {
        AddressParamValue value = new AddressParamValue();
        value.setObjectId(rs.getInt("object_id"));
        value.setParamId(rs.getInt("param_id"));
        value.setHouseId(rs.getInt("hid"));
        value.setFlat(rs.getString("flat"));
        value.setRoom(rs.getString("room"));
        value.setPod(rs.getInt("pod"));
        value.setFloor(rs.getInt("floor"));
        value.setAddress(rs.getString("address"));
        value.setComment(rs.getString("comment"));
        value.setFormatKey(rs.getString("format_key"));
        return value;
    }

    private DateParamValue getDateParam(ResultSet rs) throws SQLException {
        DateParamValue value = new DateParamValue();
        value.setObjectId(rs.getInt("object_id"));
        value.setParamId(rs.getInt("param_id"));
        value.setValue(TimeUtils.convertDateToCalendar((Date)rs.getDate("value")));
        return value;
    }

    private ListParamValue getListParam(ResultSet rs) throws SQLException {
        ListParamValue value = new ListParamValue();
        value.setObjectId(rs.getInt("object_id"));
        value.setParamId(rs.getInt("param_id"));
        value.setValue(rs.getInt("value"));
        return value;
    }

    public static void resetParametersHistoryMap() {
        PARAMETERS_HISTORY = new HashMap();
    }

    private boolean checkParameterHistoryLogging(int pid) {
        boolean result = false;
        if (PARAMETERS_HISTORY.containsKey(pid)) {
            result = PARAMETERS_HISTORY.get(pid);
        } else {
            try {
                HashMap<Integer, Boolean> historyMap = new HashMap<Integer, Boolean>();
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery("SELECT id, flags FROM object_param");
                while (rs.next()) {
                    int id = rs.getInt(1);
                    boolean has = rs.getBoolean(2);
                    if (id == pid) {
                        result = has;
                    }
                    historyMap.put(id, has);
                }
                rs.close();
                st.close();
                PARAMETERS_HISTORY.putAll(historyMap);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    private void updateTextParamLog(TextParamValue value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO object_param_value_text_log SET object_id=?, param_id=?, value=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            ps.setString(index++, value.getValue());
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateFlagParamLog(FlagParamValue value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO object_param_value_flag_log SET object_id=?, param_id=?, value=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            ps.setBoolean(index++, value.getValue());
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateListParamLog(ListParamValue value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            String title = "";
            if (value != null) {
                query = "SELECT title FROM object_list_value WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, value.getValue());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    title = rs.getString(1);
                }
                rs.close();
                ps.close();
            }
            query = "INSERT INTO object_param_value_list_log SET object_id=?, param_id=?, value=?, title =? ,dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            ps.setInt(index++, value.getValue());
            ps.setString(index++, title);
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateDateParamLog(DateParamValue value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO object_param_value_date_log SET object_id=?, param_id=?, value=?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)value.getValue()));
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateAddressParamLog(AddressParamValue value, int userId) {
        try {
            int index = 1;
            String query = null;
            PreparedStatement ps = null;
            query = "INSERT INTO object_param_value_address_log SET object_id=?, param_id  =?, value =?, dt_change=now(), user_id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(index++, value.getObjectId());
            ps.setInt(index++, value.getParamId());
            ps.setString(index++, value.getAddress() != null ? value.getAddress() : "");
            ps.setInt(index++, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getValueSelect(int parameterType) {
        String title = "value";
        if (parameterType == 2) {
            title = "concat( '[id=', CAST(log.value AS CHAR), '] ', IF(ISNULL(log.title),'',log.title) ) as value";
        }
        return title;
    }

    private String getTableName(int parameterTypeId) {
        switch (parameterTypeId) {
            case 1: {
                return TEXT_VALUE_TABLE;
            }
            case 2: {
                return LIST_VALUE_TABLE;
            }
            case 3: {
                return DATE_VALUE_TABLE;
            }
            case 4: {
                return ADDRESS_VALUE_TABLE;
            }
            case 5: {
                return FLAG_VALUE_TABLE;
            }
        }
        return TEXT_VALUE_TABLE;
    }

    public List<ParameterHistoryEntry> getParameterHistory(int objectId, int paramId, int parameterTypeId) {
        ArrayList<ParameterHistoryEntry> result = new ArrayList<ParameterHistoryEntry>();
        try {
            String query = "SELECT " + this.getValueSelect(parameterTypeId) + ", log.dt_change, log.user_id  FROM " + this.getTableName(parameterTypeId) + "_log AS log  WHERE log.object_id=? AND log.param_id=?  ORDER BY log.dt_change";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, objectId);
            ps.setInt(2, paramId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ParameterHistoryEntry entry = new ParameterHistoryEntry();
                entry.setValue(rs.getString(1));
                entry.setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(2)));
                entry.setUser(rs.getString(3));
                result.add(entry);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void clearParameterHistory(int objectId, int paramId, int paramTypeId) throws SQLException {
        String sql = "DELETE FROM " + this.getTableName(paramTypeId) + "_log WHERE object_id=? AND param_id=?";
        PreparedStatement ps = this.con.prepareStatement(sql);
        ps.setInt(1, objectId);
        ps.setInt(2, paramId);
        ps.executeUpdate();
        ps.close();
    }
}

