/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.tariff.action;

import bitel.billing.server.contract.bean.PersonalTariff;
import bitel.billing.server.contract.bean.PersonalTariffManager;
import bitel.billing.server.contract.tariff.action.base.ActionBase;
import bitel.billing.server.tariff.TariffTreeBuilder;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.event.events.PersonalTariffDeleteEvent;
import ru.bitel.bgbilling.kernel.tariff.server.event.ContractTariffChangedEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Utils;

public class ActionDeletePersonalTariff
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int id = this.getIntParameter("id", -1);
        if (id <= 0) {
            throw new BGIllegalArgumentException();
        }
        PersonalTariffManager manager = new PersonalTariffManager(this.con);
        PersonalTariff tariff = manager.getPersonalTariff(id);
        if (tariff != null) {
            String error;
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionDeletePersonalTariff", this.mid, this.userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForDelete(closedDate, tariff.getDate1());
            }
            if (Utils.notBlankString((String)(error = new TariffTreeBuilder(this.con).deleteTree(tariff.getTreeId())))) {
                throw new BGException(error);
            }
            String query = "DELETE FROM contract_tree_link WHERE tree_id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, tariff.getTreeId());
            ps.executeUpdate();
            ps.close();
            manager.deletePersonalTariff(id);
            this.context.publishAfterCommit(new ContractTariffChangedEvent(this.cid));
            this.context.publishAfterCommit(new PersonalTariffDeleteEvent(this.userId, this.cid, id));
        }
    }
}

