/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.telnet;

import bitel.billing.server.util.telnet.TelnetInputStream;
import bitel.billing.server.util.terminal.AbstractTerminalSession;
import bitel.billing.server.util.terminal.AnsiTerminalInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import ru.bitel.bgbilling.common.BGException;

public class TelnetSession
extends AbstractTerminalSession {
    private Socket socket = null;

    public TelnetSession(String host, int port) {
        super(host, port);
        this.host = host;
        this.port = port;
    }

    @Override
    protected void initConnection() throws IOException {
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(this.host, this.port), this.socketTimeTimeout);
        this.socket.setSoTimeout(this.socketTimeTimeout);
        this.inputStream = this.socket.getInputStream();
        OutputStream out = this.socket.getOutputStream();
        this.inputStream = new BufferedInputStream(this.inputStream);
        this.inputStream = new TelnetInputStream(this.inputStream, out);
        this.inputStream = new AnsiTerminalInputStream(this.inputStream);
        this.outPutStream = out;
    }

    @Override
    public void disconnect() throws BGException {
        try {
            this.socket.close();
            this.inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

