/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.webmenu.server.service;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.bean.WebMenuItem;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.bean.WebMenuModuleItem;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.service.WebMenuService;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.MenuItem;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebContractSearchModule;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebMenuDao;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.api.server.Module;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.server.WebMenu;
import ru.bitel.bgbilling.server.WebMenuBase;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.webmenu.common.service.WebMenuService")
public class WebMenuServiceImpl
extends AbstractService
implements WebMenuService {
    @Override
    public List<WebMenuItem> webMenuList(boolean loadCount) throws BGException {
        try (WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());){
            List<WebMenuItem> list = webMenuDao.list();
            Map<Integer, Integer> countMap = webMenuDao.getContractCount();
            Object object = list.iterator();
            while (object.hasNext()) {
                WebMenuItem webMenuItem;
                Integer count = countMap.get((webMenuItem = object.next()).getId());
                webMenuItem.setCount(count == null ? 0 : count);
            }
            object = list;
            return object;
        }
    }

    @Override
    public List<WebMenuItem> webMenuContractList(int contractId) throws BGException {
        ArrayList<WebMenuItem> list = new ArrayList<WebMenuItem>();
        try (WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());){
            int webMenuId = webMenuDao.getWebMenuIdForContract(contractId);
            for (WebMenuItem webMenuItem : webMenuDao.list()) {
                webMenuItem.setSelected(webMenuId == webMenuItem.getId());
                list.add(webMenuItem);
            }
            WebMenuItem webMenuItem = new WebMenuItem();
            webMenuItem.setId(-1);
            webMenuItem.setSelected(webMenuId == -1);
            webMenuItem.setTitle("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            list.add(0, webMenuItem);
        }
        return list;
    }

    @Override
    public WebMenuItem webMenuInfoUpdate(WebMenuItem webMenuItem) throws BGException {
        try (WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());){
            WebMenuItem webMenuItem2 = webMenuDao.updateInfo(webMenuItem);
            return webMenuItem2;
        }
    }

    @Override
    public WebMenuItem webMenuInfoGet(int webMenuItemId) throws BGException {
        try (WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());){
            WebMenuItem webMenuItem = (WebMenuItem)webMenuDao.get(webMenuItemId);
            return webMenuItem;
        }
    }

    @Override
    public void setWebMenuIdForContract(int webMenuItemId, int contractId) throws BGException {
        try (WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());){
            webMenuDao.setWebMenuIdForContract(webMenuItemId, contractId);
        }
    }

    @Override
    public void webMenuDataUpdate(int webMenuItemId, String webMenuItemData) throws BGException {
        try (WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());){
            webMenuDao.updateData(webMenuItemId, webMenuItemData);
        }
    }

    @Override
    public String webMenuDataGet(int webMenuItemId) throws BGException {
        try (WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());){
            String string = webMenuDao.getData(webMenuItemId);
            return string;
        }
    }

    @Override
    public void webMenuDataDelete(int webMenuItemId) throws BGException {
        try (WebMenuDao webMenuDao = new WebMenuDao(this.getConnection());){
            webMenuDao.deleteData(webMenuItemId);
        }
    }

    @Override
    public WebMenuModuleItem[] webMenuModuleItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        Connection con = this.getConnection();
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            try {
                String packServer = module.getInstalledModule().getPackageServer();
                Class<?> result = Class.forName(packServer + ".Module");
                Class<WebMenuBase> menuBaseClass = result.asSubclass(WebMenuBase.class);
                WebMenuBase menuBase = menuBaseClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                for (MenuItem menuItem : menuBase.getWebMenuItems(con, module.getName(), module.getId(), true)) {
                    WebMenuModuleItem item = new WebMenuModuleItem();
                    item.setModuleId(module.getId());
                    item.setModuleName(module.getName());
                    item.setModuleTitle(module.getTitle());
                    item.setAction(menuItem.getAction());
                    item.setTitle(menuItem.getTitle());
                    item.setIcon(menuItem.getIcon());
                    item.setCssClass(menuItem.getCssClass());
                    item.setDescription(menuItem.getDescription());
                    list.add(item);
                }
            }
            catch (Exception exception) {
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }

    @Override
    public WebMenuModuleItem[] webMenuKernelItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        BGInstalledModule kernel = new BGInstalledModule();
        kernel.setType("module");
        kernel.setPackageServer(Module.class.getPackage().getName());
        kernel.setName("contract");
        Element extension = kernel.getServerExtensionMap().get(WebMenu.class.getName());
        if (extension != null) {
            for (Element itemElement : XMLUtils.selectElements((Node)extension, (String)"item")) {
                String moduleName = itemElement.getAttribute("module");
                WebMenuModuleItem item = new WebMenuModuleItem();
                item.setModuleId(0);
                item.setModuleName(moduleName.isEmpty() ? "contract" : moduleName);
                item.setModuleTitle("\u042f\u0434\u0440\u043e");
                item.setAction(itemElement.getAttribute("action"));
                item.setTitle(itemElement.getAttribute("titleDefault"));
                list.add(item);
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }

    @Override
    public WebMenuModuleItem[] webMenuPluginItems() throws BGException {
        ArrayList<WebMenuModuleItem> list = new ArrayList<WebMenuModuleItem>();
        for (BGPlugInElement extension : BGPluginManagerServer.getManager().getExtensions(WebMenu.class.getName(), false)) {
            if (extension == null) continue;
            for (Element itemElement : XMLUtils.selectElements((Node)extension.getElement(), (String)"item")) {
                WebMenuModuleItem item = new WebMenuModuleItem();
                item.setModuleId(0);
                item.setModuleName(extension.getPlugin().getId());
                item.setModuleTitle(extension.getPlugin().getName());
                item.setAction(itemElement.getAttribute("action"));
                item.setTitle(itemElement.getAttribute("titleDefault"));
                list.add(item);
            }
        }
        return list.toArray(new WebMenuModuleItem[0]);
    }

    @Override
    public JSONObject webActionOperations() throws BGException, BGMessageException {
        JSONObject json = new JSONObject();
        JSONArray modules = new JSONArray();
        json.put("modules", (Object)modules);
        for (BGModule module : ModuleCache.getInstance().getModulesList()) {
            JSONObject moduleJson = new JSONObject();
            moduleJson.put("name", (Object)module.getName());
            JSONArray moduleActions = new JSONArray();
            moduleJson.put("actions", (Object)moduleActions);
            modules.put((Object)moduleJson);
            String packageName = module.getInstalledModule().getPackageServer() + ".action.web";
            for (Class<?> clazz : ServerUtils.getClassList(packageName)) {
                if (!clazz.isAnnotationPresent(WebAction.class)) continue;
                WebAction webAction = clazz.getAnnotation(WebAction.class);
                try {
                    Class<AbstractAction> abstractActionClass = clazz.asSubclass(AbstractAction.class);
                    JSONObject action = new JSONObject();
                    action.put("action", (Object)clazz.getSimpleName().substring(6));
                    action.put("title", (Object)webAction.title());
                    JSONArray actionOperations = new JSONArray();
                    action.put("operations", (Object)actionOperations);
                    moduleActions.put((Object)action);
                    for (Method method : abstractActionClass.getMethods()) {
                        if (!method.isAnnotationPresent(WebOperation.class)) continue;
                        WebOperation webOperation = method.getAnnotation(WebOperation.class);
                        JSONObject operation = new JSONObject();
                        operation.put("operation", (Object)method.getName());
                        operation.put("title", (Object)webOperation.title());
                        actionOperations.put((Object)operation);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return json;
    }

    @Override
    public List<KeyValue> getIconDirs() throws BGException, BGMessageException {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        Path webrootPath = Paths.get("webroot", "img");
        if (Files.exists(webrootPath, new LinkOption[0])) {
            try {
                Files.list(webrootPath).forEach(i -> {
                    if (Files.isDirectory(i, new LinkOption[0])) {
                        list.add(new KeyValue(i.getFileName().toString(), i.getFileName().toString()));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public List<KeyValue> getIconFiles(String dirName) throws BGException, BGMessageException {
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        Path webrootPath = Paths.get("webroot", "img", dirName);
        if (Files.exists(webrootPath, new LinkOption[0])) {
            try {
                Files.list(webrootPath).forEach(i -> {
                    if (Files.isRegularFile(i, new LinkOption[0])) {
                        list.add(new KeyValue(i.getFileName().toString(), i.getFileName().toString()));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public JSONArray getComponentList() throws BGException, BGMessageException {
        JSONArray array = new JSONArray();
        for (BGModule bgModule : ModuleCache.getInstance().getModulesList()) {
            try {
                String packServer = bgModule.getInstalledModule().getPackageServer();
                Class<?> result = Class.forName(packServer + ".Module");
                Class<WebMenuBase> menuBaseClass = result.asSubclass(WebMenuBase.class);
                if (menuBaseClass == null) continue;
                ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(bgModule.getId());
                Element extension = ModuleCache.getInstance().getInstalledModule(bgModule.getName()).getServerExtensionMap().get(WebMenu.class.getName());
                if (extension == null) continue;
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("type", (Object)"module");
                jsonObject.put("moduleName", (Object)bgModule.getName());
                jsonObject.put("moduleTitle", (Object)bgModule.getTitle());
                jsonObject.put("moduleId", bgModule.getId());
                JSONArray itemArray = new JSONArray();
                jsonObject.put("items", (Object)itemArray);
                for (Element itemElement : XMLUtils.selectElements((Node)extension, (String)"item")) {
                    int id = Utils.parseInt((String)itemElement.getAttribute("id"));
                    String title = itemElement.getAttribute("titleDefault");
                    String webMenuItemTitle = moduleSetup.get("web.menuItem" + id, null);
                    if (webMenuItemTitle != null) {
                        if ("none".equals(webMenuItemTitle)) continue;
                        title = webMenuItemTitle;
                    } else if ("0".equals(itemElement.getAttribute("defaultVisible"))) continue;
                    JSONObject itemJsonObject = new JSONObject();
                    itemJsonObject.put("id", id);
                    itemJsonObject.put("title", (Object)title);
                    itemJsonObject.put("icon", (Object)itemElement.getAttribute("icon"));
                    itemJsonObject.put("description", (Object)itemElement.getAttribute("description"));
                    itemJsonObject.put("action", (Object)itemElement.getAttribute("action"));
                    itemArray.put((Object)itemJsonObject);
                }
                array.put((Object)jsonObject);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return array;
    }

    @Override
    public JSONArray getContractSearchModuleList() throws BGException, BGMessageException {
        JSONArray array = new JSONArray();
        DynamicCodeDao dynamicCodeDao = new DynamicCodeDao(this.getConnection());
        List<String> classesName = dynamicCodeDao.getActualClassesByInterface(WebContractSearchModule.class.getName());
        for (String className : classesName) {
            WebContractSearchModule webContractSearchModule = DynamicClassManager.getInstance().newInstance(WebContractSearchModule.class, className);
            webContractSearchModule.init(this.getConnection());
            JSONObject json = new JSONObject();
            json.put("className", (Object)className);
            json.put("title", (Object)webContractSearchModule.getTitle());
            JSONArray params = new JSONArray();
            webContractSearchModule.getParameters().forEach(a -> {
                JSONObject paramJson = new JSONObject();
                paramJson.put("key", (Object)a.getKey());
                paramJson.put("type", (Object)a.getType().name());
                paramJson.put("value", (Object)a.getValue());
                params.put((Object)paramJson);
            });
            json.put("params", (Object)params);
            array.put((Object)json);
        }
        return array;
    }

    @Override
    public void updateContractSearchModuleParams(String className, JSONArray params) throws BGException, BGMessageException {
        JSONObject jsonObject = new JSONObject();
        params.forEach(a -> jsonObject.put(((JSONObject)a).getString("key"), (Object)((JSONObject)a).getString("value")));
        ServerUtils.setSetupValue(this.getConnection(), className, jsonObject.toString());
    }
}

