/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogReader;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogWriter;

public class DataLog<D extends DataLog<D>>
implements Closeable {
    private static final Logger log = LogManager.getLogger();
    protected final File file;
    protected RandomAccessFile randomAccessFile;
    protected FileChannel fileChannel;
    protected long fileChannelPosition;
    protected ReadableByteChannel readableByteChannel;
    protected WritableByteChannel writableByteChannel;
    protected MappedByteBuffer headerByteBuffer;
    protected final Map<Parameter<?>, Object> parameterMap = new HashMap();
    protected boolean inited = false;
    protected final ReentrantLock lock = new ReentrantLock();
    protected final Condition allRead = this.lock.newCondition();
    protected List<DataLogReader<?>> readerList = new CopyOnWriteArrayList();
    protected List<DataLogWriter<?>> writerList = new CopyOnWriteArrayList();
    protected volatile boolean reachEOS = false;
    protected int readBufferSize;
    protected int writeBufferSize;

    protected <K> void writeParameter(ByteBuffer byteBuffer, Parameter<K> parameter) {
        K k = this.getParameter(parameter);
        if (k != null) {
            log.debug("Writing TLV " + parameter.name + "(" + parameter.id + ")=[" + k.toString() + "]");
            parameter.write(k, byteBuffer);
        }
    }

    protected <K> K readParameter(ByteBuffer byteBuffer, Parameter<K> parameter, K k, int length) {
        return parameter.read(k, byteBuffer, length);
    }

    public DataLog(File file, RandomAccessFile randomAccessFile, FileChannel fileChannel) {
        this.file = file;
        this.fileChannel = fileChannel;
        this.randomAccessFile = randomAccessFile;
        this.readBufferSize = 8192;
        this.writeBufferSize = 8192;
    }

    public Map<Parameter<?>, Object> getParameterMap() {
        return this.parameterMap;
    }

    public final <K> void setParameter(Parameter<K> key, K value) {
        if (log.isDebugEnabled()) {
            log.debug("Set parameter: key=" + key.name + "; value={" + value + "}");
        }
        this.parameterMap.put(key, value);
    }

    public final <K> K getParameter(Parameter<K> key) {
        return key.clazz.cast(this.parameterMap.get(key));
    }

    public final void asReader() throws IOException {
        if (this.inited) {
            throw new IllegalStateException();
        }
        this.asReaderImpl();
        this.inited = true;
    }

    protected void asReaderImpl() throws IOException {
        this.readHeader();
    }

    protected void readHeader() throws IOException {
    }

    public final void asWriter() throws IOException {
        if (this.inited) {
            throw new IllegalStateException();
        }
        this.asWriterImpl();
        this.inited = true;
    }

    protected void asWriterImpl() throws IOException {
        this.writeHeader();
    }

    protected void writeHeader() throws IOException {
    }

    protected void closeImpl() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.allRead.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        try {
            this.closeImpl();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
        try {
            if (this.fileChannel.isOpen()) {
                this.fileChannel.force(true);
            }
        }
        catch (Throwable t) {
            log.error(this.file + ": " + t.getMessage(), t);
        }
        try {
            this.randomAccessFile.close();
        }
        catch (Throwable t) {
            log.error(this.file + ": " + t.getMessage(), t);
        }
        this.writerList.clear();
        this.readerList.clear();
        this.writerList = null;
        this.readerList = null;
        this.reachEOS = true;
        log.debug("DataLog file [" + this.getFile() + "] was closed");
    }

    public File getFile() {
        return this.file;
    }

    protected void readerReachEOS(DataLogReader<?> reader) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.reachEOS = true;
            this.readerList.remove(reader);
            if (this.readerList.size() == 0) {
                this.allRead.signalAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected void readerClosed(DataLogReader<?> reader) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.readerList.remove(reader);
            if (this.readerList.size() == 0) {
                this.allRead.signalAll();
            }
            new Exception().printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }

    protected <W extends DataLogWriter<?>> W initWriter(W writer) {
        this.writerList.add(writer);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R extends DataLogReader<?>> R initReader(R reader) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.readerList.add(reader);
            R r = reader;
            return r;
        }
        finally {
            lock.unlock();
        }
    }

    public boolean isEnded() {
        return this.reachEOS;
    }

    public void awaitReadersFinish() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            while (this.readerList.size() > 0) {
                this.allRead.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static class Parameter<K>
    implements Comparable<Parameter<?>> {
        public final int id;
        public final Class<K> clazz;
        private final String name;

        public Parameter(int id, String name, Class<K> clazz) {
            this.id = id;
            this.clazz = clazz;
            this.name = name;
        }

        protected void write(K k, ByteBuffer writeBuffer) {
            throw new UnsupportedOperationException();
        }

        protected K read(K k, ByteBuffer readBuffer, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int compareTo(Parameter<?> o) {
            return this.id - o.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class ParameterUByte
    extends Parameter<Short> {
        public ParameterUByte(int id, String name) {
            super(id, name, Short.class);
        }

        @Override
        protected void write(Short k, ByteBuffer writeBuffer) {
            writeBuffer.putInt(this.id);
            writeBuffer.putInt(1);
            writeBuffer.put((byte)(k & 0xFF));
        }

        @Override
        protected Short read(Short k, ByteBuffer readBuffer, int length) {
            return (short)(readBuffer.get() & 0xFF);
        }
    }

    public static class ParameterUShort
    extends Parameter<Integer> {
        public ParameterUShort(int id, String name) {
            super(id, name, Integer.class);
        }

        @Override
        protected void write(Integer k, ByteBuffer writeBuffer) {
            writeBuffer.putInt(this.id);
            writeBuffer.putInt(2);
            writeBuffer.putShort((short)(k & 0xFFFF));
        }

        @Override
        protected Integer read(Integer k, ByteBuffer readBuffer, int length) {
            return readBuffer.getShort() & 0xFFFF;
        }
    }

    public static class ParameterUInt
    extends Parameter<Long> {
        public ParameterUInt(int id, String name) {
            super(id, name, Long.class);
        }

        @Override
        protected void write(Long k, ByteBuffer writeBuffer) {
            writeBuffer.putInt(this.id);
            writeBuffer.putInt(4);
            writeBuffer.putInt((int)(k & 0xFFFFFFFFL));
        }

        @Override
        protected Long read(Long k, ByteBuffer readBuffer, int length) {
            return (long)readBuffer.getInt() & 0xFFFFFFFFL;
        }
    }
}

