/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class MenuRestrictPanel
extends BGPanel {
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_HIDDEN = "hidden";
    private int uogId = 0;
    private boolean groups = false;
    private BGUTable table = null;
    private RestrictionTableModel restrictionTableModel = new RestrictionTableModel(RestrictionTableModel.class.getName());

    public MenuRestrictPanel(boolean groups) {
        this.groups = groups;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.table = new BGUTable((TableModel)((Object)this.restrictionTableModel));
        this.table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043a\u0440\u044b\u0442\u0438\u0435\u043c \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u043c\u0435\u043d\u044e"));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && MenuRestrictPanel.this.table.columnAtPoint(mouseEvent.getPoint()) == 0 && MenuRestrictPanel.this.table.getSelectedRow() >= 0) {
                    JSONObject json;
                    json.put(MenuRestrictPanel.KEY_HIDDEN, !(json = ((RowData)MenuRestrictPanel.this.restrictionTableModel.getSelectedRow()).getJson()).optBoolean(MenuRestrictPanel.KEY_HIDDEN, false));
                    int row = MenuRestrictPanel.this.table.getSelectedRow();
                    MenuRestrictPanel.this.restrictionTableModel.fireTableDataChanged();
                    MenuRestrictPanel.this.table.setRowSelectionInterval(row, row);
                }
            }
        });
    }

    public void setData() {
        ArrayList data = new ArrayList();
        try {
            JSONObject json = new JSONObject(this.groups ? ((UserService)this.getContext().getPort(UserService.class)).groupMenuRestriction(this.uogId) : ((UserService)this.getContext().getPort(UserService.class)).userMenuRestriction(this.uogId));
            json.optJSONArray("menu").forEach(a -> data.add(new RowData((JSONObject)a)));
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        this.restrictionTableModel.setData(data);
    }

    public void setUserOrGroupId(int uogId) {
        this.uogId = uogId;
    }

    public void updateData() {
        ArrayList<String> hiddenIds = new ArrayList<String>();
        for (RowData rowData : this.restrictionTableModel.getRows()) {
            JSONObject json = rowData.getJson();
            if (!json.optBoolean(KEY_HIDDEN, false)) continue;
            hiddenIds.add(json.optString(KEY_ID));
        }
        try {
            if (this.groups) {
                ((UserService)this.getContext().getPort(UserService.class)).groupMenuRestrictionSet(this.uogId, hiddenIds);
            } else {
                ((UserService)this.getContext().getPort(UserService.class)).userMenuRestrictionSet(this.uogId, hiddenIds);
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    class RestrictionTableModel
    extends BGTableModel<RowData> {
        public RestrictionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0421\u043a\u0440\u044b\u0442\u044b\u0439", Boolean.class, 100, 100, 100, MenuRestrictPanel.KEY_HIDDEN, true);
            this.addColumn("\u041f\u0443\u043d\u043a\u0442 \u043c\u0435\u043d\u044e", -1, -1, -1, MenuRestrictPanel.KEY_TITLE, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("ID", 200, 300, 400, MenuRestrictPanel.KEY_ID, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            switch (identifier) {
                case "hidden": {
                    return json.optBoolean(MenuRestrictPanel.KEY_HIDDEN);
                }
                case "title": {
                    return json.optString(MenuRestrictPanel.KEY_TITLE);
                }
                case "id": {
                    return json.optString(MenuRestrictPanel.KEY_ID);
                }
            }
            throw new IllegalArgumentException("Unexpected value: " + identifier);
        }
    }
}

