/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.ws.Service;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.ParameterMap;

public final class WSClient
extends ru.bitel.bgbilling.kernel.container.ws.common.WSClient {
    private static final Logger logger = LogManager.getLogger();
    private final String username;
    private final String password;

    public WSClient(ParameterMap params) {
        this(params, true);
    }

    public WSClient(ParameterMap params, boolean staticCache) {
        super(staticCache);
        this.username = params.get("system.username", "");
        this.password = params.get("system.password", "");
    }

    @Override
    public <T> T getPort(String url, Class<T> iface, int mid) {
        return this.getPort(url, iface, null, mid);
    }

    @Override
    public HandlerResolver newHandlerResolver(final Service webService) {
        return new HandlerResolver(){

            public List<Handler> getHandlerChain(PortInfo portInfo) {
                ArrayList<Handler> result = new ArrayList<Handler>();
                result.add((Handler)new ServiceAuthenticationSOAPHandler(webService));
                return result;
            }
        };
    }

    class ServiceAuthenticationSOAPHandler
    implements SOAPHandler<SOAPMessageContext> {
        private final Service service;

        ServiceAuthenticationSOAPHandler(Service service) {
            this.service = service;
        }

        public Set<QName> getHeaders() {
            return null;
        }

        public void close(MessageContext context) {
        }

        public boolean handleFault(SOAPMessageContext context) {
            return true;
        }

        public boolean handleMessage(SOAPMessageContext context) {
            try {
                boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
                if (outbound) {
                    QName operation = (QName)context.get((Object)"javax.xml.ws.wsdl.operation");
                    logger.info(this.service.getWSDLDocumentLocation() + " -> " + context.get((Object)"javax.xml.ws.wsdl.service") + (String)(operation != null ? ":" + operation.getLocalPart() : ""));
                    SOAPEnvelope se = context.getMessage().getSOAPPart().getEnvelope();
                    SOAPHeader sh = se.getHeader();
                    if (sh == null) {
                        sh = se.addHeader();
                    }
                    SOAPFactory soapFactory = SOAPFactory.newInstance();
                    SOAPElement auth = soapFactory.createElement("auth", "", "http://ws.base.kernel.bgbilling.bitel.ru/");
                    auth.setAttribute("user", WSClient.this.username);
                    auth.setAttribute("pswd", WSClient.this.password);
                    sh.addChildElement(auth);
                }
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
            return true;
        }
    }
}

