/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import bitel.billing.server.util.Config;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitParameters;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ContractLimitManager {
    public static final int VPAY_NOT_PAYOFFED = 0;
    public static final int VPAY_PARTIAL_PAYOFFED = 1;
    public static final int VPAY_PAYOFFED = 2;
    public static final int VPAY_EXPIRED = 3;
    private static final int MODE_ENABLED = 0;
    private static final int MODE_DISABLED = 1;
    private static final int MODE_DISABLED_FOR_EXPIRED = 2;
    private Connection con;

    public ContractLimitManager(Connection con) {
        this.con = con;
    }

    private static final List<ContractLimitParameters> load(Setup setup) {
        ArrayList<ContractLimitParameters> result = new ArrayList<ContractLimitParameters>();
        String _groups = setup.get("contract.limit.1.groups", null);
        int i = 1;
        Object prefix = "contract.limit.1";
        while (_groups != null) {
            List grs = Utils.toIntegerList((String)_groups);
            long groups = 0L;
            for (Integer g : grs) {
                groups |= 1L << g;
            }
            int maxNotPayoffed = setup.getInt((String)prefix + ".maxnotpayoffed", 0);
            int maxPartialPayoffed = setup.getInt((String)prefix + ".maxpartialpayoffed", 0);
            int maxExpiredForBlock = setup.getInt((String)prefix + ".maxexpiredforblock", 0);
            int minDays = setup.getInt((String)prefix + ".mindays", 1);
            int maxDays = setup.getInt((String)prefix + ".maxdays", 10);
            int delayDays = setup.getInt((String)prefix + ".delaydays", 10);
            BigDecimal minSumm = setup.getBigDecimal((String)prefix + ".minsumm", new BigDecimal(10));
            BigDecimal maxSumm = setup.getBigDecimal((String)prefix + ".maxsumm", new BigDecimal(100));
            BigDecimal minLimit = setup.getBigDecimal((String)prefix + ".minlimit", new BigDecimal(-100));
            result.add(new ContractLimitParameters(groups, maxNotPayoffed, maxPartialPayoffed, maxExpiredForBlock, minDays, maxDays, delayDays, minSumm, maxSumm, minLimit));
            prefix = "contract.limit." + ++i;
            _groups = setup.get((String)prefix + ".groups", null);
        }
        return result;
    }

    public ContractLimitParameters getContractLimitParameters(Setup setup, Contract contract) throws BGException {
        List<ContractLimitParameters> contractLimitParameters = setup.getConfig((int)0, Conf.class).contractLimitParameters;
        if (contractLimitParameters == null) {
            contractLimitParameters = ContractLimitManager.load(setup);
        }
        long groups = contract.getGroups();
        try {
            for (ContractLimitParameters l : contractLimitParameters) {
                if ((l.getGroups() & groups) <= 0L) continue;
                PreparedStatement ps = this.con.prepareStatement("SELECT mode, cnt FROM contract_limit_manage_mode WHERE cid=?");
                ps.setInt(1, contract.getId());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    switch (rs.getInt(1)) {
                        case 1: {
                            throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435", "contractLimitManage.disabled");
                        }
                        case 2: {
                            throw new BGMessageException(setup.get("limit.max.nopayed.msg", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"), "contractLimitManage.disabledForExpired");
                        }
                    }
                    if (l.getMaxExpiredForBlock() > 0 && l.getMaxExpiredForBlock() <= rs.getInt(2)) {
                        this.setLimitManageMode(0, contract.getId(), 2);
                        throw new BGMessageException(setup.get("limit.max.nopayed.msg", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0441\u0440\u043e\u0447\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430"), "contractLimitManage.disabledForExpired");
                    }
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement("SELECT COUNT(id) FROM contract_limit_manage WHERE cid=? AND status=?");
                ps.setInt(1, contract.getId());
                ps.setInt(2, 0);
                rs = ps.executeQuery();
                int notPayoffed = rs.next() ? rs.getInt(1) : 0;
                rs.close();
                ps.setInt(2, 1);
                rs = ps.executeQuery();
                int partialPayoffed = rs.next() ? rs.getInt(1) : 0;
                rs.close();
                ps.close();
                if (l.getMaxNotPayoffed() < notPayoffed || l.getMaxPartialPayoffed() < partialPayoffed) {
                    throw new BGMessageException(setup.get("limit.max.current.msg", "\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043e\u043d\u0438\u0437\u0438\u0442\u044c \u043b\u0438\u043c\u0438\u0442. \u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043d\u0435 \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0445 \u0438/\u0438\u043b\u0438 \u0447\u0430\u0441\u0442\u0438\u0447\u043d\u043e \u043f\u043e\u0433\u0430\u0448\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u0439"), "contractLimitManage.limited");
                }
                return l;
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        throw new BGMessageException("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u043d\u0438\u0436\u0435\u043d\u0438\u044f \u043b\u0438\u043c\u0438\u0442\u0430 \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d\u0430 [\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f contract.groups=" + groups + "]", "contractLimitManage.disabled");
    }

    public void setLimitManageMode(int userId, int contractId, int mode) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE contract_limit_manage_mode SET mode=?, cnt=? WHERE cid=?");
            ps.setInt(1, mode);
            ps.setInt(2, 0);
            ps.setInt(3, contractId);
            int row = ps.executeUpdate();
            ps.close();
            if (row <= 0) {
                ps = this.con.prepareStatement("INSERT INTO contract_limit_manage_mode ( cid, mode ) VALUES ( ?, ? )");
                ps.setInt(1, contractId);
                ps.setInt(2, mode);
                ps.executeUpdate();
                ps.close();
            }
            ps = this.con.prepareStatement("INSERT INTO log_contract_limit_manage_mode VALUES ( now(), ?, ?, ? )");
            ps.setInt(1, userId);
            ps.setInt(2, mode);
            ps.setInt(3, contractId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private static class Conf
    extends Config {
        final List<ContractLimitParameters> contractLimitParameters;

        public Conf(int mid, ParameterMap moduleSetup, Setup serverSetup) {
            super(mid, moduleSetup, serverSetup);
            this.contractLimitParameters = ContractLimitManager.load(serverSetup);
        }
    }
}

