/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractPatternManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.jws.WebService;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractParameterGroupName;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.Customer;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerLink;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterGroupAttr;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractParameterGroupAttrModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractParameterGroupModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractParameterGroupNameDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.customer.CustomerDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter.ContractParameterGroupAttrDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.PeriodWithTime;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService")
public class ContractParameterServiceImpl
extends AbstractService
implements ContractParameterService {
    @Override
    public ContractParameterGroup contractParameterGroupGet(int id) throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).get(id);
    }

    @Override
    public List<ContractParameterGroup> contractParameterGroupList() throws BGException {
        return this.context.getDirectory(ContractParameterGroup.class, 0).list();
    }

    @Override
    public String contractParameterGroupJson() throws BGException {
        JSONArray array = new JSONArray();
        Connection con = this.getConnection();
        try (ContractManager contractManager = new ContractManager(con);
             ContractParameterGroupNameDao contractParameterGroupNameDao = new ContractParameterGroupNameDao(con);
             Statement statement = con.createStatement();
             ResultSet rs = statement.executeQuery("SELECT * FROM contract_parameter_group");){
            Map<Integer, Integer> groupContractMap = contractManager.getContractParameterGroupCountMap();
            Map<Integer, Integer> patternMap = new ContractPatternManager(con).getPatternParameterGroupCountMap();
            HashMap<Integer, List> groupParameterIds = new HashMap<Integer, List>();
            while (rs.next()) {
                int groupId = rs.getInt("gid");
                List list = groupParameterIds.getOrDefault(groupId, new ArrayList());
                list.add(rs.getInt("pid"));
                groupParameterIds.put(groupId, list);
            }
            contractParameterGroupNameDao.reset();
            for (ContractParameterGroupName groupName : contractParameterGroupNameDao.list()) {
                JSONObject json = new JSONObject();
                json.put("id", groupName.getId());
                json.put("title", (Object)groupName.getTitle());
                json.put("patterns", (Object)patternMap.getOrDefault(groupName.getId(), 0));
                json.put("contracts", (Object)groupContractMap.getOrDefault(groupName.getId(), 0));
                json.put("parameterIds", (Object)(groupParameterIds.containsKey(groupName.getId()) ? Utils.toString((Iterable)((Iterable)groupParameterIds.get(groupName.getId()))) : ""));
                array.put((Object)json);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return array.toString();
    }

    @Override
    public int contractParameterGroupUpdate(ContractParameterGroup group) throws BGException {
        this.context.getDirectory(ContractParameterGroup.class, 0).update(group);
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        return group.getId();
    }

    @Override
    public void contractParameterGroupDelete(int id) throws BGException {
        this.context.getDirectory(ContractParameterGroup.class, 0).delete(id);
    }

    @Override
    public List<ContractParameterListItem> contractParameterListItemList(int parameterTypeId) throws BGException {
        return this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).list();
    }

    @Override
    public int contractParameterListItemUpdate(int parameterTypeId, ContractParameterListItem item) throws BGException {
        this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).update(item);
        this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        return item.getId();
    }

    @Override
    public void contractParameterListItemDelete(int parameterTypeId, int id) throws BGException {
        this.context.getDirectory(ContractParameterListItem.class, parameterTypeId).delete(id);
        this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
    }

    @Override
    public ContractParameterGroupAttr contractParameterGroupAttrGet(int id) throws BGException {
        return this.context.getDirectory(ContractParameterGroupAttr.class, 0).get(id);
    }

    @Override
    public List<ContractParameterGroupAttr> contractParameterGroupAttrList() throws BGException {
        return this.context.getDirectory(ContractParameterGroupAttr.class, 0).list();
    }

    @Override
    public int contractParameterGroupAttrUpdate(ContractParameterGroupAttr attr) throws BGException {
        this.context.getDirectory(ContractParameterGroupAttr.class, 0).update(attr);
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
        return attr.getId();
    }

    @Override
    public void contractParameterGroupAttrDelete(int id) throws BGException {
        this.context.getDirectory(ContractParameterGroupAttr.class, 0).delete(id);
    }

    @Override
    public void contractParameterGroupUpdateLink(int contractParameterGroupId, Set<Integer> parameterIds) throws BGException {
        try (ContractParameterGroupAttrDao dao = new ContractParameterGroupAttrDao(this.getConnection());){
            dao.updateLink(contractParameterGroupId, parameterIds);
        }
        this.context.publishAfterCommit(new ContractParameterGroupModifiedEvent(this.userId, null, null));
    }

    @Override
    public void contractParameterGroupAttrOrderSet(List<ContractParameterGroupAttr> list) throws BGException {
        try (ContractParameterGroupAttrDao contractParameterGroupAttrDao = new ContractParameterGroupAttrDao(this.getConnection());){
            contractParameterGroupAttrDao.updateOrderPosition(list);
            this.context.publishAfterCommit(new ContractParameterGroupAttrModifiedEvent(this.userId, null, null));
        }
    }

    @Override
    public String customerParameterGet(int contractId) throws BGException {
        JSONObject customer = new JSONObject();
        try (ContractDao contractDao = new ContractDao(this.getConnection(), contractId);){
            Contract contract = (Contract)contractDao.get(contractId);
            if (contract != null) {
                customer.put("personType", (Object)(contract.getPersonType() == 0 ? "f" : "u"));
                customer.put("domainId", contract.getDomainId());
                CustomerDao customerDao = new CustomerDao(this.getConnection());
                Optional<CustomerLink> customerLink = customerDao.getCustomerLink(contractId, LocalDateTime.now());
                if (customerLink.isPresent()) {
                    int customerId = customerLink.get().getCustomerId();
                    customer.put("customerId", customerId);
                    customer.put("customer", (Object)customerDao.getCustomerDataJson(customerId).optJSONObject("customer"));
                }
            }
        }
        return customer.toString();
    }

    @Override
    public String customerParameterUpdate(int customerId, String fieldValue, String text) throws BGException {
        Connection con = this.getConnection();
        CustomerDao customerDao = new CustomerDao(con);
        String value = customerDao.updateCustomerFieldValue(customerId, fieldValue, text, this.userId);
        JSONArray contracts = customerDao.getCustomerContracts(customerId, LocalDateTime.now());
        if (!contracts.isEmpty()) {
            CommentPatternManager commentPatternManager = new CommentPatternManager(con);
            for (int index = 0; index < contracts.length(); ++index) {
                JSONObject contract = contracts.optJSONObject(index);
                try {
                    commentPatternManager.updateContractComment(contract.getInt("id"));
                    continue;
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            }
        }
        return value;
    }

    @Override
    public int customerNewSet(int contractId) throws BGException {
        CustomerDao customerDao = new CustomerDao(this.getConnection());
        Optional<CustomerLink> customerLink = customerDao.getCustomerLink(contractId, LocalDateTime.now());
        if (customerLink.isPresent()) {
            return customerLink.get().getCustomerId();
        }
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            Contract contract = (Contract)contractDao.get(contractId);
            if (contract != null) {
                CustomerLink newCustomerLink = new CustomerLink();
                newCustomerLink.setContractId(contractId);
                newCustomerLink.setCustomerId(customerDao.getNewCustomerId(contract.getPersonType() == 0 ? Customer.CustomerType.FIZ_CUSTOMER : Customer.CustomerType.JUR_CUSTOMER));
                newCustomerLink.setPeriod(new PeriodWithTime(LocalDateTime.now(), null));
                customerDao.addCustomerLink(newCustomerLink);
                int n = newCustomerLink.getCustomerId();
                return n;
            }
        }
        return 0;
    }

    @Override
    public String customerSearch(Customer.CustomerType customerType, String text) throws BGException {
        if (text == null || text.isBlank()) {
            return "[]";
        }
        JSONArray array = new JSONArray();
        CustomerDao customerDao = new CustomerDao(this.getConnection());
        text = text.trim();
        if (customerType == Customer.CustomerType.JUR_CUSTOMER && text.matches("^([0-9]{10}|[0-9]{10})$")) {
            array = customerDao.searchByKey(Customer.CustomerType.JUR_CUSTOMER, Customer.CustomerJur.INN.key(), text);
        }
        if (customerType == Customer.CustomerType.FIZ_CUSTOMER && text.matches("^[0-9]{12}$")) {
            array = customerDao.searchByKey(Customer.CustomerType.FIZ_CUSTOMER, Customer.CustomerFiz.INN.key(), text);
        }
        if (customerType == Customer.CustomerType.FIZ_CUSTOMER && text.matches("^([0-9]{6}|[0-9]{4}\\s*[0-9]{6})$")) {
            String number;
            String string = number = text.length() == 6 ? text : "";
            if (Utils.isBlankString((String)number) && text.length() >= 10) {
                number = text.substring(text.length() - 6);
            }
        }
        return array.toString();
    }

    @Override
    public void customerLinkSet(int contractId, int \u0441ustomerId) throws BGException {
        new CustomerDao(this.getConnection()).setCustomerLink(contractId, \u0441ustomerId, LocalDateTime.now());
    }

    @Override
    public String customerContracts(int customerId, LocalDateTime onTime) throws BGException {
        return new CustomerDao(this.getConnection()).getCustomerContracts(customerId, onTime).toString();
    }

    @Override
    public boolean customerUnlinkContract(int contractId, LocalDateTime unlinkTime) throws BGException {
        return new CustomerDao(this.getConnection()).setCustomerUnlinkContract(contractId, unlinkTime);
    }

    @Override
    public String customerParameterHistory(int customerId, String fieldKey, int lastRecordCount) throws BGException {
        return new CustomerDao(this.getConnection()).getCustomerParameterHistory(customerId, fieldKey, lastRecordCount);
    }

    @Override
    public List<String> customerEmails(int customerId, int contractId) throws BGException, BGMessageException {
        JSONObject jsonObject;
        JSONObject contact;
        ArrayList<String> list = new ArrayList<String>();
        CustomerDao customerDao = new CustomerDao(this.getConnection());
        if (customerId < 1) {
            Optional<CustomerLink> optional = customerDao.getCustomerLink(contractId, LocalDateTime.now());
            if (optional.isPresent()) {
                customerId = optional.get().getCustomerId();
            } else {
                return list;
            }
        }
        if ((contact = (JSONObject)(jsonObject = customerDao.getCustomerDataJson(customerId)).query("/customer/contact")) != null) {
            for (String key : contact.keySet()) {
                if (!key.startsWith("email_")) continue;
                list.add(contact.getString(key));
            }
        }
        return list;
    }
}

