/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentTypeItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ChargeEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService")
public class ChargeServiceImpl
extends AbstractService
implements ChargeService {
    private ChargeTypeDao chargeTypeDao;
    private ChargeDao chargeDao;

    private ChargeTypeDao getChargeTypeDao() {
        if (this.chargeTypeDao == null) {
            this.chargeTypeDao = new ChargeTypeDao(this.getConnection());
        }
        return this.chargeTypeDao;
    }

    private ChargeDao getChargeDao() {
        if (this.chargeDao == null) {
            this.chargeDao = new ChargeDao(this.getConnection());
        }
        return this.chargeDao;
    }

    @Override
    public Charge chargeGet(int chargeId) throws BGException {
        return (Charge)this.getChargeDao().get(chargeId);
    }

    @Override
    public List<Charge> chargeList(int contractId, int type, Period period, int members, Holder<BigDecimal> holderTotalSum) throws BGException {
        if (holderTotalSum != null) {
            holderTotalSum.value = BigDecimal.ZERO;
        }
        return this.getChargeDao().getChargeList(contractId, type, period, members, holderTotalSum);
    }

    @Override
    public List<Charge> paybackList(int contractId, int paybackTypeId, Period period, int members, Holder<BigDecimal> holderTotalSum) throws BGException {
        if (holderTotalSum != null) {
            holderTotalSum.value = BigDecimal.ZERO;
        }
        return this.getChargeDao().getPaybackList(contractId, paybackTypeId, period, members, holderTotalSum);
    }

    @Override
    public int chargeDelete(int contractId, int chargeId) throws BGException {
        return this.chargeDelete(chargeId);
    }

    @Override
    public int chargeDelete(int chargeId) throws BGException {
        int result = 0;
        try (BalanceUtils bu = new BalanceUtils(this.getConnection());){
            ChargeDao chargeDao = this.getChargeDao();
            Charge charge = (Charge)chargeDao.get(chargeId);
            if (charge != null) {
                Calendar closedDate = null;
                closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionDeleteContractCharge", this.moduleId, this.userId);
                if (closedDate != null) {
                    ClosedDateChecker.checkDatesForDelete(closedDate, charge.getDate());
                }
                result = chargeDao.delete(chargeId);
                this.getConnection().commit();
                bu.updateBalance(charge.getDate(), charge.getContractId());
                this.context.publishAfterCommit(new ContractBalanceChangedEvent(charge.getContractId(), 4, charge.getSum().negate()));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int chargeUpdate(Charge charge) throws BGException, BGMessageException {
        int result = 0;
        try (BalanceUtils bu = new BalanceUtils(this.getConnection());){
            boolean allowClosedCharge;
            if (charge.getId() < -1 || charge.getDate() == null || charge.getContractId() <= 0 || charge.getTypeId() <= 0) {
                throw new BGIllegalArgumentException();
            }
            if (this.getSetup().getInt("allow.future.charge", 0) == 0 && TimeUtils.dateBefore((Date)new Date(), (Date)charge.getDate())) {
                throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b \u0440\u0430\u0441\u0445\u043e\u0434\u044b/\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u044b \u0441 \u0434\u0430\u0442\u043e\u0439 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439");
            }
            ChargeDao chargeDao = this.getChargeDao();
            Date oldDate = null;
            Charge oldCharge = null;
            if (charge.getId() > 0 && (oldCharge = (Charge)chargeDao.get(charge.getId())) != null) {
                if (charge.getContractId() != oldCharge.getContractId()) {
                    throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u043e");
                }
                oldDate = oldCharge.getDate();
            }
            ContractManager contractManager = null;
            Contract contract = null;
            try {
                contractManager = new ContractManager(this.getConnection());
                contract = contractManager.getContractById(charge.getContractId());
            }
            finally {
                contractManager.recycle();
            }
            if (contract == null) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            boolean bl = allowClosedCharge = this.getSetup().getInt("allow.closed.charge", 0) == 1;
            if (!allowClosedCharge && !TimeUtils.dateInRange((Date)charge.getDate(), (Date)contract.getDateFrom(), (Date)contract.getDateTo())) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043c\u043e\u043c\u0435\u043d\u0442");
            }
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionUpdateContractCharge", this.moduleId, this.userId);
            if (closedDate != null) {
                ClosedDateChecker.checkDatesForUpdate(closedDate, oldDate, charge.getDate());
            }
            boolean editMode = charge.getId() >= 0;
            charge.setUserId(this.userId);
            chargeDao.update(charge);
            result = charge.getId();
            this.getConnection().commit();
            bu.updateBalance(charge.getDate(), contract);
            if (oldDate != null && TimeUtils.monthsDelta((Date)oldDate, (Date)charge.getDate()) != 0) {
                bu.updateBalance(oldDate, contract);
            }
            BigDecimal balanceChange = charge.getSum();
            if (oldCharge != null) {
                balanceChange = balanceChange.subtract(oldCharge.getSum());
            }
            this.context.publishAfterCommit(new ChargeEvent(this.userId, charge, editMode));
            this.context.publishAfterCommit(new ContractBalanceChangedEvent(contract.getId(), 4, balanceChange));
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    @Override
    public ChargeType chargeTypeGet(int chargeTypeId) throws BGException {
        return this.context.getDirectory(ChargeType.class, 0).get(chargeTypeId);
    }

    @Override
    public List<ChargeType> chargeTypeList(Integer editable, Integer type, Boolean isPayback) throws BGException {
        return this.getChargeTypeDao().list(editable, type, isPayback);
    }

    @Override
    public PaymentTypeItem chargeTypeTree(int editable, boolean isPayback, boolean showEmptyRoot) throws BGException {
        return this.getChargeTypeDao().getTree(editable, isPayback, showEmptyRoot);
    }

    @Override
    public void chargeTypeMove(int chargeTypeId, List<Integer> idList) throws BGException {
        this.getChargeTypeDao().move(chargeTypeId, idList);
    }

    @Override
    public int chargeTypeUpdate(ChargeType chargeType) throws BGException, BGMessageException {
        this.context.getDirectory(ChargeType.class, 0).update(chargeType);
        return chargeType.getId();
    }

    @Override
    public int chargeTypeDelete(int chargeTypeId) throws BGException, BGMessageException {
        return this.context.getDirectory(ChargeType.class, 0).delete(chargeTypeId);
    }
}

