/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.util;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class BalanceUtils
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    private Connection con = null;
    private ContractDao contractDao;
    private ReserveDao reserveDao;
    private static final Object setAccountMutex = new Object();

    public BalanceUtils(Connection con) {
        this.con = con;
    }

    private ContractDao getContractDao() {
        if (this.contractDao == null) {
            this.contractDao = new ContractDao(this.con, 0);
        }
        return this.contractDao;
    }

    private ReserveDao getReserveDao() {
        if (this.reserveDao == null) {
            this.reserveDao = new ReserveDao(this.con);
        }
        return this.reserveDao;
    }

    public BigDecimal getSaldo(java.util.Date time, int contractId) {
        try {
            return this.getBalance(TimeUtils.convertDateToLocalDate((java.util.Date)time), contractId, "summa1 + summa2", "summa1 + summa2 - summa3 - summa4", false);
        }
        catch (BGException e) {
            e.printStackTrace();
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal getBalance(java.util.Date time, int contractId) {
        return this.getBalance(TimeUtils.convertDateToLocalDate((java.util.Date)time), contractId);
    }

    public BigDecimal getBalance(LocalDate localDate, int contractId) {
        try {
            return this.getBalance(localDate, contractId, "summa1 + summa2 - summa3 - summa4", "summa1 + summa2 - summa3 - summa4", true);
        }
        catch (BGException e) {
            e.printStackTrace();
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal getBalanceOut(java.util.Date time, int contractId) {
        try {
            return this.getBalance(TimeUtils.convertDateToLocalDate((java.util.Date)time), (ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract)this.getContractDao().get(contractId), "summa1 + summa2 - summa3 - summa4", "summa1 + summa2 - summa3 - summa4", true);
        }
        catch (BGException e) {
            e.printStackTrace();
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal getBalance(java.util.Date time, ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract) {
        return this.getBalance(TimeUtils.convertDateToLocalDate((java.util.Date)time), contract, "summa1 + summa2 - summa3 - summa4", "summa1 + summa2 - summa3 - summa4", true);
    }

    public BigDecimal getBalanceSumma1(java.util.Date time, int contractId) {
        try {
            return this.getBalance(TimeUtils.convertDateToLocalDate((java.util.Date)time), contractId, "summa1", "summa1 + summa2 - summa3 - summa4", false);
        }
        catch (BGException e) {
            e.printStackTrace();
            return BigDecimal.ZERO;
        }
    }

    private BigDecimal getBalance(LocalDate localDate, int contractId, String selectEquation, String selectFromPrevMonth, boolean withReserve) throws BGException {
        ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract = (ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract)this.getContractDao().get(contractId);
        if (contract == null) {
            return BigDecimal.ZERO;
        }
        return this.getBalance(localDate, contract, selectEquation, selectFromPrevMonth, withReserve);
    }

    private BigDecimal getBalance(LocalDate localDate, ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract, String selectEquation, String selectFromPrevMonth, boolean withReserve) {
        BigDecimal summa = BigDecimal.ZERO;
        int cid = contract.isDependSub() ? contract.getSuperCid() : contract.getId();
        try {
            String query = "SELECT " + selectEquation + " FROM contract_balance WHERE cid=? AND yy=? AND mm=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, localDate.getYear());
            ps.setInt(3, localDate.getMonthValue());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                summa = rs.getBigDecimal(1);
            } else {
                ps.close();
                query = "SELECT " + selectFromPrevMonth + " FROM contract_balance  WHERE cid=? AND ((yy*12) + mm)<=((?*12) + ?) ORDER BY yy DESC, mm DESC LIMIT 1";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, cid);
                ps.setInt(2, localDate.getYear());
                ps.setInt(3, localDate.getMonthValue());
                rs = ps.executeQuery();
                if (rs.next()) {
                    summa = rs.getBigDecimal(1);
                }
            }
            rs.close();
            ps.close();
            if (withReserve) {
                return this.getReserveDao().getBalanceWithReserve(contract, summa, localDate);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return summa;
    }

    @Deprecated
    public void setContractAccount(int contractId, java.util.Date time, int serviceId, float summa) {
        this.setContractAccount(contractId, time, serviceId, BigDecimal.valueOf(summa).setScale(2, RoundingMode.HALF_UP));
    }

    public void setContractAccount(int contractId, java.util.Date time, int serviceId, BigDecimal summa) {
        try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO contract_account VALUES ( ?, ?, ?, ?, ? ) ON DUPLICATE KEY UPDATE summa=?");){
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(time);
            ps.setInt(1, cal.get(1));
            ps.setInt(2, cal.get(2) + 1);
            ps.setInt(3, contractId);
            ps.setInt(4, serviceId);
            ps.setBigDecimal(5, summa);
            ps.setBigDecimal(6, summa);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    public void addContractAccount(int cid, Calendar time, int sid, float add) {
        this.addContractAccount(cid, time.getTime(), sid, add);
    }

    @Deprecated
    public void addContractAccount(int contractId, java.util.Date time, int serviceId, float add) {
        this.addContractAccount(contractId, time, serviceId, BigDecimal.valueOf(add).setScale(2, RoundingMode.HALF_UP));
    }

    public void addContractAccount(int contractId, java.util.Date time, int serviceId, BigDecimal addSum) {
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE contract_account SET summa=summa+? WHERE cid=? AND sid=? AND yy=? AND mm=?");){
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(time);
            ps.setBigDecimal(1, addSum);
            ps.setInt(2, contractId);
            ps.setInt(3, serviceId);
            ps.setInt(4, cal.get(1));
            ps.setInt(5, cal.get(2) + 1);
            if (ps.executeUpdate() == 0) {
                this.setContractAccount(contractId, time, serviceId, addSum);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addBalanceAccount(Contract contract, Calendar time, float summa) {
        try {
            String query = "UPDATE contract_balance SET summa3=summa3+? WHERE yy=? AND mm=? AND ";
            PreparedStatement psUpdate = null;
            int mustUpdateCount = 1;
            if (contract.isSub()) {
                psUpdate = this.con.prepareStatement(query + "cid IN (?, ?)");
                psUpdate.setInt(4, contract.getSuperId());
                psUpdate.setInt(5, contract.getId());
                mustUpdateCount = 2;
            } else {
                psUpdate = this.con.prepareStatement(query + "cid=?");
                psUpdate.setInt(4, contract.getId());
                mustUpdateCount = 1;
            }
            psUpdate.setFloat(1, summa);
            psUpdate.setInt(2, time.get(1));
            psUpdate.setInt(3, time.get(2) + 1);
            int updateCount = psUpdate.executeUpdate();
            if (updateCount != mustUpdateCount) {
                this.setBalanceFromAccount(contract, time);
            }
            psUpdate.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void transitBalanceToCurdate1(int cid, Calendar time) {
        GregorianCalendar now = new GregorianCalendar();
        now.set(5, 1);
        time = (Calendar)time.clone();
        time.set(5, 1);
        while (TimeUtils.dateBefore((Calendar)time, (Calendar)now)) {
            this.transitBalance(cid, time);
            time.add(2, 1);
        }
    }

    private void transitBalanceToLastExist(int contractId, Calendar time) {
        ArrayList<GregorianCalendar> list = new ArrayList<GregorianCalendar>();
        try {
            int index = 1;
            Object var5_7 = null;
            ResultSet rs = null;
            PreparedStatement ps = null;
            String string = "SELECT yy, mm FROM contract_balance WHERE cid=? AND ( (yy=? AND mm>?) OR yy>? ) ORDER BY yy, mm";
            ps = this.con.prepareStatement(string);
            ps.setInt(index++, contractId);
            ps.setInt(index++, time.get(1));
            ps.setInt(index++, time.get(2) + 1);
            ps.setInt(index++, time.get(1));
            rs = ps.executeQuery();
            while (rs.next()) {
                list.add(new GregorianCalendar(rs.getInt(1), rs.getInt(2) - 1, 1));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (Calendar calendar : list) {
            try {
                String query = null;
                ResultSet rs = null;
                PreparedStatement ps = null;
                BigDecimal summa = BigDecimal.ZERO;
                int yy = calendar.get(1);
                int mm = calendar.get(2) + 1;
                int index = 1;
                query = "SELECT summa1 + summa2 - summa3 - summa4 FROM contract_balance WHERE cid=? AND ( yy<? OR ( yy=? AND mm<? ) ) ORDER BY yy DESC, mm DESC LIMIT 1";
                ps = this.con.prepareStatement(query);
                ps.setInt(index++, contractId);
                ps.setInt(index++, yy);
                ps.setInt(index++, yy);
                ps.setInt(index++, mm);
                rs = ps.executeQuery();
                if (rs.next()) {
                    summa = rs.getBigDecimal(1);
                }
                ps.close();
                index = 1;
                query = "UPDATE contract_balance SET summa1=? WHERE cid=? AND yy=? AND mm=?";
                ps = this.con.prepareStatement(query);
                ps.setBigDecimal(index++, summa);
                ps.setInt(index++, contractId);
                ps.setInt(index++, yy);
                ps.setInt(index++, mm);
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void transitBalance(int cid, Calendar t) {
        Calendar time = (Calendar)t.clone();
        BigDecimal summa = BigDecimal.ZERO;
        try {
            String query = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            int yy = time.get(1);
            int mm = time.get(2) + 1;
            query = "SELECT summa1 + summa2 - summa3 - summa4 FROM contract_balance WHERE cid=? AND yy*12 + mm<=? ORDER BY yy*12 + mm DESC LIMIT 1";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, yy * 12 + mm);
            rs = ps.executeQuery();
            if (rs.next()) {
                summa = summa.add(rs.getBigDecimal(1));
            }
            ps.close();
            time.add(2, 1);
            yy = time.get(1);
            mm = time.get(2) + 1;
            query = "UPDATE contract_balance SET summa1=? WHERE cid=? AND yy=? AND mm=?";
            ps = this.con.prepareStatement(query);
            ps.setBigDecimal(1, summa);
            ps.setInt(2, cid);
            ps.setInt(3, yy);
            ps.setInt(4, mm);
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO contract_balance (yy, mm, cid, summa1, summa2, summa3, summa4) VALUES ( ?, ?, ?, ?, 0, 0, 0 )";
                ps = this.con.prepareStatement(query);
                ps.setInt(1, yy);
                ps.setInt(2, mm);
                ps.setInt(3, cid);
                ps.setBigDecimal(4, summa);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean wasMoveByAccount(Calendar time, int cid) {
        boolean result = false;
        try {
            String query = "SELECT * FROM contract_balance WHERE cid=? AND yy=? AND mm=?  AND ( summa2>0 OR summa3>0 OR summa4>0 )";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, time.get(1));
            ps.setInt(3, time.get(2) + 1);
            result = ps.executeQuery().next();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void updateBalance(java.util.Date date, int contractId) throws BGException {
        ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract = (ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract)this.getContractDao().get(contractId);
        if (contract != null) {
            this.updateBalance(date, contract);
        }
    }

    public void updateBalance(java.util.Date date, Contract contract) throws BGException {
        this.updateBalance(date, (ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract)this.getContractDao().get(contract.getId()));
    }

    public void updateBalance(java.util.Date date, ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract) throws BGException {
        int cid = contract.getId();
        Object cids = String.valueOf(cid);
        if (contract.getSuperCid() == -1 && Utils.notBlankString((String)contract.getDependSubList())) {
            cids = (String)cids + "," + contract.getDependSubList();
        }
        Object query = null;
        ResultSet rs = null;
        try {
            BigDecimal summa2 = BigDecimal.ZERO;
            BigDecimal summa4 = BigDecimal.ZERO;
            BigDecimal summa3 = BigDecimal.ZERO;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            cal.set(5, 1);
            Date fromDate = TimeUtils.convertDateToSqlDate((java.util.Date)cal.getTime());
            int yy = cal.get(1);
            int mm = cal.get(2) + 1;
            ((Calendar)cal).add(2, 1);
            Date toDate = TimeUtils.convertDateToSqlDate((java.util.Date)cal.getTime());
            query = "SELECT sum(summa) FROM contract_payment WHERE cid IN ( " + (String)cids + " ) AND dt>=? AND dt<?";
            PreparedStatement psSelectSumma2 = this.con.prepareStatement((String)query);
            psSelectSumma2.setDate(1, fromDate);
            psSelectSumma2.setDate(2, toDate);
            rs = psSelectSumma2.executeQuery();
            if (rs.next()) {
                summa2 = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
            }
            psSelectSumma2.close();
            query = "SELECT sum(summa) FROM contract_charge WHERE cid IN ( " + (String)cids + " ) AND dt>=? AND dt<?";
            PreparedStatement psSelectSumma4 = this.con.prepareStatement((String)query);
            psSelectSumma4.setDate(1, fromDate);
            psSelectSumma4.setDate(2, toDate);
            rs = psSelectSumma4.executeQuery();
            if (rs.next()) {
                summa4 = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
            }
            psSelectSumma4.close();
            query = "SELECT sum( ROUND(summa,2) ) FROM contract_account WHERE cid IN ( " + (String)cids + " ) AND yy=? AND mm=?";
            PreparedStatement psSelectSumma3 = this.con.prepareStatement((String)query);
            psSelectSumma3.setInt(1, yy);
            psSelectSumma3.setInt(2, mm);
            rs = psSelectSumma3.executeQuery();
            if (rs.next()) {
                summa3 = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
            }
            psSelectSumma3.close();
            query = "UPDATE contract_balance SET summa2=?, summa4=?, summa3=? WHERE cid=? AND yy=? AND mm=?";
            PreparedStatement psUpdateBalance = this.con.prepareStatement((String)query);
            psUpdateBalance.setBigDecimal(1, summa2);
            psUpdateBalance.setBigDecimal(2, summa4);
            psUpdateBalance.setBigDecimal(3, summa3);
            psUpdateBalance.setInt(4, cid);
            psUpdateBalance.setInt(5, yy);
            psUpdateBalance.setInt(6, mm);
            if (psUpdateBalance.executeUpdate() == 0) {
                query = "INSERT INTO contract_balance (yy, mm, cid, summa2, summa4, summa3) VALUES ( ?, ?, ?, ?, ?, ?)";
                PreparedStatement psInsertBalance = this.con.prepareStatement((String)query);
                psInsertBalance.setInt(1, yy);
                psInsertBalance.setInt(2, mm);
                psInsertBalance.setInt(3, cid);
                psInsertBalance.setBigDecimal(4, summa2);
                psInsertBalance.setBigDecimal(5, summa4);
                psInsertBalance.setBigDecimal(6, summa3);
                psInsertBalance.executeUpdate();
                Calendar lastMonth = TimeUtils.convertDateToCalendar((java.util.Date)date);
                lastMonth.add(2, -1);
                if (!contract.isDependSub()) {
                    this.transitBalance(cid, lastMonth);
                }
                psInsertBalance.close();
            }
            psUpdateBalance.close();
            if (!contract.isDependSub()) {
                cal = new GregorianCalendar();
                cal.setTime(date);
                this.transitBalanceToLastExist(cid, cal);
            } else {
                this.updateBalance(date, contract.getSuperCid());
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void recalculateBalance(int contractId, java.util.Date dateFrom) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dateFrom);
            int yy = cal.get(1);
            int mm = cal.get(2) + 1;
            String query = "SELECT yy, mm FROM contract_balance WHERE cid=? AND (yy>? OR ( yy=? AND mm >=? )) ORDER BY yy, mm";
            PreparedStatement ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, contractId);
            ps.setInt(index++, yy);
            ps.setInt(index++, yy);
            ps.setInt(index++, mm);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                this.updateBalance(new GregorianCalendar(rs.getInt(1), rs.getInt(2) - 1, 1).getTime(), contractId);
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBalanceFromAccount(int cid, Calendar time) {
        ContractManager contractManager = new ContractManager(this.con);
        Contract contract = contractManager.getContractById(cid);
        contractManager.close();
        if (contract == null) {
            return;
        }
        this.setBalanceFromAccount(contract, time);
    }

    @Deprecated
    public void setBalanceFromAccount(int cid, Calendar time, boolean lowPrior) {
        this.setBalanceFromAccount(cid, time);
    }

    public void setBalanceFromAccount(Contract contract, Calendar time) {
        int cid = contract.getId();
        Object cids = String.valueOf(contract.getId());
        if (contract.getSuperId() == -1 && Utils.notBlankString((String)contract.getDependSubList())) {
            cids = (String)cids + "," + contract.getDependSubList();
        }
        Object query = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            query = "SELECT SUM( ROUND(summa,2) ) FROM contract_account WHERE yy=? AND mm=? AND cid IN (" + (String)cids + ")";
            ps = this.con.prepareStatement((String)query);
            ps.setInt(1, time.get(1));
            ps.setInt(2, time.get(2) + 1);
            rs = ps.executeQuery();
            BigDecimal sum = BigDecimal.ZERO;
            if (rs.next()) {
                sum = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
            }
            ps.close();
            query = "UPDATE contract_balance SET summa3=? WHERE yy=? AND mm=? AND cid=?";
            ps = this.con.prepareStatement((String)query);
            ps.setBigDecimal(1, sum);
            ps.setInt(2, time.get(1));
            ps.setInt(3, time.get(2) + 1);
            ps.setInt(4, cid);
            if (ps.executeUpdate() == 0) {
                query = "INSERT INTO contract_balance (yy, mm, cid, summa3) VALUES ( ?, ?, ?, ?)";
                PreparedStatement psInsertBalance = this.con.prepareStatement((String)query);
                psInsertBalance.setInt(1, time.get(1));
                psInsertBalance.setInt(2, time.get(2) + 1);
                psInsertBalance.setInt(3, cid);
                psInsertBalance.setBigDecimal(4, sum);
                psInsertBalance.executeUpdate();
                Calendar lastMonth = (Calendar)time.clone();
                lastMonth.add(2, -1);
                if (!contract.isDependSub()) {
                    this.transitBalance(cid, lastMonth);
                }
                psInsertBalance.close();
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!contract.isDependSub()) {
            this.transitBalanceToLastExist(cid, time);
        } else {
            this.setBalanceFromAccount(contract.getSuperId(), time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccount(Connection con, Logger logger, Calendar month, ServiceCostCache costCache, String sids, String cids, List<Integer> contractLabelIds) throws SQLException {
        try (PoolEventPublisher<ContractBalanceChangedEvent> balanceEP = EventProcessor.getInstance().newPoolEventPublisher(ContractBalanceChangedEvent.class, 0);){
            Object object = setAccountMutex;
            synchronized (object) {
                Object andCidPart = "";
                if (Utils.notBlankString((String)cids)) {
                    andCidPart = " AND cid IN (" + cids + ")";
                } else if (contractLabelIds != null && !contractLabelIds.isEmpty()) {
                    andCidPart = " AND cid IN (SELECT cll.contract_id FROM contract_label_link AS cll WHERE label_id IN ( " + Utils.toString(contractLabelIds) + " ))";
                }
                int yy = month.get(1);
                int mm = month.get(2) + 1;
                HashSet<Integer> contractForSetBalance = new HashSet<Integer>();
                Object query = "SELECT cid FROM contract_account WHERE sid IN ( " + sids + ") AND yy=? AND mm=?" + (String)andCidPart;
                try (PreparedStatement psSelect = con.prepareStatement((String)query);){
                    psSelect.setInt(1, yy);
                    psSelect.setInt(2, mm);
                    try (ResultSet rsSelect = psSelect.executeQuery();){
                        while (rsSelect.next()) {
                            contractForSetBalance.add(rsSelect.getInt(1));
                        }
                    }
                }
                query = "DELETE FROM contract_account WHERE yy=? AND mm=? AND sid IN (" + sids + ")" + (String)andCidPart;
                try (PreparedStatement psDelete = con.prepareStatement((String)query);){
                    psDelete.setInt(1, yy);
                    psDelete.setInt(2, mm);
                    psDelete.executeUpdate();
                }
                query = "REPLACE INTO contract_account SET yy=?, mm=?, cid=?, sid=?, summa=?";
                try (PreparedStatement psReplace = con.prepareStatement((String)query);){
                    psReplace.setInt(1, yy);
                    psReplace.setInt(2, mm);
                    int cnt = 0;
                    for (CostSum costSum : costCache.getAmounts()) {
                        psReplace.setInt(3, costSum.contractId);
                        psReplace.setInt(4, costSum.serviceId);
                        psReplace.setBigDecimal(5, costSum.cost);
                        psReplace.executeUpdate();
                        contractForSetBalance.add(costSum.contractId);
                        if (logger == null || !logger.isDebugEnabled() || ++cnt % 1000 != 0) continue;
                        logger.debug((Object)cnt);
                    }
                }
                if (logger != null) {
                    logger.debug("Setting balances for independ and subs...");
                }
                String contracts = Utils.toString(contractForSetBalance);
                if (contractForSetBalance.size() > 0) {
                    query = "SELECT contract.id, SUM(ROUND(account.summa,2)), contract.scid, contract.sub_mode FROM contract_account AS account RIGHT JOIN contract ON (account.cid=contract.id AND account.yy=? AND account.mm=?) WHERE contract.scid>=0  AND contract.id IN (" + contracts + ") GROUP BY contract.id ";
                    try (PreparedStatement ps = con.prepareStatement((String)query);){
                        ps.setInt(1, yy);
                        ps.setInt(2, mm);
                        if (logger != null) {
                            logger.info("Selected.");
                        }
                        try (ResultSet rs = ps.executeQuery();){
                            int cnt = 0;
                            while (rs.next()) {
                                int cid = rs.getInt(1);
                                BigDecimal sum = Utils.maskNull((BigDecimal)rs.getBigDecimal(2));
                                int superId = rs.getInt(3);
                                int subMode = rs.getInt(4);
                                boolean transitBalance = superId == 0 || subMode == 1;
                                this.setBalanceFromAccount(cid, month, yy, mm, transitBalance, sum, balanceEP);
                                if (logger == null || !logger.isDebugEnabled() || ++cnt % 1000 != 0) continue;
                                logger.debug((Object)cnt);
                            }
                        }
                    }
                    if (logger != null) {
                        logger.debug("Selecting sub account");
                    }
                    HashMap<Integer, BigDecimal> accountSuper = new HashMap<Integer, BigDecimal>();
                    query = "SELECT contract.scid, SUM(ROUND(account.summa,2))  FROM contract_account AS account RIGHT JOIN contract ON ( account.cid=contract.id AND account.yy=? AND account.mm=? ) WHERE contract.scid>0  AND ( contract.scid IN (" + contracts + ") OR contract.scid IN (SELECT DISTINCT scid FROM contract WHERE scid>0 AND id IN (" + contracts + "))  ) AND contract.sub_mode=? GROUP BY contract.scid ";
                    PreparedStatement ps = con.prepareStatement((String)query);
                    ps.setInt(1, yy);
                    ps.setInt(2, mm);
                    ps.setInt(3, 0);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            accountSuper.put(rs.getInt(1), Utils.maskNull((BigDecimal)rs.getBigDecimal(2)));
                        }
                    }
                    ps.close();
                    HashSet fullSuperSet = new HashSet(contractForSetBalance);
                    fullSuperSet.addAll(accountSuper.keySet());
                    if (logger != null) {
                        logger.debug("Setting balance for super...");
                    }
                    query = "SELECT contract.id, SUM(ROUND(account.summa,2)) FROM contract_account AS account RIGHT JOIN contract ON (account.cid=contract.id AND account.yy=? AND account.mm=?) WHERE contract.scid=-1 AND contract.id IN (" + Utils.toString(fullSuperSet) + ") GROUP BY contract.id ";
                    ps = con.prepareStatement((String)query);
                    ps.setInt(1, yy);
                    ps.setInt(2, mm);
                    try (ResultSet rs = ps.executeQuery();){
                        int cnt = 0;
                        while (rs.next()) {
                            int cid = rs.getInt(1);
                            BigDecimal sum = Utils.maskNull((BigDecimal)rs.getBigDecimal(2));
                            BigDecimal subSum = (BigDecimal)accountSuper.remove(cid);
                            if (subSum != null) {
                                sum = sum.add(subSum);
                            }
                            this.setBalanceFromAccount(cid, month, yy, mm, true, sum, balanceEP);
                            if (logger == null || !logger.isDebugEnabled() || ++cnt % 1000 != 0) continue;
                            logger.debug((Object)cnt);
                        }
                    }
                    ps.close();
                }
            }
        }
    }

    private void setBalanceFromAccount(int contractId, Calendar time, int yy, int mm, boolean transitBalance, BigDecimal summa, PoolEventPublisher<ContractBalanceChangedEvent> balanceEP) throws SQLException {
        String query = "UPDATE contract_balance SET summa3=? WHERE yy=? AND mm=? AND cid=?";
        PreparedStatement psUpdateBalance = this.con.prepareStatement(query);
        psUpdateBalance.setBigDecimal(1, summa);
        psUpdateBalance.setInt(2, yy);
        psUpdateBalance.setInt(3, mm);
        psUpdateBalance.setInt(4, contractId);
        if (psUpdateBalance.executeUpdate() == 0) {
            query = "INSERT INTO contract_balance SET yy=?, mm=?, cid=?, summa3=?";
            PreparedStatement psInsertBalance = this.con.prepareStatement(query);
            psInsertBalance.setInt(1, yy);
            psInsertBalance.setInt(2, mm);
            psInsertBalance.setInt(3, contractId);
            psInsertBalance.setBigDecimal(4, summa);
            psInsertBalance.executeUpdate();
            if (transitBalance) {
                Calendar lastMonth = (Calendar)time.clone();
                lastMonth.add(2, -1);
                this.transitBalance(contractId, lastMonth);
            }
            psInsertBalance.close();
        }
        psUpdateBalance.close();
        if (transitBalance) {
            this.transitBalanceToLastExist(contractId, time);
        }
        try {
            balanceEP.publish(new ContractBalanceChangedEvent(contractId, 2, yy, mm, summa));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public java.util.Date getLastBalanceMonth(ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract contract) {
        java.util.Date result = null;
        int cid = contract.getId();
        if (contract.isDependSub()) {
            cid = contract.getSuperCid();
        }
        try (PreparedStatement ps = this.con.prepareStatement("SELECT yy, mm FROM contract_balance WHERE cid=" + cid + " ORDER BY yy DESC, mm DESC LIMIT 1");){
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new GregorianCalendar(rs.getInt(1), rs.getInt(2) - 1, 1).getTime();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public BigDecimal getAccountSumma(int contractId, Calendar month, String sids) throws BGException {
        BigDecimal bigDecimal;
        block10: {
            BigDecimal result = BigDecimal.ZERO;
            int yy = month.get(1);
            int mm = month.get(2) + 1;
            String cids = ContractUtils.getCidsStringForQuery(contractId, 2, this.con);
            if (cids == null) {
                return result;
            }
            PreparedStatement ps = this.con.prepareStatement("SELECT SUM(ROUND(summa,2)) FROM contract_account WHERE yy=? AND mm=? AND sid IN (" + sids + ") AND cid IN (" + cids + ")");
            try {
                ps.setInt(1, yy);
                ps.setInt(2, mm);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    result = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
                }
                bigDecimal = result;
                if (ps == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException((Throwable)e);
                }
            }
            ps.close();
        }
        return bigDecimal;
    }

    public void updateBalanceFromCharges(int contractId, LocalDate month) throws NullPointerException, SQLException {
        this.updateBalanceFromX(contractId, month, "contract_charge", "summa4", 4);
    }

    public void updateBalanceFromPayments(int contractId, LocalDate month) throws NullPointerException, SQLException {
        this.updateBalanceFromX(contractId, month, "contract_payment", "summa2", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBalanceFromX(int contractId, LocalDate month, String tableName, String columnName, int eventType) throws NullPointerException, SQLException {
        Objects.requireNonNull(month);
        LocalDate fromDate = month.withDayOfMonth(1);
        LocalDate toDate = fromDate.plusMonths(1L);
        BigDecimal sum = BigDecimal.ZERO;
        try (PreparedStatement psSelectSumma2 = this.con.prepareStatement("SELECT sum(summa) FROM " + tableName + " WHERE cid=? AND dt>=? AND dt<?");){
            psSelectSumma2.setDate(1, TimeUtils.convertLocalDateToSqlDate((LocalDate)fromDate));
            psSelectSumma2.setDate(2, TimeUtils.convertLocalDateToSqlDate((LocalDate)toDate));
            ResultSet rs = psSelectSumma2.executeQuery();
            if (rs.next()) {
                sum = Utils.maskNull((BigDecimal)rs.getBigDecimal(1));
            }
            rs.close();
        }
        int rowUpdate = 0;
        try (PreparedStatement psUpdateBalance = this.con.prepareStatement("UPDATE contract_balance SET " + columnName + "=? WHERE yy=? AND mm=? AND cid=?");){
            psUpdateBalance.setBigDecimal(1, sum);
            psUpdateBalance.setInt(2, fromDate.getYear());
            psUpdateBalance.setInt(3, fromDate.getMonthValue());
            psUpdateBalance.setInt(4, contractId);
            rowUpdate = psUpdateBalance.executeUpdate();
        }
        if (rowUpdate == 0) {
            try (PreparedStatement psInsertBalance = this.con.prepareStatement("INSERT INTO contract_balance SET yy=?, mm=?, cid=?, " + columnName + "=?");){
                psInsertBalance.setInt(1, fromDate.getYear());
                psInsertBalance.setInt(2, fromDate.getMonthValue());
                psInsertBalance.setInt(3, contractId);
                psInsertBalance.setBigDecimal(4, sum);
                psInsertBalance.executeUpdate();
                psInsertBalance.close();
                this.transitBalance(contractId, TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)fromDate.minusMonths(1L).atStartOfDay()));
            }
        }
        this.transitBalanceToLastExist(contractId, TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)fromDate.atStartOfDay()));
        try (PoolEventPublisher<ContractBalanceChangedEvent> balanceEP = EventProcessor.getInstance().newPoolEventPublisher(ContractBalanceChangedEvent.class, 0);){
            balanceEP.publish(new ContractBalanceChangedEvent(contractId, eventType, fromDate.getYear(), fromDate.getMonthValue(), sum));
        }
    }

    @Override
    public void close() {
        try {
            if (this.contractDao != null) {
                this.contractDao.recycle();
            }
            if (this.reserveDao != null) {
                this.reserveDao.recycle();
            }
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

