/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.basic.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractBalanceUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebAction(title="\u0411\u0430\u043b\u0430\u043d\u0441")
public class ActionBalance
extends AbstractAction {
    private final String moduleName = "contract";

    @Override
    @WebOperation(title="\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430")
    public void execute() throws BGException {
        this.context.getRequest().setAttribute("pageTitle", (Object)this.getPageTitle(3, "contract"));
    }

    @WebOperation(title="\u0421\u0432\u043e\u0434\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f")
    public void balanceInfo() throws BGException {
        List<String> messages;
        LocalDate now = LocalDate.now();
        List<Integer> contractIds = Arrays.asList(this.contractId);
        ConvergenceBalanceManager convergenceBalanceManager = ConvergenceBalanceManager.getInstance();
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.con, (Integer)this.contractId);
        ConvergenceBalance convergenceBalance = convergenceBalanceManager.getBalance(this.context.getConnectionSet(), this.contractId, System.currentTimeMillis());
        HashMap statusMap = new HashMap();
        Utils.stringToPairs((String)Setup.getSetup().get("contract.status.list", "0:\u0410\u043a\u0442\u0438\u0432\u0435\u043d;1:\u0412 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438;2:\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d;3:\u0417\u0430\u043a\u0440\u044b\u0442;4:\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d;5:\u0412 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438"), (String)";", (String)":").forEach(a -> statusMap.put(Utils.parseInt((String)a[0]), a[1]));
        this.context.getRequest().setAttribute("balanceDatetime", (Object)new Date());
        this.context.getRequest().setAttribute("balanceSum", (Object)convergenceBalance.getBalance());
        this.context.getRequest().setAttribute("contractRuntime", (Object)contractRuntime);
        this.context.getRequest().setAttribute("contractStatusMap", statusMap);
        try (PaymentDao paymentDao = new PaymentDao(this.con);
             PaymentTypeDao paymentTypeDao = new PaymentTypeDao(this.con);){
            SearchResult searchResult = new SearchResult();
            paymentDao.searchLastPaymentList((SearchResult<Payment>)searchResult, contractIds, 3);
            List payments = searchResult.getList();
            ArrayList<Integer> typeIds = new ArrayList<Integer>();
            for (Payment payment : payments) {
                int typeId = payment.getTypeId();
                if (typeIds.contains(typeId)) continue;
                typeIds.add(typeId);
            }
            this.context.getRequest().setAttribute("balancePayments", (Object)payments);
            this.context.getRequest().setAttribute("balancePaymentTypes", paymentTypeDao.getTypeMapByIds(typeIds));
        }
        try (ChargeDao chargeDao = new ChargeDao(this.con);
             ChargeTypeDao chargeTypeDao = new ChargeTypeDao(this.con);){
            Period period = new Period(now.withDayOfMonth(1).minusMonths(1L), now);
            SearchResult searchResult = new SearchResult(period, null);
            chargeDao.searchChargeList((SearchResult<Charge>)searchResult, contractIds);
            List charges = searchResult.getList();
            if (charges.isEmpty()) {
                chargeDao.searchLastChargeList((SearchResult<Charge>)searchResult, contractIds, 3);
            }
            ArrayList<Integer> typeIds = new ArrayList<Integer>();
            for (Charge charge : charges) {
                int typeId = charge.getTypeId();
                if (typeIds.contains(typeId)) continue;
                typeIds.add(typeId);
            }
            this.context.getRequest().setAttribute("balanceCharges", (Object)charges);
            this.context.getRequest().setAttribute("balanceChargeTypes", chargeTypeDao.getTypeMapByIds(typeIds));
        }
        ArrayList<Object[]> accounts = new ArrayList<Object[]>();
        this.addAccountData(now, contractIds, accounts);
        this.addAccountData(now.minusMonths(1L), contractIds, accounts);
        this.context.getRequest().setAttribute("balanceAccounts", accounts);
        GregorianCalendar nowDate = new GregorianCalendar();
        int mm = this.req.getInt("month", nowDate.get(2) + 1);
        int yy = this.req.getInt("year", nowDate.get(1));
        ContractBalanceUtils.WebBalanceData webBalanceData = ContractBalanceUtils.getWebBalanceData(this.con, this.contractId, mm, yy);
        this.context.getRequest().setAttribute("webBalanceData", (Object)webBalanceData);
        if (webBalanceData.getContractManager().getSubContracts(this.contractId, 1).size() > 0) {
            this.setResultParam("has_independent_subs", "1");
        }
        if ((messages = webBalanceData.getEvent().getMessages()).size() > 0) {
            this.setResultParam("messages", messages);
        }
        this.requestDispatcher("contract", "balance_data");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u0438")
    public void payments() throws BGException {
        int periodMonth = this.req.getInt("periodMonth", 6);
        try (PaymentDao paymentDao = new PaymentDao(this.con);
             PaymentTypeDao paymentTypeDao = new PaymentTypeDao(this.con);){
            LocalDate now = LocalDate.now();
            Date contractFromDate = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getDateFrom();
            Period period = new Period(periodMonth > 0 ? now.minusMonths(periodMonth) : TimeUtils.convertDateToLocalDate((Date)contractFromDate), now);
            SearchResult searchResult = new SearchResult(period, null);
            paymentDao.searchPaymentList((SearchResult<Payment>)searchResult, Arrays.asList(this.contractId));
            List payments = searchResult.getList();
            ArrayList<Integer> typeIds = new ArrayList<Integer>();
            for (Payment payment : payments) {
                int typeId = payment.getTypeId();
                if (typeIds.contains(typeId)) continue;
                typeIds.add(typeId);
            }
            this.context.getRequest().setAttribute("balancePeriod", (Object)period);
            this.context.getRequest().setAttribute("balancePayments", (Object)payments);
            this.context.getRequest().setAttribute("balancePaymentTypes", paymentTypeDao.getTypeMapByIds(typeIds));
        }
        this.requestDispatcher("contract", "balance_payments");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u0430\u043d\u0438\u044f")
    public void charges() throws BGException {
        int periodMonth = this.req.getInt("periodMonth", 6);
        try (ChargeDao chargeDao = new ChargeDao(this.con);
             ChargeTypeDao chargeTypeDao = new ChargeTypeDao(this.con);){
            LocalDate now = LocalDate.now();
            Date contractFromDate = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getDateFrom();
            Period period = new Period(periodMonth > 0 ? now.minusMonths(periodMonth) : TimeUtils.convertDateToLocalDate((Date)contractFromDate), now);
            SearchResult searchResult = new SearchResult(period, null);
            chargeDao.searchChargeList((SearchResult<Charge>)searchResult, Arrays.asList(this.contractId));
            List charges = searchResult.getList();
            ArrayList<Integer> typeIds = new ArrayList<Integer>();
            for (Charge charge : charges) {
                int typeId = charge.getTypeId();
                if (typeIds.contains(typeId)) continue;
                typeIds.add(typeId);
            }
            this.context.getRequest().setAttribute("balancePeriod", (Object)period);
            this.context.getRequest().setAttribute("balanceCharges", (Object)charges);
            this.context.getRequest().setAttribute("balanceChargeTypes", chargeTypeDao.getTypeMapByIds(typeIds));
        }
        this.requestDispatcher("contract", "balance_charges");
    }

    @WebOperation(title="\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430")
    public void accounts() throws BGException {
        ArrayList<Object[]> accounts = new ArrayList<Object[]>();
        List<Integer> contractIds = Arrays.asList(this.contractId);
        int periodMonth = this.req.getInt("periodMonth", 6);
        LocalDate now = LocalDate.now();
        Date contractFromDate = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getDateFrom();
        Period period = new Period(periodMonth > 0 ? now.minusMonths(periodMonth) : TimeUtils.convertDateToLocalDate((Date)contractFromDate), now);
        while (now.isAfter(period.getLocalDateFrom())) {
            this.addAccountData(now, contractIds, accounts);
            now = now.minusMonths(1L);
        }
        this.context.getRequest().setAttribute("balancePeriod", (Object)period);
        this.context.getRequest().setAttribute("balanceAccounts", accounts);
        this.requestDispatcher("contract", "balance_accounts");
    }

    private void addAccountData(LocalDate localDate, List<Integer> contractIds, List<Object[]> accounts) {
        String query = "SELECT t2.title, t1.summa FROM contract_account AS t1 LEFT JOIN service AS t2 ON t1.sid=t2.id WHERE cid IN ( " + Utils.toString(contractIds) + " ) AND mm=? AND yy=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, localDate.getMonthValue());
            ps.setInt(2, localDate.getYear());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Object[] str = new Object[3];
                BigDecimal value = rs.getBigDecimal(2);
                String title = rs.getString(1);
                str[0] = TimeUtils.convertLocalDateToDate((LocalDate)localDate);
                str[1] = title == null ? "?" : title;
                str[2] = String.valueOf(value);
                accounts.add(str);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

