/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.loader.server.utils;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.loader.server.bean.LoaderUtil;
import ru.bitel.bgbilling.kernel.contract.loader.server.utils.LoaderBase;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.common.Utils;

public class LoaderTextParameterMergeUtil
extends LoaderBase
implements LoaderUtil {
    private Logger log = LogManager.getLogger();

    @Override
    public String execute(String data, String config) throws BGException {
        JSONObject configJsonObject = new JSONObject(config);
        int parameterId = configJsonObject.optInt("parameterId", 0);
        String parameterPattern = configJsonObject.optString("pattern");
        String tableName = ContractParameterPrefType.TYPE_TEXT.getTableName();
        try {
            PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + tableName + " WHERE pid=?");
            psDelete.setInt(1, parameterId);
            psDelete.executeUpdate();
            psDelete.close();
            PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + tableName + " SET pid=?, cid=?, val=?");
            psInsert.setInt(1, parameterId);
            HashSet<Integer> pids = new HashSet<Integer>();
            Pattern pattern = Pattern.compile("\\$\\{(\\d+)\\}");
            Matcher matcher = pattern.matcher(parameterPattern);
            while (matcher.find()) {
                int id = Utils.parseInt((String)matcher.group(1), (int)0);
                if (id <= 0) continue;
                pids.add(id);
            }
            if (!pids.isEmpty()) {
                try (ContractDao contractDao = new ContractDao(this.con, 0);){
                    PreparedStatement psSelect = this.con.prepareStatement("SELECT id FROM contract");
                    ResultSet resultSet = psSelect.executeQuery();
                    while (resultSet.next()) {
                        int contractId = resultSet.getInt(1);
                        String val = parameterPattern;
                        Map<Integer, String> values = contractDao.getContractParameterValuesForParameterIds(contractId, pids);
                        Iterator iterator = pids.iterator();
                        while (iterator.hasNext()) {
                            int key = (Integer)iterator.next();
                            val = val.replaceAll("\\$\\{" + key + "\\}", Utils.maskNull((String)values.get(key)));
                        }
                        psInsert.setInt(2, contractId);
                        psInsert.setString(3, val);
                        psInsert.executeUpdate();
                    }
                    resultSet.close();
                    psSelect.close();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
            psInsert.close();
        }
        catch (Exception e) {
            this.log.error((Object)e);
            throw new BGException((Throwable)e);
        }
        return null;
    }
}

