/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.server.task;

import bitel.billing.server.contract.bean.ContractStatus;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedTopicEvent;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class ContractStatusSetter
extends TaskBase {
    @Override
    public String getDescription() {
        return this.defaultDescription + "\u0417\u0430\u0434\u0430\u0447\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432.";
    }

    @Override
    protected boolean initTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        String TEMP_TABLE_NAME = "contract_status_last";
        int defaultStatus = StatusCache.getInstance().getDefaultStatus();
        try {
            ContractStatus status;
            String title;
            Calendar date = this.getOperatingTime();
            java.sql.Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
            Object query = "UPDATE contract SET status=?, status_date=? WHERE id=?";
            PreparedStatement psSetStatus = con.prepareStatement((String)query);
            query = "SELECT cs.cid, cs.status as s1, cs.date1, cs.date2, contract.title FROM contract_status AS cs LEFT JOIN contract ON cs.cid=contract.id WHERE (cs.date1<=? AND (cs.date2 IS NULL OR cs.date2>=?) ) AND cs.status<>contract.status";
            PreparedStatement psSelect = conSlave.prepareStatement((String)query);
            psSelect.setDate(1, sqlDate);
            psSelect.setDate(2, sqlDate);
            ResultSet rs = psSelect.executeQuery();
            while (rs.next()) {
                int contractId = rs.getInt("cid");
                int statusCode = rs.getInt("s1");
                java.sql.Date date1 = rs.getDate("date1");
                title = rs.getString("title");
                this.log.info("Set contract " + title + " status " + statusCode + " from " + TimeUtils.formatDate((Date)date1));
                psSetStatus.setInt(1, statusCode);
                psSetStatus.setDate(2, date1);
                psSetStatus.setInt(3, contractId);
                psSetStatus.executeUpdate();
                status = new ContractStatus();
                status.setDateFrom(date1);
                status.setDateTo(rs.getDate("date2"));
                status.setContractId(contractId);
                status.setStatus(statusCode);
                EventProcessor.getInstance().publish(new ContractStatusChangedEvent(status, 0));
                EventProcessor.getInstance().publish(new ContractStatusChangedTopicEvent(status, 0));
            }
            psSelect.close();
            query = "CREATE TEMPORARY TABLE contract_status_last (UNIQUE(cid)) SELECT cid, MAX(date2) as date2 FROM contract_status WHERE date2 < ? GROUP BY cid";
            PreparedStatement ps = conSlave.prepareStatement((String)query);
            ps.setDate(1, sqlDate);
            ps.executeUpdate();
            ps.close();
            query = "SELECT contract.id, temp.date2, contract.title  FROM contract LEFT JOIN  contract_status ON contract_status.cid = contract.id AND contract_status.date1 <= ? AND (contract_status.date2 is null or contract_status.date2 >= ? ) LEFT JOIN contract_status_last as temp ON contract.id = temp.cid WHERE contract_status.id is null AND contract.status != " + defaultStatus;
            psSelect = conSlave.prepareStatement((String)query);
            psSelect.setDate(1, sqlDate);
            psSelect.setDate(2, sqlDate);
            rs = psSelect.executeQuery();
            while (rs.next()) {
                int cid = rs.getInt("id");
                java.sql.Date date2 = rs.getDate("temp.date2");
                date2 = date2 != null ? TimeUtils.convertCalendarToSqlDate((Calendar)TimeUtils.getNextDay((Calendar)TimeUtils.convertDateToCalendar((Date)date2))) : sqlDate;
                title = rs.getString("title");
                this.log.info("Set contract " + title + " status " + defaultStatus + " from " + TimeUtils.formatDate((Date)date2));
                psSetStatus.setInt(1, defaultStatus);
                psSetStatus.setDate(2, date2);
                psSetStatus.setInt(3, cid);
                psSetStatus.executeUpdate();
                status = new ContractStatus();
                status.setDateFrom(date2);
                status.setContractId(cid);
                status.setStatus(defaultStatus);
                EventProcessor.getInstance().publish(new ContractStatusChangedEvent(status, 0));
                EventProcessor.getInstance().publish(new ContractStatusChangedTopicEvent(status, 0));
            }
            psSelect.close();
            psSetStatus.close();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                ServerUtils.dropExistTable(conSlave, "contract_status_last");
            }
            catch (Exception exception) {}
            ServerUtils.closeConnection(con, conSlave);
        }
    }
}

