/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.module.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class ServiceDao
extends AbstractIdDao<Service>
implements Directory<Service> {
    public ServiceDao(Connection con) {
        super(con, 0, "service");
    }

    @Override
    public Service get(String title) throws BGException {
        return null;
    }

    @Override
    public List<Service> list() throws BGException {
        return this.list(null, "mid, title", new Object[0]);
    }

    public List<Service> listUsing() throws BGException {
        return this.list("isusing", "mid, title", new Object[0]);
    }

    public List<Service> list(int moduleId) throws BGException {
        return this.list("mid=?", "title", new Object[]{moduleId});
    }

    public List<Service> listUsing(int moduleId) throws BGException {
        return this.list("mid=?, isusing", "mid, title", new Object[0]);
    }

    protected void updateImpl(Service service) throws BGException, SQLException {
        boolean update = service.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, mid=?, isusing=?, unit=?, config=?, active_date_from=?, active_date_to=? " + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, service.getTitle());
            ps.setInt(index++, service.getModuleId());
            ps.setBoolean(index++, service.isUsing());
            ps.setInt(index++, service.getUnit());
            ps.setString(index++, service.getConfig());
            ps.setDate(index++, service.getActivePeriod() != null ? TimeUtils.convertDateToSqlDate((Date)service.getActivePeriod().getDateFrom()) : null);
            ps.setDate(index++, service.getActivePeriod() != null ? TimeUtils.convertDateToSqlDate((Date)service.getActivePeriod().getDateTo()) : null);
            if (update) {
                ps.setInt(index++, service.getId());
            }
            ps.executeUpdate();
            if (!update) {
                service.setId(ServerUtils.lastInsertId(this.con));
            }
        }
    }

    protected Service getFromRS(ResultSet rs) throws SQLException {
        Service service = new Service();
        service.setId(rs.getInt("id"));
        service.setTitle(rs.getString("title"));
        service.setModuleId(rs.getInt("mid"));
        service.setUsing(rs.getInt("isusing") == 1);
        service.setUnit(rs.getInt("unit"));
        service.setConfig(rs.getString("config"));
        service.setActivePeriod(new Period((Date)rs.getDate("active_date_from"), (Date)rs.getDate("active_date_to")));
        return service;
    }
}

