/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.directory.tariff.common.Directory;
import ru.bitel.bgbilling.kernel.tariff.client.ModuleTariffConfig;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTree;
import ru.bitel.bgbilling.kernel.tariff.client.tree.TariffTreeNode;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class ModuleServiceTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon((String)"services");
    private JPanel propsPanel;
    private JComboBox combo;
    private JLabel view = new JLabel();
    private Directory dir;
    private String serviceTitle;

    @Override
    public void init(int id, int mtree, String type, TariffTree tree, ModuleTariffConfig config, TariffTreeNode parent, Map<Integer, List<Element>> nodes) {
        super.init(id, mtree, type, tree, config, parent, nodes);
        this.dir = this.getDirManager().getDirectory("services");
        this.initView();
    }

    private void initView() {
        this.view.setIcon(icon);
    }

    @Override
    protected JPanel getEditorPanel() {
        this.propsPanel = new JPanel();
        this.combo = this.dir != null ? new JComboBox<IdTitle>(new Vector<IdTitle>(this.dir.getItems())) : new JComboBox();
        this.propsPanel.add(this.combo);
        return this.propsPanel;
    }

    @Override
    public Component getView() {
        this.extractData();
        StringBuffer str = new StringBuffer("\u0423\u0441\u043b\u0443\u0433\u0430: ");
        str.append(this.serviceTitle);
        this.view.setText(str.toString());
        return this.view;
    }

    @Override
    protected void loadData() {
        String data = this.getData();
        this.setDirectoryItemSelection(this.combo, Utils.parseInt((String)data, (int)0));
    }

    @Override
    protected void serializeData() {
        IdTitle di = (IdTitle)this.combo.getSelectedItem();
        if (di != null) {
            super.setData(String.valueOf(di.getId()));
        }
    }

    private void extractData() {
        this.serviceTitle = Utils.maskNull((String)this.dir.getValue(Utils.parseInt((String)this.getData())));
    }

    @Override
    public void serializeToXML(Element el) {
        super.serializeToXML(el);
        el.setAttribute("sid", this.getData());
        this.serializeChildsToXML(el);
    }

    @Override
    public void loadFromXML(Element el) {
        this.setData(el.getAttribute("sid"));
        this.saveData();
        this.loadChildsFromXML(el);
    }
}

