/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractTariff;
import bitel.billing.server.contract.bean.ContractTariffManager;
import bitel.billing.server.contract.bean.PersonalTariffManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import org.apache.commons.collections4.CollectionUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionActivateManager;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.TariffOptionActivateModeDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.TariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.option.server.event.TariffOptionListAvailableEvent;
import ru.bitel.common.Utils;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService")
public class TariffOptionServiceImpl
extends AbstractService
implements TariffOptionService {
    private TariffOptionDao tariffOptionDao;
    private TariffOptionActivateModeDao tariffOptionActivateModeDao;
    private ContractManager contractManager;
    private ContractTariffOptionDao contractTariffOptionDao;
    private ContractTariffManager contractTariffManager;
    private PersonalTariffManager personalTariffManager;
    private ContractTariffOptionActivateManager contractTariffOptionActivateManager;
    private ContractLabelManager contractLabelManager;

    @PostConstruct
    protected void init() throws BGException {
        this.tariffOptionDao = new TariffOptionDao(this.getConnection());
        this.tariffOptionActivateModeDao = new TariffOptionActivateModeDao(this.getConnection());
        this.contractManager = new ContractManager(this.getConnection());
        this.contractTariffOptionDao = new ContractTariffOptionDao(this.getConnection());
        this.contractTariffManager = new ContractTariffManager(this.getConnection());
        this.personalTariffManager = new PersonalTariffManager(this.getConnection());
        this.contractTariffOptionActivateManager = new ContractTariffOptionActivateManager(this.getConnection());
        this.contractLabelManager = new ContractLabelManager(this.getConnection());
    }

    @Override
    public TariffOption tariffOptionGet(int id) throws BGException {
        TariffOption result = (TariffOption)this.tariffOptionDao.get(id);
        List<TariffOptionActivateMode> activateModeList = this.tariffOptionActivateModeDao.getOptionActivateModeList(id, null);
        result.setActivateModeList(activateModeList);
        return result;
    }

    @Override
    public List<TariffOption> tariffOptionList() throws BGException {
        return this.tariffOptionDao.list(null);
    }

    @Override
    public List<TariffOption> tariffOptionListAvailable(int contractId, Date date, List<ContractTariffOption> currentContractOptionList, boolean onlyAvailable, boolean web) throws BGException {
        List<TariffOption> result;
        if (contractId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (date == null) {
            date = new Date();
        }
        if (this.getSetup().getBoolean("tariffOption.dontCheckOnActivateAlreadyActivated", this.getSetup().getBoolean("allow.parallel.option.activate", false))) {
            currentContractOptionList = new ArrayList<ContractTariffOption>();
        } else if (currentContractOptionList == null) {
            currentContractOptionList = this.contractTariffOptionDao.list(contractId, date);
        }
        List<TariffOption> fullOptionList = this.tariffOptionDao.list(date);
        HashSet<TariffOption> currentOptionSet = new HashSet<TariffOption>();
        for (ContractTariffOption contractTariffOption : currentContractOptionList) {
            TariffOption option = new TariffOption();
            option.setId(contractTariffOption.getOptionId());
            currentOptionSet.add(option);
        }
        if (onlyAvailable) {
            fullOptionList.removeAll(currentOptionSet);
        }
        HashSet<Integer> tariffIds = new HashSet<Integer>();
        for (ContractTariff contractTariff : this.contractTariffManager.getContractTariffList(contractId, date)) {
            tariffIds.add(contractTariff.getTariffPlanId());
        }
        tariffIds.addAll(this.personalTariffManager.getParentTreeTariffIds(contractId, date));
        Contract contract = this.contractManager.getContractById(contractId);
        List<Integer> labelsOnContract = this.contractLabelManager.getContractLabelIds(contractId);
        for (TariffOption option : fullOptionList) {
            boolean allowOptionForContract;
            if (CollectionUtils.intersection(option.getTariffIdSet(), tariffIds).size() == 0 || Utils.notEmptyCollection(labelsOnContract) && Utils.notEmptyCollection(option.getContractLabels()) && !(allowOptionForContract = option.getContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0)) continue;
            if (web) {
                if (option.isHideForWeb()) continue;
                if (option.getHideForContractGroupsMode() == 0) {
                    boolean hideThisLabel;
                    boolean bl = hideThisLabel = option.getHideForContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0;
                    if (hideThisLabel) {
                        continue;
                    }
                } else if (!labelsOnContract.containsAll(option.getHideForContractLabels())) continue;
            }
            option.setEnable(true);
        }
        TariffOptionListAvailableEvent availableListEvent = EventProcessor.getInstance().request(new TariffOptionListAvailableEvent(contractId, this.userId, date, contract, tariffIds, currentContractOptionList, onlyAvailable, web, fullOptionList));
        fullOptionList = availableListEvent.getTariffOptionList();
        if (onlyAvailable) {
            result = new ArrayList<TariffOption>();
            for (TariffOption option : fullOptionList) {
                if (!option.isEnable()) continue;
                result.add(option);
            }
        } else {
            result = fullOptionList;
        }
        for (TariffOption o : result) {
            o.setActivateModeList(this.tariffOptionActivateModeDao.getOptionActivateModeList(o.getId(), date));
        }
        return result;
    }

    @Override
    public List<TariffOption> tariffOptionWebList(int contractId, Date date, List<TariffOption> fullOptionList) throws BGException {
        if (fullOptionList == null) {
            fullOptionList = this.tariffOptionDao.list(date);
        }
        List<Integer> labelsOnContract = this.contractLabelManager.getContractLabelIds(contractId);
        ArrayList<TariffOption> result = new ArrayList<TariffOption>();
        for (TariffOption option : fullOptionList) {
            if (option.isHideForWeb()) continue;
            if (option.getHideForContractGroupsMode() == 0) {
                boolean hideThisOption;
                boolean bl = hideThisOption = option.getHideForContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0;
                if (hideThisOption) {
                    continue;
                }
            } else if (!labelsOnContract.containsAll(option.getHideForContractLabels())) continue;
            result.add(option);
        }
        return result;
    }

    @Override
    public void tariffOptionUpdate(TariffOption option) throws BGException {
        this.tariffOptionDao.update((Object)option);
        this.tariffOptionActivateModeDao.updateTariffOptionActivateModeList(option.getId(), option.getActivateModeList());
    }

    @Override
    public void tariffOptionDelete(int id) throws BGException {
        List<TariffOptionActivateMode> modeList = Collections.emptyList();
        this.tariffOptionDao.delete(id);
        this.tariffOptionActivateModeDao.updateTariffOptionActivateModeList(id, modeList);
    }

    @Override
    public List<TariffOptionActivateMode> tariffOptionActivateModeList(int optionId, Date date) throws BGException {
        if (optionId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return this.tariffOptionActivateModeDao.getOptionActivateModeList(optionId, date);
    }

    @Override
    public TariffOptionActivateMode tariffOptionActivateModeGet(int optionId, int modeId) throws BGException {
        TariffOption tariffOption = this.tariffOptionGet(optionId);
        List<TariffOptionActivateMode> list = tariffOption.getActivateModeList();
        TariffOptionActivateMode mode = null;
        for (TariffOptionActivateMode activateMode : list) {
            if (activateMode.getId() != modeId) continue;
            mode = activateMode;
            break;
        }
        return mode;
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionList(int contractId, Date date) throws BGException {
        return this.contractTariffOptionDao.list(contractId, date);
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionListWeb(int contractId, Date date, List<ContractTariffOption> list) throws BGException {
        if (list == null || list.size() == 0) {
            list = this.contractTariffOptionList(contractId, date);
        }
        List<TariffOption> visibleOptions = this.tariffOptionWebList(contractId, date, null);
        HashSet<Integer> visibleOptionIds = new HashSet<Integer>();
        for (TariffOption option : visibleOptions) {
            visibleOptionIds.add(option.getId());
        }
        ArrayList<ContractTariffOption> result = new ArrayList<ContractTariffOption>();
        for (ContractTariffOption option : list) {
            if (!visibleOptionIds.contains(option.getOptionId())) continue;
            result.add(option);
        }
        return result;
    }

    @Override
    public void contractTariffOptionActivate(int contractId, int optionId, int modeId, boolean web) throws BGException, BGMessageException {
        this.contractTariffOptionActivateManager.activateOption(this, this.userId, contractId, optionId, modeId, web);
    }

    @Override
    public int contractTariffOptionActivateWhithSum(int contractId, int optionId, int modeId, BigDecimal chargeSum, boolean web) throws BGException {
        return this.contractTariffOptionActivateManager.activateOptionWhithSum(this, this.userId, contractId, optionId, modeId, chargeSum, web);
    }

    @Override
    public void contractTariffOptionDeactivate(int contractId, int contractOptionId) throws BGException {
        this.contractTariffOptionActivateManager.deactivateOption(this.userId, contractId, contractOptionId);
    }

    @Override
    public void contractTariffOptionReactivate(int contractId, int contractOptionId) throws BGException {
        this.contractTariffOptionActivateManager.reactivateOption(this.userId, contractId, contractOptionId);
    }

    @Override
    public List<ContractTariffOption> contractTariffOptionHistory(int contractId, Date date, boolean web) throws BGException {
        List<ContractTariffOption> result = this.contractTariffOptionDao.list(contractId, date, true, true);
        if (web) {
            result = this.contractTariffOptionListWeb(contractId, date, result);
        }
        return result;
    }

    @Override
    public void contractTariffOptionDelete(int contractId, int id, boolean customer) throws BGException, BGMessageException {
        this.contractTariffOptionActivateManager.deleteOption(this.userId, contractId, id, customer);
    }
}

