/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrTextDao
extends EntityAttrDefaultDao<EntityAttrText> {
    public EntityAttrTextDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String table) {
        super(con, entityAttrDao, table);
    }

    @Override
    protected void createTable() {
        try (Statement createStatement = this.con.createStatement();){
            createStatement.execute("CREATE TABLE IF NOT EXISTS `" + this.table + "` ( `entityId` int(11) NOT NULL DEFAULT 0, `entitySpecAttrId` int(11) NOT NULL DEFAULT 0, `value` varchar(255) NOT NULL DEFAULT '', PRIMARY KEY (`entityId`,`entitySpecAttrId`) )");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public EntityAttrText get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrText result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrText(entityId, attrSpecId, rs.getString(1));
            }
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setString(3, ((EntityAttrText)a).getValue());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrText attr) throws SQLException {
        String value = attr.getValue();
        if (Utils.isBlankString((String)value)) {
            return this.deleteImpl(entityId, attr.getEntitySpecAttrId());
        }
        boolean update = false;
        try (PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());){
            ps.setString(1, value);
            update = ps.executeUpdate() == 0;
        }
        if (update) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setString(3, value);
                ps.executeUpdate();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        ps = this.entityAttrDao.getSelectOldValuePS();
        try {
            boolean bl;
            block27: {
                ResultSet rs = ps.executeQuery();
                try {
                    String oldValue = rs.next() ? rs.getString(1) : null;
                    boolean bl2 = bl = !value.equals(oldValue);
                    if (rs == null) break block27;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }
}

