/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.ip.dynamic;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntime;

public class IpCategoryRuntime {
    private int id;
    private final IpCategoryRuntime[] children;
    private final AtomicInteger childrenPosition = new AtomicInteger(-1);
    private final IpResourceRuntime[] resources;
    private final AtomicInteger resourcePosition = new AtomicInteger();
    private long size = 0L;

    public IpCategoryRuntime(int id, IpCategoryRuntime[] children, IpResourceRuntime[] resources) {
        long resSize;
        int i;
        int size;
        this.id = id;
        this.children = children;
        this.resources = resources;
        if (children != null) {
            size = children.length;
            for (i = 0; i < size; ++i) {
                resSize = children[i].getSize();
                if (resSize != Long.MIN_VALUE) {
                    this.size += resSize;
                    continue;
                }
                this.size = Long.MIN_VALUE;
                break;
            }
        }
        if (resources != null && this.size != Long.MIN_VALUE) {
            size = resources.length;
            for (i = 0; i < size; ++i) {
                resSize = resources[i].getSize();
                if (resSize != Long.MIN_VALUE) {
                    this.size += resSize;
                    continue;
                }
                this.size = Long.MIN_VALUE;
                break;
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getOccupiedCount() {
        int i;
        int size;
        long result = 0L;
        if (this.children != null) {
            size = this.children.length;
            for (i = 0; i < size; ++i) {
                result += this.children[i].getOccupiedCount();
            }
        }
        if (this.resources != null) {
            size = this.resources.length;
            for (i = 0; i < size; ++i) {
                result += this.resources[i].getOccupiedCount();
            }
        }
        return result;
    }

    public long getReservedCount() {
        int i;
        int size;
        long result = 0L;
        if (this.children != null) {
            size = this.children.length;
            for (i = 0; i < size; ++i) {
                result += this.children[i].getReservedCount();
            }
        }
        if (this.resources != null) {
            size = this.resources.length;
            for (i = 0; i < size; ++i) {
                result += this.resources[i].getReservedCount();
            }
        }
        return result;
    }

    private IpCategoryRuntime getCategory() {
        int childrenPosition = this.childrenPosition.get();
        if (childrenPosition == -1) {
            return this;
        }
        if (this.children.length > childrenPosition) {
            return this.children[childrenPosition];
        }
        return this.nextCategory();
    }

    private IpCategoryRuntime nextCategory() {
        while (true) {
            int childrenPosition;
            if (this.children.length > (childrenPosition = this.childrenPosition.get() + 1)) {
                if (!this.childrenPosition.compareAndSet(childrenPosition - 1, childrenPosition)) continue;
                return this.children[childrenPosition];
            }
            if (this.childrenPosition.compareAndSet(childrenPosition - 1, -1)) break;
        }
        return this;
    }

    private IpResourceRuntime getResource() {
        int resourcePosition = this.resourcePosition.get();
        if (this.resources.length > resourcePosition) {
            return this.resources[resourcePosition];
        }
        if (this.resources.length == 0) {
            return null;
        }
        return this.nextResource();
    }

    private IpResourceRuntime nextResource() {
        while (true) {
            int resourcePosition;
            if (this.resources.length > (resourcePosition = this.resourcePosition.get() + 1)) {
                if (!this.resourcePosition.compareAndSet(resourcePosition - 1, resourcePosition)) continue;
                return this.resources[resourcePosition];
            }
            if (this.resourcePosition.compareAndSet(resourcePosition - 1, 0)) break;
        }
        return this.resources[0];
    }

    public int reserve(List<IpResourceReserve> list, long millis, long timeout, int max) {
        IpCategoryRuntime category;
        IpCategoryRuntime next = category = this.getCategory();
        do {
            if ((max = next.reserveImpl(list, millis, timeout, max)) == 0) {
                return max;
            }
            next = this.nextCategory();
        } while (category.id != next.id);
        return max;
    }

    private int reserveImpl(List<IpResourceReserve> list, long millis, long timeout, int max) {
        if (this.resources != null) {
            IpResourceRuntime resource = this.getResource();
            if (resource == null) {
                return max;
            }
            IpResourceRuntime next = resource;
            do {
                if ((max = next.reserve(list, millis, timeout, max)) == 0) {
                    return max;
                }
                next = this.nextResource();
            } while (resource.id != next.id);
        }
        return max;
    }

    public IpResourceReserve reserve(long timeout) {
        IpCategoryRuntime category;
        IpCategoryRuntime next = category = this.getCategory();
        do {
            IpResourceReserve result;
            if ((result = next == this ? next.reserveImpl(timeout) : next.reserve(timeout)) != null) {
                return result;
            }
            next = this.nextCategory();
        } while (category.id != next.id);
        return null;
    }

    private IpResourceReserve reserveImpl(long timeout) {
        if (this.resources != null) {
            IpResourceRuntime resource;
            IpResourceRuntime next = resource = this.getResource();
            do {
                IpResourceReserve result;
                if ((result = resource.reserve(timeout)) != null) {
                    return result;
                }
                next = this.nextResource();
            } while (resource.id != next.id);
        }
        return null;
    }

    public int getIpResourceId(byte[] address, long millis) {
        for (IpResourceRuntime resource : this.resources) {
            if (!resource.isCoincide(address, millis)) continue;
            return resource.id;
        }
        for (IpCategoryRuntime category : this.children) {
            int result = category.getIpResourceId(address, millis);
            if (result <= 0) continue;
            return result;
        }
        return -1;
    }

    public IpResourceRuntime[] getIpResources() {
        return this.resources;
    }
}

