/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.server.installer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ModuleInstaller {
    private static FilesData localFilesData = new FilesData();
    private static FilesData remoteFilesData = new FilesData();
    private static String serverDirectory = System.getProperty("bgbiling.server.directory", ".");

    public static void main(String[] args) {
        String host = System.getProperty("bgbilling.server.url", "https://bgbilling.ru");
        Path filesDatPath = Paths.get(serverDirectory, "/data/files.dat");
        boolean newInstall = Files.notExists(Paths.get(serverDirectory, "lib", "server", "kernel-server.jar"), new LinkOption[0]);
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest request = null;
        boolean allowInstallNewComponent = true;
        try {
            ModuleInstaller.parseFilesData(localFilesData, Files.readAllLines(filesDatPath));
            if ("current".equals(ModuleInstaller.localFilesData.set)) {
                System.out.println("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c " + host + "/download/" + ModuleInstaller.localFilesData.version + "/current");
                request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/current")).build();
                ModuleInstaller.localFilesData.set = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            }
            System.out.println("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0444\u0430\u0439\u043b\u043e\u0432 \u0434\u043b\u044f \u0432\u0435\u0440\u0441\u0438\u0438: " + ModuleInstaller.localFilesData.version + "; \u043d\u0430\u0431\u043e\u0440: " + ModuleInstaller.localFilesData.set);
            request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/sets/" + ModuleInstaller.localFilesData.set + "/files.dat")).build();
            HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                allowInstallNewComponent = false;
                request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/current")).build();
                ModuleInstaller.localFilesData.set = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
                request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/sets/" + ModuleInstaller.localFilesData.set + "/files.dat")).build();
                response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() != 200) {
                    System.out.println("\u041d\u0435 \u0443\u0434\u0430\u043b\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u0444\u0430\u0439\u043b\u043e\u0432... \u041f\u0440\u0435\u0440\u044b\u0432\u0430\u0435\u043c \u0440\u0430\u0431\u043e\u0442\u0443...");
                    System.exit(1);
                }
                System.out.println("\u0424\u0430\u0439\u043b\u044b \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b, \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u0441\u044f \u043d\u0430 \u0432\u0435\u0440\u0441\u0438\u044f: " + ModuleInstaller.localFilesData.version + "; \u043d\u0430\u0431\u043e\u0440: " + ModuleInstaller.localFilesData.set);
            }
            System.out.println("Version: " + ModuleInstaller.localFilesData.version);
            System.out.println("Set: " + ModuleInstaller.localFilesData.set);
            ModuleInstaller.parseFilesData(remoteFilesData, Arrays.asList(response.body().split("\n")));
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
        }
        if (newInstall) {
            try {
                ModuleInstaller.downloadAndInstall(ModuleInstaller.localFilesData.set, ModuleInstaller.remoteFilesData.filesData.get("kernel"), httpClient, host, serverDirectory);
                ModuleInstaller.downloadAndInstall(ModuleInstaller.localFilesData.set, ModuleInstaller.remoteFilesData.filesData.get("updateLib"), httpClient, host, serverDirectory);
                System.out.println("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u0441\u0435 \u043c\u043e\u0434\u0443\u043b\u0438 \u0438 \u043f\u043b\u0430\u0433\u0438\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0439 (yes/no)");
                System.out.print("=> ");
                String result = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if ("yes".equals(result.toLowerCase())) {
                    Path licPath = Paths.get(serverDirectory, "/data/lic.properties");
                    if (Files.exists(licPath, new LinkOption[0]) && Files.isRegularFile(licPath, new LinkOption[0])) {
                        for (String line : Files.readAllLines(licPath)) {
                            if (!line.startsWith("licence.")) continue;
                            String name = line.split("=")[0];
                            name = name.substring(name.lastIndexOf(46) + 1);
                            System.out.println("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 -> " + name);
                            ModuleInstaller.downloadAndInstall(ModuleInstaller.localFilesData.set, ModuleInstaller.remoteFilesData.filesData.get(name), httpClient, host, serverDirectory);
                        }
                    } else {
                        System.out.println("\u0424\u0430\u0439\u043b " + licPath.toString() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d...");
                    }
                }
                ModuleInstaller.saveFilesData(filesDatPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        block20: while (true) {
            try {
                block21: while (true) {
                    switch (ModuleInstaller.selectMenu(List.of("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b", "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0435\u0442\u044b", "\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0438\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b"))) {
                        case "1": {
                            if (allowInstallNewComponent) {
                                ArrayList<String> menus = new ArrayList<String>();
                                for (FileData fileData : ModuleInstaller.remoteFilesData.filesData.values()) {
                                    if (fileData.name.startsWith("BG")) continue;
                                    boolean result = true;
                                    for (FileData localFileData : ModuleInstaller.localFilesData.filesData.values()) {
                                        if (!fileData.name.equals(localFileData.name)) continue;
                                        result = false;
                                        break;
                                    }
                                    if (!result) continue;
                                    menus.add(fileData.name);
                                }
                                String name = (String)menus.get(Integer.valueOf(ModuleInstaller.selectMenu(menus)) - 1);
                                ModuleInstaller.downloadAndInstall(ModuleInstaller.localFilesData.set, ModuleInstaller.remoteFilesData.filesData.get(name), httpClient, host, serverDirectory);
                                ModuleInstaller.saveFilesData(filesDatPath);
                                break;
                            }
                            System.out.println("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u043d\u043e\u0432\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0439 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u0442\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u043e \u0431\u043e\u043b\u0435\u0435 \u043d\u043e\u0432\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438/\u0441\u0431\u043e\u0440\u043a\u0438");
                            break;
                        }
                        case "2": {
                            request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/sets/list.dat")).build();
                            String listDat = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
                            if (listDat == null || listDat.isEmpty()) continue block21;
                            ArrayList<String> sets = new ArrayList<String>();
                            long b = Long.valueOf(ModuleInstaller.localFilesData.set);
                            Stream.of(listDat.split("\n")).filter(a -> Long.valueOf(a) > b).sorted(Comparator.reverseOrder()).forEach(a -> sets.add((String)a));
                            if (!sets.isEmpty()) {
                                ModuleInstaller.localFilesData.set = (String)sets.get(Integer.valueOf(ModuleInstaller.selectMenu(sets)) - 1);
                                request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/sets/" + ModuleInstaller.localFilesData.set + "/files.dat")).build();
                                ModuleInstaller.parseFilesData(remoteFilesData, Arrays.asList(httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body().split("\n")));
                                Iterator<FileData> iterator = ModuleInstaller.localFilesData.filesData.values().iterator();
                                while (true) {
                                    if (!iterator.hasNext()) continue block20;
                                    FileData fileData = iterator.next();
                                    if (fileData.name.startsWith("BG")) continue;
                                    ModuleInstaller.downloadAndInstall(ModuleInstaller.localFilesData.set, ModuleInstaller.remoteFilesData.filesData.get(fileData.name), httpClient, host, serverDirectory);
                                    ModuleInstaller.saveFilesData(filesDatPath);
                                    allowInstallNewComponent = true;
                                }
                            }
                            System.out.println("\n\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b...");
                            break;
                        }
                        case "3": {
                            int pos = 1;
                            System.out.println("\n\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b:");
                            Iterator<FileData> b = ModuleInstaller.localFilesData.filesData.values().iterator();
                            while (true) {
                                if (!b.hasNext()) continue block20;
                                FileData fileData = b.next();
                                System.out.println(String.format("%2d) %-20s [checkSum: %s  zip: %s]", pos, fileData.name, fileData.checkSum, fileData.zipName));
                                ++pos;
                            }
                        }
                        case "4": {
                            request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/sets/list.dat")).build();
                            String listDat = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
                            if (listDat != null && !listDat.isEmpty()) {
                                List<String> sets = Arrays.asList(listDat.split("\n"));
                                if (sets.contains(ModuleInstaller.localFilesData.set)) {
                                    request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/sets/" + ModuleInstaller.localFilesData.set + "/files.dat")).build();
                                    ModuleInstaller.parseFilesData(remoteFilesData, Arrays.asList(httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body().split("\n")));
                                    Iterator<FileData> iterator = ModuleInstaller.localFilesData.filesData.values().iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) continue block20;
                                        FileData fileData = iterator.next();
                                        if (fileData.name.startsWith("BG")) continue;
                                        ModuleInstaller.downloadAndInstall(ModuleInstaller.localFilesData.set, ModuleInstaller.remoteFilesData.filesData.get(fileData.name), httpClient, host, serverDirectory);
                                        ModuleInstaller.saveFilesData(filesDatPath);
                                        allowInstallNewComponent = true;
                                    }
                                }
                                System.out.printf("\n\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c, \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b \u0432\u0430\u0448\u0435\u0439 \u0441\u0431\u043e\u0440\u043a\u0438 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 [%s-%s]\n", ModuleInstaller.localFilesData.version, ModuleInstaller.localFilesData.set);
                                break;
                            }
                            System.out.printf("\n\u041f\u0435\u0440\u0435\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c, \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0441\u0431\u043e\u0440\u043e\u043a \u0434\u043b\u044f \u0432\u0430\u0448\u0435\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 [%s]\n", ModuleInstaller.localFilesData.version);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static String selectMenu(List<String> list) throws IOException {
        int max = list.isEmpty() ? 0 : list.stream().map(a -> a.length()).max(Integer::compare).get();
        int allCol = 80 / (max + 5);
        String result = null;
        System.out.println("\nSelect:");
        while (true) {
            int allRow = list.size() / allCol + (list.size() % allCol > 0 ? 1 : 0);
            for (int row = 0; row < allRow; ++row) {
                int pos;
                for (int col = 0; col < allCol && (pos = col * allRow + row + 1) <= list.size(); ++col) {
                    System.out.printf("%2d) %-" + (max + 1) + "s", pos, list.get(pos - 1));
                }
                System.out.println();
            }
            System.out.println(" 0) Exit");
            System.out.print("=> ");
            result = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (result.matches("^[0-9]+$") && Integer.valueOf(result) <= list.size()) break;
            System.out.println("Parse error...\n");
        }
        if ("0".equals(result)) {
            ModuleInstaller.buildLibs();
            System.exit(0);
        }
        return result;
    }

    private static void buildLibs() {
        System.out.println("\n\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0431\u0438\u0431\u043b\u0438\u043e\u0442\u0435\u043a\n");
        Path libConfPath = Paths.get(serverDirectory, "/lib.conf.d");
        if (Files.isDirectory(libConfPath, new LinkOption[0])) {
            HashSet libInfos = new HashSet();
            try {
                Files.list(libConfPath).forEach(p -> {
                    if (Files.isRegularFile(p, new LinkOption[0])) {
                        try {
                            Files.lines(p).forEach(line -> libInfos.add(line));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                ArrayList<String> mavenUrls = new ArrayList<String>();
                Path mavenUrlPath = Paths.get(serverDirectory, "/data/maven.url");
                if (Files.isRegularFile(mavenUrlPath, new LinkOption[0])) {
                    mavenUrls.addAll(Files.readAllLines(mavenUrlPath));
                }
                if (Files.isRegularFile(mavenUrlPath = Paths.get(serverDirectory, "/data/maven.url.custom"), new LinkOption[0])) {
                    mavenUrls.addAll(Files.readAllLines(mavenUrlPath));
                }
                if (mavenUrls.isEmpty()) {
                    System.out.println("\u0421\u043f\u0438\u0441\u043e\u043a maven.url \u043f\u0443\u0441\u0442\u043e\u0439....");
                    return;
                }
                Path cachePath = Paths.get(serverDirectory, "/.cache");
                if (!Files.exists(cachePath, new LinkOption[0])) {
                    Files.createDirectory(cachePath, new FileAttribute[0]);
                }
                if (!Files.isDirectory(cachePath, new LinkOption[0])) {
                    System.out.println(cachePath + " \u043d\u0435 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f...");
                    return;
                }
                HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
                HttpRequest request = null;
                HashMap<String, List> libs = new HashMap<String, List>();
                for (String libInfo : libInfos) {
                    String[] data = libInfo.split("\t");
                    if (data.length <= 1) continue;
                    String[] libData = data[0].split(":");
                    if (libData.length != 3) {
                        System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0430\u0440\u0441\u0438\u043d\u0433\u0430 \u0441\u0442\u0440\u043e\u043a\u0438 - " + libInfo);
                        continue;
                    }
                    Path libPath = Paths.get(cachePath.toString(), "/", libData[0], "/", libData[1] + "-" + libData[2] + ".jar");
                    if (Files.notExists(libPath, new LinkOption[0])) {
                        if (Files.notExists(libPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(libPath.getParent(), new FileAttribute[0]);
                        }
                        for (String mavenUrl : mavenUrls) {
                            String libUrl = mavenUrl + libData[0].replace('.', '/') + "/" + libData[1] + "/" + libData[2] + "/" + libData[1] + "-" + libData[2] + ".jar";
                            System.out.println("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c " + libUrl);
                            request = HttpRequest.newBuilder().uri(URI.create(libUrl)).build();
                            try {
                                HttpResponse<byte[]> response = httpClient.send(request, HttpResponse.BodyHandlers.ofByteArray());
                                if (response.statusCode() != 200) continue;
                                Files.write(libPath, response.body(), new OpenOption[0]);
                                break;
                            }
                            catch (HttpConnectTimeoutException e) {
                                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 - " + e.getMessage());
                            }
                            catch (InterruptedException e) {
                                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 - " + e.getMessage());
                            }
                            catch (IOException e) {
                                System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 - " + e.getMessage());
                            }
                        }
                        if (Files.notExists(libPath, new LinkOption[0])) {
                            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 - " + libPath);
                            return;
                        }
                    }
                    List paths = libs.getOrDefault(data[1], new ArrayList());
                    paths.add(libPath);
                    libs.put(data[1], paths);
                }
                for (String libDir : libs.keySet()) {
                    if (!libDir.startsWith("lib/")) continue;
                    Path libDirPath = Paths.get(serverDirectory, libDir);
                    if (Files.isDirectory(libDirPath, new LinkOption[0])) {
                        Files.list(libDirPath).forEach(dir -> {
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        });
                    }
                    for (Path libPath : (List)libs.get(libDir)) {
                        Path toPath = Paths.get(libDirPath.toString(), libPath.getFileName().toString());
                        if (Files.notExists(toPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(toPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(libPath, toPath, new CopyOption[0]);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\u041a\u0430\u0442\u0430\u043b\u043e\u0433 " + libConfPath + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442...");
        }
    }

    private static void saveFilesData(Path filesDatPath) throws IOException {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("version:" + ModuleInstaller.localFilesData.version + "\n");
        stringWriter.write("set:" + ModuleInstaller.localFilesData.set + "\n");
        ModuleInstaller.localFilesData.filesData.values().forEach(fd -> stringWriter.write(String.format("name:%s\tzipName:%s\tcheckSum:%s\tsize:%s\n", fd.name, fd.zipName, fd.checkSum, fd.size)));
        Files.writeString(filesDatPath, (CharSequence)stringWriter.toString(), new OpenOption[0]);
    }

    private static void downloadAndInstall(String set, FileData fileData, HttpClient httpClient, String host, String serverDirectory) throws IOException, InterruptedException {
        if (fileData == null) {
            System.out.println("\u041e\u0448\u0438\u0431\u043a\u0430 fileData = null");
            return;
        }
        System.out.println("\nInstall " + host + "/download/" + ModuleInstaller.localFilesData.version + "/sets/" + set + "/" + fileData.zipName);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(host + "/download/" + ModuleInstaller.localFilesData.version + "/sets/" + set + "/" + fileData.zipName)).build();
        HttpResponse<InputStream> fileResponse = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        ZipInputStream zipInputStream = new ZipInputStream(fileResponse.body());
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            Path path = Paths.get(serverDirectory, zipEntry.getName());
            if (zipEntry.isDirectory()) {
                if (zipEntry.getName().matches(".*lib[\\\\/]+ext[/\\\\]+(client|server|common)[\\\\/]+") && Files.exists(path, new LinkOption[0])) {
                    Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                Files.createDirectories(path, new FileAttribute[0]);
            } else {
                byte[] oldBytes;
                if (!zipEntry.getName().endsWith(".jar")) {
                    Path origPath = Paths.get(path.toString() + ".orig", new String[0]);
                    path = Files.exists(origPath, new LinkOption[0]) ? origPath : path;
                }
                byte[] newBytes = zipInputStream.readAllBytes();
                byte[] byArray = oldBytes = Files.exists(path, new LinkOption[0]) ? Files.readAllBytes(path) : null;
                if (oldBytes == null || newBytes.length != oldBytes.length || !Arrays.equals(newBytes, oldBytes)) {
                    Files.write(path, newBytes, new OpenOption[0]);
                    System.out.println("\t" + zipEntry.getName() + " to " + path);
                }
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        ModuleInstaller.localFilesData.filesData.put(fileData.name, fileData);
    }

    private static void parseFilesData(FilesData localFilesData, List<String> lines) {
        LinkedHashMap<String, FileData> map = new LinkedHashMap<String, FileData>();
        if (lines != null && !lines.isEmpty()) {
            for (String line : lines) {
                if (line.startsWith("version:")) {
                    localFilesData.version = line.substring(8);
                    continue;
                }
                if (line.startsWith("set:")) {
                    localFilesData.set = line.substring(4);
                    continue;
                }
                FileData fileData = new FileData();
                for (String name : line.split("\t")) {
                    if (name.startsWith("name:")) {
                        fileData.name = name.substring(5);
                        continue;
                    }
                    if (name.startsWith("zipName:")) {
                        fileData.zipName = name.substring(8);
                        continue;
                    }
                    if (name.startsWith("checkSum:")) {
                        fileData.checkSum = name.substring(9);
                        continue;
                    }
                    if (!name.startsWith("size:")) continue;
                    fileData.size = Long.valueOf(name.substring(5));
                }
                map.put(fileData.name, fileData);
            }
        }
        localFilesData.filesData = map;
    }

    public static class FilesData {
        public String version = "beta";
        public String set = "current";
        public LinkedHashMap<String, FileData> filesData = null;
    }

    public static class FileData {
        public String name;
        public String zipName;
        public String checkSum;
        public long size;
    }
}

