/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RangedIntegerSet
extends AbstractSet<Integer> {
    protected final Range[] ranges;
    protected final int size;

    public RangedIntegerSet(int[] range) {
        if (range[1] < range[0]) {
            this.ranges = new Range[0];
            this.size = 0;
        } else {
            Range[] r = new Range[]{new Range(range[0], range[1], 0, range[1] - range[0])};
            this.ranges = r;
            this.size = range[1] - range[0] + 1;
        }
    }

    public RangedIntegerSet(List<int[]> ranges) {
        ArrayList<int[]> list = new ArrayList<int[]>(ranges.size());
        block0: for (int[] r : ranges) {
            if (r[1] < r[0]) continue;
            for (int[] range : list) {
                if (range[0] > r[1] || range[1] < r[0]) continue;
                range[0] = Math.min(range[0], r[0]);
                range[1] = Math.max(range[1], r[1]);
                continue block0;
            }
            list.add(new int[]{r[0], r[1]});
        }
        int rangeSize = 0;
        ArrayList<Range> result = new ArrayList<Range>(list.size());
        for (int[] range : list) {
            int dif = range[1] - range[0];
            result.add(new Range(range[0], range[1], rangeSize, rangeSize + dif));
            rangeSize += dif + 1;
        }
        this.ranges = result.toArray(new Range[result.size()]);
        this.size = rangeSize;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int index = 0;
            private Range range;
            private Integer current;
            {
                this.range = RangedIntegerSet.this.ranges.length > 0 ? RangedIntegerSet.this.ranges[0] : null;
                this.current = RangedIntegerSet.this.ranges.length > 0 ? Integer.valueOf(RangedIntegerSet.this.ranges[0].start) : null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public Integer next() {
                Integer current = this.current;
                Integer next = current + 1;
                if (next > this.range.end) {
                    if (++this.index < RangedIntegerSet.this.ranges.length) {
                        this.range = RangedIntegerSet.this.ranges[this.index];
                        next = this.range.start;
                    } else {
                        next = null;
                    }
                }
                this.current = next;
                return current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        block3: {
            block2: {
                if (!(o instanceof Long)) break block2;
                Long i = (Long)o;
                for (Range r : this.ranges) {
                    if (i < (long)r.start || i > (long)r.end) continue;
                    return true;
                }
                break block3;
            }
            if (!(o instanceof Integer)) break block3;
            Integer i = (Integer)o;
            for (Range r : this.ranges) {
                if (i < r.start || i > r.end) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public Integer get(int index) {
        for (Range r : this.ranges) {
            if (index < r.indexStart || index > r.indexEnd) continue;
            return r.start + (index - r.indexStart);
        }
        return null;
    }

    public Integer next(int index, Set<Integer> except) {
        int result;
        int i = index;
        for (Range r : this.ranges) {
            result = r.start + (i - r.indexStart);
            while (i >= r.indexStart && i <= r.indexEnd) {
                if (!except.contains(result)) {
                    return result;
                }
                ++i;
                ++result;
            }
        }
        i = 0;
        for (Range r : this.ranges) {
            if (r.indexStart >= index) continue;
            result = r.start + (i - r.indexStart);
            while (i >= r.indexStart && i <= r.indexEnd && i < index) {
                if (!except.contains(result)) {
                    return result;
                }
                ++i;
                ++result;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        RangedIntegerSet r = new RangedIntegerSet(new int[]{3, 5});
        System.out.println(r.nextReverse(1, new HashSet<Integer>(Arrays.asList(3, 4))));
    }

    public Integer nextReverse(int index, Set<Integer> except) {
        int result;
        Range r;
        int ii;
        int i = index;
        for (ii = this.ranges.length - 1; ii >= 0; --ii) {
            r = this.ranges[ii];
            result = r.start + (i - r.indexStart);
            while (i >= r.indexStart && i <= r.indexEnd) {
                if (!except.contains(result)) {
                    return result;
                }
                --i;
                --result;
            }
        }
        i = this.size - 1;
        for (ii = this.ranges.length - 1; ii >= 0; --ii) {
            r = this.ranges[ii];
            if (r.indexEnd <= index) continue;
            result = r.start + (i - r.indexStart);
            while (i >= r.indexStart && i <= r.indexEnd && i > index) {
                if (!except.contains(result)) {
                    return result;
                }
                --i;
                --result;
            }
        }
        return null;
    }

    private static class Range {
        final int start;
        final int end;
        final int indexStart;
        final int indexEnd;

        public Range(int start, int end, int indexStart, int indexEnd) {
            this.start = start;
            this.end = end;
            this.indexStart = indexStart;
            this.indexEnd = indexEnd;
        }
    }
}

