/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.clusterdb;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;

public class DBEditor
extends BGPanel {
    private JTextField dbTitle = new JTextField();
    private JTextField dbUrl = new JTextField();
    private JTextField dbUser = new JTextField();
    private JPasswordField dbPassword = new JPasswordField();
    private JTextField dbComment = new JTextField();

    public DBEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel infoPanel = new JPanel();
        BGButtonPanelRestoreOkCancelHelp okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        this.setLayout(new GridBagLayout());
        infoPanel.setLayout(new GridBagLayout());
        infoPanel.setBorder(new BGTitleBorder(" \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 "));
        this.dbTitle.setMinimumSize(new Dimension(330, 24));
        this.dbTitle.setPreferredSize(new Dimension(330, 24));
        this.dbTitle.setColumns(30);
        this.dbUrl.setMinimumSize(new Dimension(330, 24));
        this.dbUrl.setPreferredSize(new Dimension(330, 24));
        this.dbUrl.setColumns(30);
        this.dbUser.setMinimumSize(new Dimension(330, 24));
        this.dbUser.setPreferredSize(new Dimension(330, 24));
        this.dbUser.setColumns(30);
        this.dbPassword.setMinimumSize(new Dimension(330, 24));
        this.dbPassword.setPreferredSize(new Dimension(330, 24));
        this.dbPassword.setColumns(30);
        this.dbComment.setMinimumSize(new Dimension(330, 24));
        this.dbComment.setPreferredSize(new Dimension(330, 24));
        this.dbComment.setColumns(30);
        okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBEditor.this.okCancelPerformed(e);
            }
        });
        this.add((Component)infoPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        infoPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        infoPanel.add((Component)new JLabel("\u0423\u0420\u041b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        infoPanel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        infoPanel.add((Component)new JLabel("\u0418\u043c\u044f:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        infoPanel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        infoPanel.add((Component)this.dbTitle, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        infoPanel.add((Component)this.dbUrl, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        infoPanel.add((Component)this.dbComment, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        infoPanel.add((Component)this.dbUser, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        infoPanel.add((Component)this.dbPassword, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)okCancelPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    private void okCancelPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.setData();
        } else if ("ok".equals(actionCommand)) {
            this.updateData();
        } else if ("cancel".equals(actionCommand)) {
            this.setVisible(false);
        } else if ("help".equals(actionCommand)) {
            this.openHelp(this.getClass().getName());
        }
    }

    @Override
    public void setData() {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        if (this.id != null && !this.id.equals("0")) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ClusterDBGet");
            request.setAttribute("id", this.id);
            Document doc = TransferManager.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                Element db = XMLUtils.selectElement(doc, "//db");
                this.dbTitle.setText(XMLUtils.getAttribute(db, "title", ""));
                this.dbUrl.setText(XMLUtils.getAttribute(db, "url", ""));
                this.dbUser.setText(XMLUtils.getAttribute(db, "user", ""));
                this.dbPassword.setText("passwordpassword");
                this.dbComment.setText(XMLUtils.getAttribute(db, "comment", ""));
            }
        } else {
            this.dbTitle.setText("");
            this.dbUrl.setText("");
            this.dbUser.setText("");
            this.dbPassword.setText("");
            this.dbComment.setText("");
        }
    }

    private void init() {
    }

    private void updateData() {
        if (this.dbTitle.getText().trim().length() < 1) {
            ClientUtils.showErrorMessageDialog("\u041f\u043e\u043b\u0435 \"\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\" \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
            return;
        }
        if (this.dbUrl.getText().trim().length() < 1) {
            ClientUtils.showErrorMessageDialog("\u041f\u043e\u043b\u0435 \"\u0410\u0434\u0440\u0435\u0441\" \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ClusterDBUpdate");
        request.setAttribute("id", this.id);
        request.setAttribute("title", this.dbTitle.getText().trim());
        request.setAttribute("url", this.dbUrl.getText().trim());
        request.setAttribute("user", this.dbUser.getText().trim());
        request.setAttribute("comment", this.dbComment.getText().trim());
        if (!"passwordpassword".equals(new String(this.dbPassword.getPassword()))) {
            request.setAttribute("pswd", new String(this.dbPassword.getPassword()));
        }
        if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
            this.setVisible(false);
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
    }
}

