/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.clusterdb;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.admin.clusterdb.TableEditor;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class TableManager
extends BGPanel {
    private String clustertableID;
    private String currentmoduleID;
    private JPanel dbtSelectedModulePanel = new JPanel();
    private JComboBox<ComboBoxItem> dbtSelectedModule = new JComboBox();
    private BGTable table = new BGTable();
    private TableEditor editor = new TableEditor();

    public TableManager() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "clustertable");
        this.editor.setVisible(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.editor.setBorder(new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        JScrollPane tableScroll = new JScrollPane();
        tableScroll.setViewportView(this.table);
        this.dbtSelectedModulePanel.setLayout(new GridBagLayout());
        this.dbtSelectedModulePanel.setBorder(new BGTitleBorder(" \u041c\u043e\u0434\u0443\u043b\u044c "));
        this.dbtSelectedModulePanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.dbtSelectedModulePanel.add(this.dbtSelectedModule, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.dbtSelectedModulePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)tableScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TableManager.this.editItem();
                }
            }
        });
        this.editor.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                TableManager.this.setData();
            }
        });
        this.dbtSelectedModule.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ev.getStateChange() == 1) {
                    TableManager.this.setData();
                }
            }
        });
    }

    @Override
    public void setData() {
        if (!this.init) {
            this.init = true;
            this.init();
        }
        this.currentmoduleID = ClientUtils.getIdFromComboBox(this.dbtSelectedModule);
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("ClusterTableList");
        request.setAttribute("currentModuleId", this.currentmoduleID);
        Document doc = TransferManager.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.table.updateData(XMLUtils.getNode(doc, "table"));
        }
    }

    private void init() {
        Element list;
        Request req = new Request();
        req.setModule("service");
        req.setAction("Modules");
        Document doc = TransferManager.getDocument(req);
        if (ClientUtils.checkStatus(doc) && (list = XMLUtils.getElement(doc, "modules")).getChildNodes().getLength() > 0) {
            this.dbtSelectedModule.setModel(ClientUtils.buildComboBox(list, ""));
        }
        ComboBoxItem comboBoxItem = new ComboBoxItem("0", "[kernel]");
        ((DefaultComboBoxModel)this.dbtSelectedModule.getModel()).addElement(comboBoxItem);
    }

    @Override
    public void newItem() {
        this.clustertableID = "0";
        this.startEdit();
    }

    @Override
    public void editItem() {
        this.clustertableID = ClientUtils.getRowId(this.table, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 <\u043e\u0431\u044a\u0435\u043a\u0442> \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", null);
        if (this.clustertableID == null) {
            return;
        }
        this.startEdit();
    }

    @Override
    public void deleteItem() {
        String id = ClientUtils.getRowId(this.table, "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 <\u043e\u0431\u044a\u0435\u043a\u0442> \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", null);
        if (id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c <\u043e\u0431\u044a\u0435\u043a\u0442>?", "\u0423\u0434\u0430\u0435\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ClusterTableDelete");
            request.setAttribute("id", id);
            if (ClientUtils.checkStatus(TransferManager.getDocument(request))) {
                this.setData();
            }
        }
    }

    private void startEdit() {
        this.currentmoduleID = ClientUtils.getIdFromComboBox(this.dbtSelectedModule);
        this.editor.setCurrentModuleId(this.currentmoduleID);
        this.editor.setCurrentmoduleName(this.dbtSelectedModule.getSelectedItem().toString());
        this.editor.setId(this.clustertableID);
        this.editor.setData();
        this.editor.setVisible(true);
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.editor.init(module, mid);
    }
}

