/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.IntTextField;
import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractSubPanel;
import bitel.billing.module.contract.ContractSubPanel_WebStatLog;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ContractSubPanel_WebStat
extends ContractSubPanel {
    private JLabel label = new JLabel();
    private JLabel lastLogonLabel = new JLabel();
    private IntTextField limitField = new IntTextField();
    private JRadioButton limitDefault = new JRadioButton("\u041e\u0431\u0449\u0438\u0439");
    private JRadioButton limitOff = new JRadioButton("\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d");
    private JRadioButton limitPersonal = new JRadioButton("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439:");
    private BGButton unlockButton = null;
    private ButtonGroup group = new ButtonGroup();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private ContractSubPanel_WebStatLog logonOkPanel = new ContractSubPanel_WebStatLog();
    private ContractSubPanel_WebStatLog logonErrorPanel = new ContractSubPanel_WebStatLog();

    public ContractSubPanel_WebStat() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContractSubPanel_WebStat.this.reset(e.getActionCommand());
            }
        };
        JPanel state = new JPanel(new GridBagLayout());
        this.label.setFont(new Font("Dialog", 1, 18));
        BGButton counterResetButton = new BGButton("\u0421\u0431\u0440\u043e\u0441", "reset", actionListener);
        state.setBorder(new BGTitleBorder(" \u0421\u0447\u0435\u0442\u0447\u0438\u043a \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0439 "));
        state.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        state.add((Component)counterResetButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel lastLogon = new JPanel(new GridBagLayout());
        this.unlockButton = new BGButton("\u0420\u0430\u0437\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u0442\u044c", "unlock", actionListener);
        lastLogon.setBorder(new BGTitleBorder("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 \u0432\u0445\u043e\u0434"));
        lastLogon.add((Component)this.lastLogonLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        lastLogon.add((Component)this.unlockButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel limit = new JPanel(new GridBagLayout());
        BGButton setLimitButton = new BGButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c", "setLimit", actionListener);
        this.group.add(this.limitDefault);
        this.group.add(this.limitOff);
        this.group.add(this.limitPersonal);
        this.limitField.setMinValue(1L);
        this.limitField.setEnabled(false);
        this.limitPersonal.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ContractSubPanel_WebStat.this.limitField.setEnabled(ContractSubPanel_WebStat.this.limitPersonal.getModel().isSelected());
            }
        });
        limit.setBorder(new BGTitleBorder(" \u041b\u0438\u043c\u0438\u0442 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0439 "));
        limit.add((Component)this.limitDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 5, 0), 0, 0));
        limit.add((Component)this.limitOff, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 5, 5), 0, 0));
        limit.add((Component)this.limitPersonal, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 5, 5), 0, 0));
        limit.add((Component)this.limitField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 5, 5), 0, 0));
        limit.add((Component)setLimitButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.logonOkPanel.setLogType("ok");
        this.logonErrorPanel.setLogType("error");
        this.tabbedPane.add((Component)this.logonOkPanel, "\u0412\u0445\u043e\u0434\u044b");
        this.tabbedPane.add((Component)this.logonErrorPanel, "\u041e\u0448\u0438\u0431\u043a\u0438");
        this.setLayout(new GridBagLayout());
        this.add((Component)lastLogon, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)state, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)limit, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void setParentComponent(ContractEditor editor) {
        super.init(editor);
        this.logonOkPanel.setParentComponent(editor);
        this.logonErrorPanel.setParentComponent(editor);
        this.logonOkPanel.setFirstData();
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = ContractSubPanel_WebStat.this.tabbedPane.getSelectedIndex();
                if (index == 0) {
                    ContractSubPanel_WebStat.this.logonOkPanel.setFirstData();
                } else {
                    ContractSubPanel_WebStat.this.logonErrorPanel.setFirstData();
                }
            }
        });
    }

    public void reset(String actionCommand) {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("WebRequestLimit");
        request.setContractId(this.getContractId());
        if ("setLimit".equals(actionCommand)) {
            if (this.limitDefault.getModel().isSelected()) {
                request.setAttribute("mode", "1");
            } else if (this.limitOff.getModel().isSelected()) {
                request.setAttribute("mode", "2");
            } else {
                request.setAttribute("mode", "3");
                request.setAttribute("limit", this.limitField.getText());
            }
        } else {
            request.setAttribute(actionCommand, "1");
        }
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("WebRequestLimit");
        request.setContractId(this.getContractId());
        this.setDocument(this.getDocument(request));
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            Element limitNode = XMLUtils.selectElement(doc, "//web_limit");
            int limit = Utils.parseInt(limitNode.getAttribute("limit"), -1);
            int configLimit = Utils.parseInt(limitNode.getAttribute("configLimit"));
            int status = Utils.parseInt(limitNode.getAttribute("status"));
            int count = Utils.parseInt(limitNode.getAttribute("count"), 0);
            if (limit < 0) {
                this.limitDefault.setSelected(true);
                this.limitField.setEnabled(false);
            } else if (limit == 0) {
                this.limitOff.setSelected(true);
                this.limitField.setEnabled(false);
            } else {
                this.limitPersonal.setSelected(true);
                this.limitField.setEnabled(true);
                this.limitField.setText(String.valueOf(limit));
            }
            if (configLimit == 0) {
                this.limitDefault.setText("\u041e\u0431\u0449\u0438\u0439 (\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d)");
            } else {
                this.limitDefault.setText("\u041e\u0431\u0449\u0438\u0439  (" + configLimit + ")");
            }
            if (status == 0) {
                this.label.setText("     " + String.valueOf(count) + "     ");
            } else {
                this.label.setText(count + " [\u0437\u0430\u0431\u043b\u043e\u043a.]");
            }
            StringBuilder builder = new StringBuilder();
            Element lastLogon = XMLUtils.selectElement(doc, "//lastLogon");
            if (lastLogon == null) {
                builder.append("\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
                this.unlockButton.setVisible(false);
            } else {
                String ip = lastLogon.getAttribute("ip");
                String datetime = lastLogon.getAttribute("datetime");
                int counter = Utils.parseInt(lastLogon.getAttribute("counter"), -1);
                if (counter == 0) {
                    builder.append("\u0421\u0442\u0430\u0442\u0443\u0441: OK \u0432 ");
                    builder.append(datetime);
                    builder.append(" \u0441 ");
                    builder.append(ip);
                    this.unlockButton.setVisible(false);
                } else if (counter > 0) {
                    builder.append("\u0421\u0442\u0430\u0442\u0443\u0441: \u041e\u0428\u0418\u0411\u041a\u0410 (\u043f\u043e\u0434\u0440\u044f\u0434 \u0440\u0430\u0437: ");
                    builder.append(counter);
                    builder.append(") \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0432 ");
                    builder.append(datetime);
                    builder.append(" \u0441 ");
                    builder.append(ip);
                    this.unlockButton.setVisible(true);
                }
            }
            this.lastLogonLabel.setText(builder.toString());
        }
    }
}

