/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.common.XMLUtils;

public class AddressList {
    private Map<Integer, Map<Integer, Map<String, String>>> values = new HashMap<Integer, Map<Integer, Map<String, String>>>();

    public AddressList(Node node) {
        this.values.clear();
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node item = list.item(i);
            int id = XMLUtils.getAttributeIntValue(item, "id", -1);
            int cityid = XMLUtils.getAttributeIntValue(item, "cityid", -1);
            Map<Integer, Map<String, String>> mapList = this.values.get(cityid);
            if (mapList == null) {
                mapList = new LinkedHashMap<Integer, Map<String, String>>();
                this.values.put(cityid, mapList);
            }
            HashMap<String, String> val = new HashMap<String, String>();
            NamedNodeMap amap = item.getAttributes();
            for (int j = 0; j < amap.getLength(); ++j) {
                Node attr = amap.item(j);
                val.put(attr.getNodeName(), attr.getNodeValue());
            }
            mapList.put(id, val);
        }
    }

    public Map<Integer, Map<String, String>> getForCity(int cityId) {
        LinkedHashMap<Integer, Map<String, String>> res = new LinkedHashMap<Integer, Map<String, String>>();
        Map<Integer, Map<String, String>> val = this.values.get(cityId);
        if (val != null) {
            res.putAll(val);
        }
        return res;
    }

    public Map<String, String> getAddressById(int addressId) {
        Map<String, String> res = null;
        for (Integer cityid : this.values.keySet()) {
            for (Integer id : this.values.get(cityid).keySet()) {
                if (addressId != id) continue;
                return this.values.get(cityid).get(id);
            }
        }
        return res;
    }

    public void buildComboBox(BGComboBox<ComboBoxItem> comboBox, int cityId, boolean anyItem, boolean notItem) {
        this.buildComboBox(comboBox, cityId, anyItem, "\u043b\u044e\u0431\u043e\u0439", notItem, "-----", null);
    }

    public void buildComboBox(BGComboBox<ComboBoxItem> comboBox, int cityId, boolean anyItem, boolean notItem, String selected) {
        this.buildComboBox(comboBox, cityId, anyItem, "\u043b\u044e\u0431\u043e\u0439", notItem, "-----", selected);
    }

    public void buildComboBox(BGComboBox<ComboBoxItem> comboBox, int cityId, boolean anyItem, String anyTitle, boolean notItem, String notTitle, String selected) {
        ComboBoxItem comboBoxItem;
        comboBox.removeAllItems();
        Map<Integer, Map<String, String>> map = this.getForCity(cityId);
        if (map == null) {
            return;
        }
        DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
        if (anyItem) {
            comboBoxItem = new ComboBoxItem("-1", anyTitle);
            model.addElement(comboBoxItem);
        }
        if (notItem) {
            comboBoxItem = new ComboBoxItem("0", notTitle);
            model.addElement(comboBoxItem);
        }
        for (Integer id : map.keySet()) {
            Map<String, String> val = map.get(id);
            String title = val.get("title");
            ComboBoxItem item = new ComboBoxItem(id.toString(), title);
            for (String key : val.keySet()) {
                item.put(key, val.get(key));
            }
            model.addElement(item);
            if (selected == null || !selected.equals(id.toString())) continue;
            model.setSelectedItem(item);
        }
        comboBox.setModel(model);
    }
}

