/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.util;

import bitel.billing.module.common.BGFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class GetDigest
extends BGFrame {
    private static GetDigest getDigest = null;
    private static char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    JTextField digestValue = new JTextField();
    JComboBox<String> charset = new JComboBox();
    JComboBox<String> algorithm = new JComboBox();
    JTextArea text = new JTextArea();

    public GetDigest() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.charset.addItem("UTF-8");
        this.charset.addItem("Cp1251");
        this.charset.addItem("KOI8-R");
        for (String charsetName : Charset.availableCharsets().keySet()) {
            if ("UTF-8".equals(charsetName) || "KOI8-R".equals(charsetName)) continue;
            this.charset.addItem(charsetName);
        }
        for (Provider provider : Security.getProviders()) {
            for (Provider.Service service : provider.getServices()) {
                if (!"MessageDigest".equals(service.getType())) continue;
                this.algorithm.addItem(service.getAlgorithm());
            }
        }
        this.pack();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() throws Exception {
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), " \u0422\u0435\u043a\u0441\u0442 ");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), " Digest ");
        this.text.setText("");
        this.text.setColumns(80);
        this.text.setLineWrap(true);
        this.text.setRows(15);
        this.text.setTabSize(8);
        this.text.setWrapStyleWord(true);
        this.text.setMargin(new Insets(3, 3, 3, 3));
        JButton jButton1 = new JButton();
        jButton1.setText("\u0412\u044b\u0447\u0438\u0441\u043b\u0438\u0442\u044c");
        jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetDigest.this.jButton1_actionPerformed(e);
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setText("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GetDigest.this.jButton2_actionPerformed(e);
            }
        });
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setBorder(titledBorder1);
        jPanel1.add((Component)new JLabel("\u041a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel1.add(this.charset, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        jPanel1.add((Component)new JScrollPane(this.text), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(titledBorder2);
        jPanel2.add((Component)this.digestValue, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        jPanel2.add(this.algorithm, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jButton1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jButton2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setTitle(" \u0412\u044b\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \"digest\"");
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.getContentPane().add((Component)jPanel3, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
    }

    void jButton1_actionPerformed(ActionEvent e) {
        StringBuffer passwdDigest = new StringBuffer();
        try {
            String algorithmValue = (String)this.algorithm.getSelectedItem();
            MessageDigest digest = MessageDigest.getInstance(algorithmValue);
            digest.update(this.text.getText().getBytes((String)this.charset.getSelectedItem()));
            byte[] digestBytes = digest.digest();
            for (int i = 0; i < digestBytes.length; ++i) {
                passwdDigest.append(HEX[(digestBytes[i] & 0xF0) >> 4]);
                passwdDigest.append(HEX[digestBytes[i] & 0xF]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.digestValue.setText(passwdDigest.toString());
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.setVisible(false);
        this.dispose();
    }

    public static GetDigest newInstance() {
        if (getDigest == null) {
            getDigest = new GetDigest();
        }
        return getDigest;
    }
}

