/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.renderer;

import java.awt.Component;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import ru.bitel.common.Utils;

public class DecimalTableCellRenderer
extends DefaultTableCellRenderer {
    private static final String PATTERN = "###,###,###,##0";
    public static final Supplier<TableCellRenderer> DEFAULT = () -> new DecimalTableCellRenderer(Utils.getDecimalFormatSumma());
    public static final Supplier<TableCellRenderer> INTEGER = () -> new DecimalTableCellRenderer(PATTERN);
    private DecimalFormat formatter = null;

    public DecimalTableCellRenderer(String pattern) {
        this(new DecimalFormat(pattern));
    }

    public DecimalTableCellRenderer(DecimalFormat formatter) {
        this(formatter, 4);
    }

    public DecimalTableCellRenderer(DecimalFormat formatter, int horizontalAlignment) {
        this.formatter = formatter;
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public static DecimalTableCellRenderer DEFAULT() {
        return new DecimalTableCellRenderer(Utils.getDecimalFormatSumma());
    }

    public static DecimalTableCellRenderer INTEGER() {
        return new DecimalTableCellRenderer(PATTERN);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Double) {
            this.setText((String)(value == null ? "" : this.formatter.format((Double)value) + " "));
        } else if (value instanceof String) {
            BigDecimal a = null;
            try {
                a = new BigDecimal((String)value);
                this.setText(this.formatter.format(a));
            }
            catch (Exception e) {
                this.setText((String)value);
            }
        } else if (value instanceof BigDecimal) {
            this.setText(value == null ? "" : this.formatter.format((BigDecimal)value));
        } else if (value instanceof Integer) {
            this.setText(value == null ? "" : this.formatter.format((Integer)value));
        } else if (value instanceof Long) {
            this.setText(value == null ? "" : this.formatter.format((Long)value));
        } else {
            super.setValue(value);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        return this;
    }
}

