/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.webmenu.client;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.kernel.admin.webmenu.client.WebMenuTree;
import ru.bitel.bgbilling.kernel.admin.webmenu.client.WebMenuUserObject;

public class WebMenuTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent component) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        DefaultMutableTreeNode treeNode;
        TreePath treePath;
        WebMenuUserObject transferable = null;
        if (component instanceof WebMenuTree && (treePath = ((WebMenuTree)component).getSelectionPath()) != null && (treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()) != null && !treeNode.isRoot()) {
            transferable = (WebMenuUserObject)treeNode.getUserObject();
        }
        return transferable;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if ((action & 2) == 0) {
            super.exportDone(source, data, action);
        }
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        boolean canImport = false;
        support.setShowDropLocation(true);
        JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
        Component component = support.getComponent();
        if (dropLocation != null && component instanceof WebMenuTree) {
            WebMenuTree tree;
            TreePath treePath = dropLocation.getPath();
            canImport = treePath != null ? !(tree = (WebMenuTree)component).getSelectionPath().isDescendant(treePath) : true;
        }
        return canImport;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        boolean result = false;
        if (this.canImport(support)) {
            WebMenuTree tree = (WebMenuTree)support.getComponent();
            JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
            TreePath treePath = dropLocation.getPath();
            if (treePath != null) {
                DefaultMutableTreeNode newMenuItemTreeNode = (DefaultMutableTreeNode)tree.getSelectionPath().getLastPathComponent();
                DefaultMutableTreeNode menuItemTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object userObject = menuItemTreeNode.getUserObject();
                if (userObject instanceof WebMenuUserObject) {
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)tree.getModel();
                    if (dropLocation.getChildIndex() == -1) {
                        DefaultMutableTreeNode parent = menuItemTreeNode;
                        if (((WebMenuUserObject)userObject).getElement().getNodeName().equals("item")) {
                            parent = (DefaultMutableTreeNode)menuItemTreeNode.getParent();
                        }
                        this.moveTreeNode(defaultTreeModel, newMenuItemTreeNode, parent, 0);
                    } else {
                        this.moveTreeNode(defaultTreeModel, newMenuItemTreeNode, menuItemTreeNode, dropLocation.getChildIndex());
                    }
                    tree.expandPath(new TreePath(menuItemTreeNode.getPath()));
                    tree.scrollPathToVisible(new TreePath(menuItemTreeNode.getPath()));
                    result = true;
                }
                tree.aa("changeData");
            }
        }
        return result;
    }

    private void moveTreeNode(DefaultTreeModel defaultTreeModel, DefaultMutableTreeNode newChild, DefaultMutableTreeNode parent, int index) {
        DefaultMutableTreeNode aa = (DefaultMutableTreeNode)newChild.clone();
        defaultTreeModel.insertNodeInto(aa, parent, index);
        for (int i = newChild.getChildCount(); i > 0; --i) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)newChild.getChildAt(i - 1);
            this.moveTreeNode(defaultTreeModel, treeNode, aa, 0);
        }
        defaultTreeModel.removeNodeFromParent(newChild);
    }
}

