/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.auth;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.auth.ModuleAuth;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class AuthModes {
    private static Logger log = LogManager.getLogger();
    private static final String passwordless = Utils.randomAlphanumeric(64);

    public static long loadConfig(Setup setup, long setupInitDate, Map<Integer, List<Integer>> authModes) {
        if (setupInitDate < setup.getInitDate().getTime()) {
            HashMap newAuthModes = new HashMap();
            String modes = setup.get("web.auth.modes", null);
            if (modes != null) {
                String[] parts = modes.split(";");
                for (int i = 0; i < parts.length; ++i) {
                    String[] mid_mode = parts[i].split(":");
                    if (mid_mode.length != 2) continue;
                    int mid = Utils.parseInt(mid_mode[0].trim(), 0);
                    int mode = Utils.parseInt(mid_mode[1].trim(), 0);
                    if (!newAuthModes.containsKey(mid)) {
                        newAuthModes.put(mid, new ArrayList());
                    }
                    ((List)newAuthModes.get(mid)).add(mode);
                }
            }
            if (authModes != null) {
                authModes.clear();
                authModes.putAll(newAuthModes);
            }
            if (log.isDebugEnabled()) {
                log.debug("Web auth modes:");
                for (Map.Entry<Integer, List<Integer>> me : authModes.entrySet()) {
                    log.debug("\t" + me.getKey() + " => " + me.getValue());
                }
            }
            setupInitDate = setup.getInitDate().getTime();
        }
        return setupInitDate;
    }

    public static ModuleUser findModuleUserUserByLogin(String login, String authModuleId, Map<Integer, List<Integer>> authModes) {
        ModuleUser moduleUser = null;
        List<Integer> midAuthList = Utils.toIntegerList(authModuleId);
        if (midAuthList.size() == 0) {
            midAuthList.add(0);
        }
        block2: for (int moduleId : midAuthList) {
            int authMode;
            List<Integer> authModeList = authModes.get(moduleId);
            if (authModeList == null) continue;
            Iterator<Integer> iterator = authModeList.iterator();
            while (iterator.hasNext() && (authMode = iterator.next().intValue()) != 0) {
                try {
                    moduleUser = AuthModes.findModuleUserUserByLogin(login, moduleId, authMode);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (moduleUser == null) continue;
                break block2;
            }
        }
        return moduleUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleUser findModuleUserUserByLogin(String login, int moduleId, Integer authMode) {
        ModuleUser moduleUser;
        block8: {
            moduleUser = null;
            Setup setup = Setup.getSetup();
            Connection conSlave = setup.getDBSlaveConnectionFromPool();
            try {
                if (moduleId == 0) {
                    String className = setup.get("web.auth.class", ModuleAuth.class.getName());
                    bitel.billing.server.ModuleAuth ma = Class.forName(className).asSubclass(bitel.billing.server.ModuleAuth.class).getConstructor(new Class[0]).newInstance(new Object[0]);
                    moduleUser = ma.findModuleUserByLogin(login, moduleId, authMode.intValue(), conSlave);
                    break block8;
                }
                if (moduleId <= 0) break block8;
                BGModule module = ModuleCache.getInstance().getModule(moduleId);
                if (module == null) {
                    throw new BGException("Not found module with id=" + moduleId);
                }
                bitel.billing.server.ModuleAuth ma = ModuleCache.getInstance().getAuthModule(module.getName());
                if (ma != null) {
                    moduleUser = ma.findModuleUserByLogin(login, moduleId, authMode.intValue(), conSlave);
                    break block8;
                }
                throw new BGException("Not found module auth for module " + moduleId);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                ServerUtils.closeConnection((Connection)conSlave);
            }
        }
        return moduleUser;
    }

    public static String passwordless() {
        return passwordless;
    }
}

