/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.client.CostMapTreeEditor;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.CostMap;
import ru.bitel.bgbilling.modules.voiceip.common.service.VoiceIpService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public abstract class ServiceConfigCostMap
extends ServiceConfigTabbedPanel {
    private BGEditor bgEditor;
    CostMapTable table;
    private CostMapTreeEditor costMapTreeEditor;

    public ServiceConfigCostMap() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void jbInit() {
        this.bgEditor = new BGEditor("table");
        this.setLayout(new BorderLayout());
        this.add((Component)this.bgEditor, "Center");
        this.bgEditor.addPropertyChangeListener("edit", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Boolean.FALSE.equals(evt.getNewValue())) {
                    ServiceConfigCostMap.this.setData();
                }
            }
        });
        this.table = new CostMapTable();
        this.bgEditor.addForm(this.table);
        this.costMapTreeEditor = new CostMapTreeEditor(this);
        this.bgEditor.addForm(this.costMapTreeEditor);
    }

    @Override
    public void setData() {
        this.table.setData();
    }

    @Override
    public void deleteItem() {
        this.bgEditor.performAction("delete");
    }

    @Override
    public void editItem() {
        this.bgEditor.performAction("edit");
    }

    @Override
    public void newItem() {
        this.bgEditor.performAction("new");
    }

    protected abstract List<CostMap> getCostMapList();

    class CostMapTable
    extends BGUPanel {
        BGTableModel<CostMap> model;
        private BGUTable table;
        private BGEditor bgEditor;
        private CostMapEditor costMapEditor;

        public CostMapTable() {
            super(new GridBagLayout());
            this.setName("table");
            this.build();
        }

        @Override
        protected void jbInit() {
            this.model = new BGTableModel<CostMap>("costMap"){

                @Override
                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u041a\u0430\u0440\u0442\u0430 \u0446\u0435\u043d", -1, 150, -1, "title", true);
                }
            };
            this.table = new BGUTable(this.model);
            this.table.setSelectionMode(0);
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ServiceConfigCostMap.this.costMapTreeEditor.setData();
                    }
                }
            });
            this.costMapEditor = new CostMapEditor();
            this.bgEditor = new BGEditor();
            this.bgEditor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
            this.bgEditor.addForm(this.costMapEditor, "editor");
            this.bgEditor.setVisible(false);
            this.bgEditor.addPropertyChangeListener("edit", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CostMapTable.this.table.setEnabled((Boolean)evt.getOldValue());
                    if (Boolean.FALSE.equals(evt.getNewValue())) {
                        ServiceConfigCostMap.this.setData();
                    }
                }
            });
            this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            this.add((Component)this.bgEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        }

        public void setData() {
            try {
                this.model.setData(((ClientContext)this.getContext()).getWebService(VoiceIpService.class).costMapList(null));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
    }

    private class CostMapEditor
    extends BGUPanel {
        private int currentId;
        private BGTextField title;

        private CostMapEditor() {
        }

        @Override
        protected void jbInit() {
            this.title = new BGTextField();
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 5), 0, 0));
            this.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 0, 3, 3), 0, 0));
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("ok", "OK"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    try {
                        ((ClientContext)CostMapEditor.this.getContext()).getWebService(VoiceIpService.class).costMapUpdate(CostMapEditor.this.currentId, CostMapEditor.this.title.getText());
                        CostMapEditor.this.performActionClose();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("new", "new"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    CostMapEditor.this.currentId = -1;
                    CostMapEditor.this.title.setText("");
                    CostMapEditor.this.performActionOpen();
                }
            };
            new AbstractBGUPanel.DefaultAction("edit", "edit"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    CostMap costMap = ServiceConfigCostMap.this.table.model.getSelectedRow();
                    if (costMap != null) {
                        CostMapEditor.this.currentId = costMap.getId();
                        try {
                            costMap = ((ClientContext)CostMapEditor.this.getContext()).getWebService(VoiceIpService.class).costMapGet(CostMapEditor.this.currentId);
                            if (costMap != null) {
                                CostMapEditor.this.title.setText(costMap.getTitle());
                                CostMapEditor.this.performActionOpen();
                            }
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog(ex);
                        }
                    }
                }
            };
            new AbstractBGUPanel.DefaultAction("delete", "delete"){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws BGException {
                    CostMap costMap = ServiceConfigCostMap.this.table.model.getSelectedRow();
                    if (costMap != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u0443 \u0446\u0435\u043d?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f", 0) == 0) {
                        try {
                            ((ClientContext)CostMapEditor.this.getContext()).getWebService(VoiceIpService.class).costMapDelete(costMap.getId());
                            ServiceConfigCostMap.this.setData();
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog(ex);
                        }
                    }
                }
            };
        }
    }
}

