/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.client.GroupEditor;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserGroup;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserGroupService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public class GroupManager
extends BGUPanel {
    private BGUTable table = null;
    private GroupEditor editor = null;
    private JPanel rightPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private GroupTableModel groupTableModel = new GroupTableModel();
    private UserGroupService userGroupService = null;

    @Override
    protected void jbInit() throws Exception {
        this.table = new BGUTable(this.groupTableModel);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (GroupManager.this.table.isEnabled() && event.getClickCount() == 2) {
                    GroupManager.this.performAction("edit");
                }
            }
        });
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.setBorder(new BGTitleBorder(" \u0413\u0440\u0443\u043f\u043f\u044b "));
        leftPanel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0433\u0440\u0443\u043f\u043f\u0443"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.rightPanel.setLayout(this.cardLayout);
        this.rightPanel.add((Component)labelPanel, "label");
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, leftPanel, (Component)this.rightPanel, 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.cardLayout.show(this.rightPanel, "label");
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                try {
                    GroupManager.this.groupTableModel.setData(GroupManager.this.getUserGroupService().getUserGroupList(true));
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog(e);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                try {
                    int id = GroupManager.this.userGroupService.updateUserGroup(new UserGroup(0, "\u041d\u043e\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430"));
                    GroupManager.this.groupTableModel.setData(GroupManager.this.getUserGroupService().getUserGroupList(true));
                    GroupManager.this.edit(id);
                }
                catch (BGException e) {
                    ClientUtils.showErrorMessageDialog(e);
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                UserGroup userGroup = (UserGroup)GroupManager.this.groupTableModel.getSelectedRow();
                if (userGroup != null) {
                    GroupManager.this.edit(userGroup.getId());
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                UserGroup userGroup = (UserGroup)GroupManager.this.groupTableModel.getSelectedRow();
                if (userGroup != null && ClientUtils.confirmDelete(userGroup.getTitle())) {
                    try {
                        GroupManager.this.getUserGroupService().deleteGroup(userGroup.getId());
                        GroupManager.this.groupTableModel.deleteRow(userGroup);
                    }
                    catch (BGException e) {
                        ClientUtils.showErrorMessageDialog(e);
                    }
                }
            }
        };
    }

    private UserGroupService getUserGroupService() {
        if (this.userGroupService == null) {
            this.userGroupService = ((ClientContext)this.getContext()).getPort(UserGroupService.class);
        }
        return this.userGroupService;
    }

    private void edit(int id) {
        if (this.editor == null) {
            this.editor = new GroupEditor(this);
            this.rightPanel.add((Component)this.editor, "editor");
            this.editor.init(((ClientContext)this.getContext()).getModule(), ((ClientContext)this.getContext()).getModuleId());
        }
        this.editor.setId(id);
        this.editor.setData();
        this.table.setEnabled(false);
        this.cardLayout.show(this.rightPanel, "editor");
    }

    public void hideEditorPanel() {
        this.table.setEnabled(true);
        this.cardLayout.show(this.rightPanel, "label");
    }

    class GroupTableModel
    extends BGTableModel<UserGroup> {
        private static final String COLUMN_TITLE = "title";
        private static final String COLUMN_USERS = "users";

        public GroupTableModel() {
            super("userAdminGroup");
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, COLUMN_TITLE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439", 120, 120, 120, COLUMN_USERS, true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
        }
    }
}

