/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.period.client;

import bitel.billing.module.common.BGControlPanelDateWithTime;
import bitel.billing.module.contract.ContractSubPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.period.common.bean.ContractPeriod;
import ru.bitel.bgbilling.kernel.contract.period.common.service.ContractPeriodService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class ContractSubPanel_Period
extends ContractSubPanel {
    private BGUTable table = null;
    private JLabel recordCount = new JLabel();
    private ContractPeriodService contractPeriodService = null;
    private BGControlPanelPages pages = new BGControlPanelPages();
    private ContractPeriodTableModel tableModel = new ContractPeriodTableModel(ContractPeriodTableModel.class.getName());

    public ContractSubPanel_Period() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            this.getContext().processException(e);
        }
    }

    private void jbInit() throws Exception {
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getFilterPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getTablePanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getFilterPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.recordCount, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        this.table = new BGUTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ContractPeriod contractPeriod;
                if (mouseEvent.getClickCount() == 2 && (contractPeriod = (ContractPeriod)ContractSubPanel_Period.this.tableModel.getSelectedRow()) != null) {
                    ContractSubPanel_Period.this.getEditorDialog(contractPeriod).setVisible(true);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void setData() {
        try {
            SearchResult<ContractPeriod> searchResult = this.getContractPeriodService().searchContractPeriodList(this.getContractId(), this.table.getSort(), this.pages.getPage());
            Page page = searchResult.getPage();
            this.pages.setPage(page);
            this.recordCount.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger(page.getRecordCount()));
            this.tableModel.setData(searchResult.getList());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    @Override
    public void newItem() {
        ContractPeriod contractPeriod = new ContractPeriod();
        contractPeriod.setContractId(this.getContext().getContractId());
        this.getEditorDialog(contractPeriod).setVisible(true);
    }

    @Override
    public void editItem() {
        ContractPeriod contractPeriod = (ContractPeriod)this.tableModel.getSelectedRow();
        if (contractPeriod == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        this.getEditorDialog(contractPeriod).setVisible(true);
    }

    @Override
    public void deleteItem() {
        try {
            ContractPeriod contractPeriod = (ContractPeriod)this.tableModel.getSelectedRow();
            if (contractPeriod == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (JOptionPane.showConfirmDialog(BGClient.getFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0443\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0443\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430", 2) == 0) {
                this.getContractPeriodService().deleteContractPeriod(contractPeriod.getId());
                this.setData();
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    private JDialog getEditorDialog(ContractPeriod contractPeriod) {
        BGControlPanelDateWithTime periodFrom = new BGControlPanelDateWithTime();
        BGControlPanelDateWithTime periodTo = new BGControlPanelDateWithTime();
        JCheckBox generateCloseEvent = new JCheckBox("\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430: "), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)periodFrom, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430: "), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)periodTo, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 5, 0), 0, 0));
        panel.add((Component)generateCloseEvent, new GridBagConstraints(0, gridy, 2, 1, 0.0, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(1, gridy++, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        PeriodWithTime period = contractPeriod.getPeriod();
        periodFrom.setDate(period != null ? period.getDateFrom() : null);
        periodTo.setDate(period != null ? period.getDateTo() : null);
        generateCloseEvent.setSelected(contractPeriod.isGenerateCloseEvent());
        BGOptionPane optionPane = new BGOptionPane((Object)panel, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0443\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
        JDialog dialog = optionPane.getDialog();
        ((JButton)optionPane.getOptions()[0]).addActionListener(e -> {
            if (periodFrom.getDate() != null && periodTo.getDate() != null) {
                if (periodTo.getDate().after(periodFrom.getDate())) {
                    PeriodWithTime periodWithTime = new PeriodWithTime();
                    periodWithTime.setLocalDateTimeFrom(TimeUtils.convertDateToLocalDateTime(periodFrom.getDate()));
                    periodWithTime.setLocalDateTimeTo(TimeUtils.convertDateToLocalDateTime(periodTo.getDate()));
                    contractPeriod.setPeriod(periodWithTime);
                    contractPeriod.setGenerateCloseEvent(generateCloseEvent.isSelected());
                    try {
                        this.getContractPeriodService().updateContractPeriod(contractPeriod);
                        dialog.setVisible(false);
                        this.setData();
                        dialog.dispose();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                } else {
                    JOptionPane.showMessageDialog(BGClient.getFrame(), "\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0443\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0414\u041e \u0432\u0440\u0435\u043c\u0435\u043d\u0438 \u0435\u0433\u043e \u043d\u0430\u0447\u0430\u043b\u0430!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                }
            } else {
                Object message = "\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d";
                message = periodFrom.getDate() == null && periodTo.getDate() == null ? (String)message + "\u044b \u043e\u0431\u0435 \u0433\u0440\u0430\u043d\u0438\u0446\u044b" : (String)message + "\u0430 \u043e\u0434\u043d\u0430 \u0438\u0437 \u0433\u0440\u0430\u043d\u0438\u0446";
                message = (String)message + " \u043f\u0435\u0440\u0438\u043e\u0434\u0430";
                JOptionPane.showMessageDialog(BGClient.getFrame(), message, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            }
        });
        return dialog;
    }

    private ContractPeriodService getContractPeriodService() {
        if (this.contractPeriodService == null) {
            this.contractPeriodService = this.getContext().getPort(ContractPeriodService.class);
        }
        return this.contractPeriodService;
    }

    class ContractPeriodTableModel
    extends BGTableModel<ContractPeriod> {
        private Directory<UserInfo> directory;

        public ContractPeriodTableModel(String name) {
            super(name);
            this.directory = null;
            try {
                this.directory = ContractSubPanel_Period.this.getContext().getDirectory(UserInfo.class, 0);
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog(e);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", 200, 200, 200, "periodFrom", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", 200, 200, 200, "periodTo", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f", 150, 150, 150, "generateCloseEvent", true);
            this.addColumn("\u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e", 150, 150, 150, "sentCloseEvent", true);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 200, 200, -1, "userId", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f/\u043f\u0440\u0430\u0432\u043a\u0438", 180, 180, 180, "lastUpdate", true).setTableCellRenderer(DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
        }

        @Override
        public Object getValue(ContractPeriod contractPeriod, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("periodFrom".equals(identifier)) {
                PeriodWithTime period = contractPeriod.getPeriod();
                return period != null ? period.getDateFrom() : null;
            }
            if ("periodTo".equals(identifier)) {
                PeriodWithTime period = contractPeriod.getPeriod();
                return period != null ? period.getDateTo() : null;
            }
            if ("periodTo".equals(identifier)) {
                PeriodWithTime period = contractPeriod.getPeriod();
                return period != null ? period.getDateTo() : null;
            }
            if ("userId".equals(identifier)) {
                UserInfo userInfo = this.directory.get(contractPeriod.getUserId());
                return userInfo != null ? userInfo.getName() : "??? [ID=" + contractPeriod.getUserId() + "]";
            }
            return super.getValue(contractPeriod, column);
        }
    }
}

