/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.search.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import ru.bitel.bgbilling.kernel.contract.search.common.SearchImplementation;

public class SearchPopup
extends JPopupMenu {
    private ActionListener popupItemClickListener;

    protected SearchPopup(ActionListener itemClickListener) {
        this.setBackground(Color.WHITE);
        this.popupItemClickListener = itemClickListener;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int selectedIndex = SearchPopup.this.getSelectionModel().getSelectedIndex();
                int itemsCount = SearchPopup.this.getComponentCount();
                if (e.getKeyCode() == 38) {
                    if (selectedIndex == -1 || selectedIndex == 0) {
                        SearchPopup.this.getSelectionModel().setSelectedIndex(itemsCount - 1);
                    } else {
                        SearchPopup.this.getSelectionModel().setSelectedIndex(--selectedIndex);
                    }
                } else if (e.getKeyCode() == 40) {
                    if (selectedIndex == itemsCount - 1 || selectedIndex == -1) {
                        SearchPopup.this.getSelectionModel().setSelectedIndex(0);
                    } else {
                        SearchPopup.this.getSelectionModel().setSelectedIndex(++selectedIndex);
                    }
                }
            }
        });
    }

    protected void setItems(List<SearchImplementation> searchImplClasses) {
        this.removeAll();
        searchImplClasses.forEach(implClazz -> {
            SearchMenuItem menuItem = new SearchMenuItem(implClazz.getTitle(), (SearchImplementation)implClazz);
            menuItem.setBackground(Color.WHITE);
            menuItem.addActionListener(this.popupItemClickListener);
            this.add(menuItem);
        });
    }

    protected SearchImplementation getItem(int index) {
        try {
            Component component = this.getComponent(index);
            if (component instanceof SearchMenuItem) {
                return ((SearchMenuItem)component).getImplementation();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setSize(Dimension sizeSearchPopup) {
        this.setMinimumSize(sizeSearchPopup);
        this.setPreferredSize(sizeSearchPopup);
        this.setPreferredSize(sizeSearchPopup);
    }

    static class SearchMenuItem
    extends JMenuItem {
        SearchImplementation implementation;

        SearchMenuItem(String text, SearchImplementation implementation) {
            super(text);
            this.implementation = implementation;
        }

        public SearchImplementation getImplementation() {
            return this.implementation;
        }
    }
}

