/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server;

import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class DatabaseClassLoader
extends ClassLoader {
    public DatabaseClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Connection con = null;
        try {
            String packageName;
            con = Setup.getSetup().getDBConnectionFromPool();
            byte[] classData = new DynamicCodeDao(con).getClassData(name);
            if (classData == null) {
                throw new ClassNotFoundException(name);
            }
            int i = name.lastIndexOf(46);
            if (i != -1 && this.getPackage(packageName = name.substring(0, i)) == null) {
                this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            Class<?> clazz = this.defineClass(name, classData, 0, classData.length);
            return clazz;
        }
        catch (BGException ex) {
            throw new ClassNotFoundException(name);
        }
        finally {
            if (con != null) {
                ServerUtils.closeConnection((Connection)con);
            }
        }
    }
}

